#!/usr/bin/env bash
# Helper to run the light_show test via uv
# Usage: ./run_test_light_show.sh --ip 192.168.4.69 --duration 6 --transition 1 --off-flash --verbose
set -euo pipefail
ROOT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")/.." && pwd)"
SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
SCRIPT="$SCRIPT_DIR/light_show.py"

if command -v uv >/dev/null 2>&1; then
  exec uv run --project "$ROOT_DIR" python "$SCRIPT" "$@"
fi

echo "uv not found. Install uv to run this script."
exit 1
