---
name: control-ikea-lightbulb
description: Control IKEA/TP-Link Kasa smart bulbs (set on/off, brightness, and color). Use when you want to programmatically control a local smart bulb by IP on the LAN.
---

# control-ikea-lightbulb

This skill provides a lightweight Python script to control a local smart bulb (supports TP-Link Kasa-compatible bulbs via python-kasa). It is intended for local LAN devices that do not require cloud credentials; control is by IP address.

When to use this skill
- When you want to turn a bulb on or off
- When you want to set brightness (0-100)
- When you want to set color (HSV)
- When you have the bulb's local IP and it's accessible from this machine

Contents
- scripts/control_kasa_light.py — main runnable script (Python 3.9+)
- scripts/light_show.py — small light-show controller for sequences (uses python-kasa). Changes include:
  - Default white uses a high color temperature (9000K) to make white appear "whiter"; pass --white-temp to override.
  - Bug fixes: the off-flash between blue→red now ignores transitions to white (saturation==0) to avoid white<->blue ping-pong, and white-temp is only applied to white steps (fixes red being skipped during off-flash). White steps also set brightness even without --double-write.
- scripts/run_test_light_show.sh — helper to run light_show via uv

Notes
- This repo is set up for uv (no manual environment activation). Dependencies live in `pyproject.toml` and wrappers prefer `uv run`.
  Example:
  uv run --project ./skills/control-ikea-lightbulb python ./skills/control-ikea-lightbulb/scripts/control_kasa_light.py --ip 192.168.4.69 --on --hsv 0 100 80 --brightness 80
- Install uv:
  - `brew install uv` (macOS)
  - `pipx install uv` (cross-platform)
- The provided wrapper script requires uv:
  ./skills/control-ikea-lightbulb/scripts/run_control_kasa.sh --ip 192.168.4.69 --on --hsv 0 100 80 --brightness 80
- The test helper also prefers uv:
  ./skills/control-ikea-lightbulb/scripts/run_test_light_show.sh --ip 192.168.4.69 --duration 6 --transition 1 --off-flash --verbose
- If your device is actually an IKEA TRADFRI device (not Kasa), this script is a starting point; tell me and I will add TRADFRI support.
- No cloud credentials are required; control happens over LAN to the device's IP.

Quick start
1. Install uv (macOS):
   `brew install uv`
2. Turn the bulb on (replace the IP):
   `./skills/control-ikea-lightbulb/scripts/run_control_kasa.sh --ip 192.168.4.69 --on`
3. Set color and brightness:
   `./skills/control-ikea-lightbulb/scripts/run_control_kasa.sh --ip 192.168.4.69 --hsv 0 100 80 --brightness 80`

Git note
- No local environment artifacts are tracked; use uv.

Note about Python requirements and recent change
- The skill previously declared python-kasa>=0.13.0 which caused dependency resolution failures on this machine. To make the skill runnable locally the project's pyproject.toml was adjusted to:
  - requires-python = ">=3.11, <4.0"
  - python-kasa>=0.10.2
- This allows the resolver to pick a compatible python-kasa on machines with Python 3.11+. If you prefer a different constraint (or want me to revert this change), tell me and I will update the pyproject.toml and README accordingly.
