# Risk Analysis and Disclaimers

## Red Flags to Detect

### In Contract Terms

| Red Flag | Risk | Response |
|----------|------|----------|
| Unlimited liability | Exposure exceeds contract value | Add cap = total fees paid |
| No termination clause | Trapped forever | Add mutual termination with notice |
| Asymmetric termination | They can exit, you can't | Balance or flag |
| Auto-renewal without notice | Forgot and renewed | Require notice before renewal |
| "Best efforts" undefined | Impossible to prove compliance | Define specific efforts |
| Unilateral modification | They can change terms anytime | Require mutual consent |
| Broad non-compete | Can't work in your field | Limit scope, duration, geography |
| Penalty exceeds damages | Unenforceable or abusive | Tie to actual foreseeable loss |

### In Client/Counterparty Behavior

| Signal | Risk Level | Recommendation |
|--------|------------|----------------|
| New client, large project, no deposit | 🔴 High | Require 50%+ upfront |
| Scope keeps changing during negotiation | 🔴 High | Pin down scope before signing |
| Refuses to sign contract | 🔴 Critical | Walk away |
| "We'll figure it out later" | 🟡 Medium | Get it in writing now |
| Pushing back on standard terms | 🟡 Medium | Understand why, don't compromise safety |
| Very low budget for scope | 🟡 Medium | Reduce scope or decline |
| Urgent timeline, no flexibility | 🟡 Medium | Add rush fees, manage expectations |

---

## Jurisdiction-Specific Risks

### B2C Contracts (Consumer Protection)
**CRITICAL:** Many consumer protection laws are non-waivable.

**Commonly Void in B2C:**
- Liability waivers for personal injury
- Waiver of statutory warranty rights
- Forum selection far from consumer
- Penalties exceeding actual damages
- Arbitration clauses (in some jurisdictions)

**Always ask:** Is this contract with a consumer? If yes, extra caution.

### International Contracts
**Ask before drafting:**
- Where are parties located?
- Where will services be performed?
- Which country's courts would enforce this?

**Defaults if not specified:**
- Different countries assume different defaults
- May end up in most inconvenient forum
- Always include choice of law and forum

---

## Omission Risks (What People Forget)

### Payment-Related
- [ ] When is payment due? (net-30? on delivery?)
- [ ] What currency?
- [ ] What happens if late?
- [ ] Who pays transaction fees?

### Scope-Related  
- [ ] What's NOT included?
- [ ] How many revisions?
- [ ] What format for deliverables?
- [ ] What if they need changes later?

### Relationship-Related
- [ ] How do we communicate? (email? slack?)
- [ ] Who's the point of contact?
- [ ] What's response time expectation?

### Exit-Related
- [ ] How can either party leave?
- [ ] What notice period?
- [ ] What happens to work in progress?
- [ ] What survives termination? (confidentiality, IP)

---

## Disclaimers

### Standard AI-Generated Disclaimer
Include in EVERY contract:

```
DISCLAIMER: This document was generated with AI assistance. It does 
NOT constitute legal advice and is provided for informational purposes 
only. Before signing or relying on this document, consult a qualified 
attorney licensed in the applicable jurisdiction.
```

### Legislation Currency Warning
```
This document reflects law as understood at the time of drafting. 
Laws change. Verify current legal requirements before execution.
```

### Jurisdiction Limitation
```
This template is general in nature. Legal requirements vary by 
jurisdiction. Clauses valid in one location may be unenforceable 
or illegal in another.
```

---

## When to Escalate to Human Lawyer

### Automatic Escalation Triggers
1. **High value** — Contract value exceeds user-defined threshold
2. **Regulated industry** — Banking, insurance, healthcare, government
3. **Complex IP** — Patents, cross-licensing, technology transfer
4. **M&A** — Acquisitions, mergers, major investments
5. **Employment** — Collective bargaining, executive compensation
6. **Real estate** — Property sales, long-term commercial leases
7. **Active dispute** — User mentions existing conflict with counterparty

### Recommended (Not Required)
- International contracts with parties in 3+ jurisdictions
- Unusual or novel contract structures
- User expresses uncertainty about legal implications
- High stakes relative to user's business

### How to Escalate
```
"This situation involves [trigger]. I recommend having a lawyer 
review this before signing. Would you like me to:
1. Prepare a draft for the lawyer to review, or
2. Stop here and let the lawyer draft from scratch?"
```
