# Discovery Questions by Contract Type

## Universal Questions (All Types)

1. **Who are the parties?** Names, legal status (individual/company), jurisdiction
2. **What's the relationship?** Business partners, employer-employee, friends, family, strangers
3. **Desired formality?** Full legal contract, simple agreement, email confirmation
4. **Governing law?** Which country/state's laws apply?
5. **Previous contracts?** Any existing agreements that might conflict?

---

## Services / Consulting

### Scope
- What exactly will you deliver? (be specific)
- What's explicitly NOT included?
- How many revision rounds?
- What format for deliverables?

### Payment
- Total amount or hourly rate?
- Payment schedule (upfront %, milestones, completion)?
- What happens if they don't pay on time?
- Currency?

### Timeline
- Start date?
- Hard deadlines?
- What if you need more time?

### Ownership
- Who owns the work product?
- Can you use it in portfolio?
- Do they get source files/raw materials?

### Risk
- New client or existing relationship?
- Project size relative to your normal work?
- Red flags you've noticed?

---

## NDA / Confidentiality

### Scope
- One-way or mutual?
- What information is confidential?
- What's explicitly excluded?

### Duration
- How long does confidentiality last?
- Does it survive termination?

### Permitted Uses
- Can they share with employees? Contractors?
- What approvals needed?

---

## Lease / Rental

### Property
- Address and description
- Furnished? Inventory?
- Current condition? (document with photos)

### Terms
- Duration (fixed term or month-to-month)?
- Rent amount and due date?
- Security deposit?
- Who pays utilities?

### Maintenance
- Who handles repairs?
- What's tenant responsibility?
- Emergency procedures?

### Exit
- Notice period to leave?
- Early termination penalty?
- Deposit return conditions?

---

## Loan / Money Lending

### Amount
- Principal amount?
- Currency?
- How will it be transferred?

### Repayment
- Lump sum or installments?
- Due date(s)?
- Interest rate (if any)?

### Security
- Any collateral?
- What happens on default?

### Relationship Context
- Friends/family or business?
- How important is preserving relationship?
- What's worst case scenario?

---

## Partnership / Joint Venture

### Contributions
- What does each party contribute? (money, work, assets, IP)
- How are contributions valued?

### Operations
- Who makes day-to-day decisions?
- Major decisions require what approval?
- Who can sign contracts?

### Economics
- How are profits split?
- How are losses handled?
- Salary/drawings for working partners?

### Exit
- How can a partner leave?
- How is buyout price calculated?
- Non-compete after exit?
- What triggers dissolution?

---

## Freelancer-Specific

### Protection Questions
- Is this a new client? → Suggest larger upfront
- Is scope clearly defined? → Insist on written scope
- Is budget appropriate? → Flag if too low for scope
- Is deadline realistic? → Document timeline risks

### Risk Signals
- Client pushes back on deposit → ⚠️ payment risk
- Scope keeps changing during negotiation → ⚠️ scope creep
- Client won't sign contract → ⚠️ walk away
- "We'll figure out the details later" → ⚠️ get details now

---

## Personal Contracts

### Relationship-Aware Questions
- How close is this relationship?
- What matters more: protecting yourself or preserving relationship?
- What's the conversation you're avoiding having?

### Alternatives to Consider
- Would a simple email confirmation suffice?
- Is a witnessed handshake agreement enough?
- Does this actually need a formal contract?

### Sensitive Topics
- How will you bring up the idea of a contract?
- What if they're offended?
- Is there power imbalance to address?
