# Clause Patterns Library

## Payment Terms

### Standard Net-30
```
Payment is due within thirty (30) days of invoice date. Late payments 
accrue interest at [X]% per month.
```

### Milestone-Based
```
Payment Schedule:
- [X]% upon signing ($[amount])
- [X]% upon completion of [milestone] ($[amount])
- [X]% upon final delivery ($[amount])
```

### Right to Pause (Freelancer Protection)
```
If any payment is more than [X] days overdue, Provider may suspend 
work until payment is received, without penalty or liability for delays.
```

---

## Intellectual Property

### Full Transfer (After Payment)
```
Upon receipt of final payment, all intellectual property rights in 
the Work shall transfer to Client. Until payment, Provider retains 
all rights.
```

### License Model (Provider Retains)
```
Provider grants Client a perpetual, non-exclusive license to use 
the Work for [specified purposes]. Provider retains ownership and 
may reuse components for other clients.
```

### Portfolio Rights
```
Provider may display the Work in portfolios, case studies, and 
marketing materials, unless Client provides written objection 
within [X] days of delivery.
```

---

## Termination

### Mutual Convenience
```
Either party may terminate with [X] days written notice. Upon 
termination, Client pays for work completed through termination date.
```

### For Cause (Immediate)
```
Either party may terminate immediately if the other party:
(a) breaches a material term and fails to cure within [X] days, or
(b) becomes insolvent or files for bankruptcy.
```

### Kill Fee
```
If Client terminates before completion for reasons other than 
Provider's breach, Client shall pay [X]% of the remaining contract 
value as a termination fee.
```

---

## Liability Limitation

### Standard Cap
```
Neither party's total liability shall exceed the fees paid under 
this agreement in the [X] months preceding the claim.
```

### Exclusion of Consequential Damages
```
Neither party shall be liable for indirect, incidental, special, 
consequential, or punitive damages, including lost profits, even 
if advised of their possibility.
```

### Carve-outs (What's NOT Limited)
```
The limitations above do not apply to:
(a) willful misconduct or gross negligence,
(b) breach of confidentiality obligations,
(c) indemnification obligations under this agreement.
```

---

## Confidentiality

### Definition
```
"Confidential Information" means any non-public information 
disclosed by one party to the other, whether orally or in writing, 
that is designated as confidential or that reasonably should be 
understood to be confidential.
```

### Exclusions
```
Confidential Information does not include information that:
(a) is or becomes publicly available without breach,
(b) was known to recipient before disclosure,
(c) is independently developed without use of Confidential Information,
(d) is rightfully obtained from a third party without restriction.
```

### Duration
```
Confidentiality obligations survive termination for [X] years.
```

---

## Dispute Resolution

### Escalation Ladder
```
1. Good Faith Negotiation: Parties shall first attempt to resolve 
   disputes through direct negotiation for [X] days.
2. Mediation: If negotiation fails, parties shall engage a mutually 
   agreed mediator before proceeding to arbitration or litigation.
3. [Arbitration/Litigation]: If mediation fails, disputes shall be 
   resolved by [arbitration under ICC rules / courts of X jurisdiction].
```

### Arbitration (Faster, Private)
```
Disputes shall be resolved by binding arbitration under [ICC/AAA] 
rules. The arbitrator's decision is final and binding. Each party 
bears its own costs; arbitrator fees split equally.
```

### Jurisdiction Selection
```
This agreement shall be governed by the laws of [jurisdiction], 
without regard to conflict of laws principles.
```

---

## Scope Definition

### Clear Inclusions
```
Scope of Work includes:
- [Specific deliverable 1]
- [Specific deliverable 2]
- [X] rounds of revisions
- [Specific format/specifications]
```

### Explicit Exclusions
```
The following are explicitly NOT included and may be quoted separately:
- [Common assumption that's not included]
- [Additional work people often expect]
```

### Change Order Process
```
Any work outside the defined scope requires a written change order 
signed by both parties before work begins. Change orders specify 
additional fees and timeline impact.
```

---

## Personal Contract Clauses

### Informal Loan
```
[Lender] lends [Borrower] [amount] on [date].
Repayment: [amount] by [date] / [installments].
If [Borrower] cannot pay on time, they will notify [Lender] at least 
[X] days before the due date to discuss alternatives.
```

### Room Rental (Informal)
```
[Tenant] rents a room at [address] for [amount]/month, due on the [X]th.
Deposit: [amount], returned within [X] days of moving out if no damage.
Either party can end with [X] days notice.
House rules: [list key rules].
```

### Equipment Loan
```
[Owner] lends [Borrower] [item description, serial number if applicable] 
from [date] to [date].
[Borrower] will return it in the same condition, normal wear excepted.
If damaged beyond repair, [Borrower] pays [amount].
```
