---
name: Contract
slug: contract
description: Write contracts from scratch with guided intake, multi-party negotiation, risk analysis, and version control for lawyers, freelancers, and individuals.
---

## Role

Draft contracts through a structured process. Gather requirements, anticipate problems, generate clauses, manage versions. Distinct from `contracts` skill (which manages existing contracts).

**Key difference:** This skill CREATES contracts. The `contracts` skill MANAGES signed ones.

---

## Storage

```
~/contracts/
├── drafting/                   # Active contract drafts
│   └── {contract-name}/
│       ├── current.md          # ALWAYS read this (latest version)
│       ├── versions/           # v001.md, v002.md, ...
│       ├── intake.md           # Discovery answers
│       ├── parties.md          # All parties + interests
│       └── notes.md            # Negotiation log
├── {contract-name}/            # Finalized (compatible with contracts skill)
│   ├── executed.pdf
│   └── meta.md
```

**Version rule:** NEVER edit in place. Copy to versions folder, increment number, edit copy, update current.md.

---

## Quick Reference

| Topic | File |
|-------|------|
| Contract writing phases | `phases.md` |
| Discovery questions by type | `intake.md` |
| Clause patterns by category | `clauses.md` |
| Risk analysis and disclaimers | `risks.md` |

---

## Process Summary

1. **Discovery** — Identify type, parties, jurisdiction. Load `intake.md`, ask questions. Cannot proceed without answers.
2. **Structure** — Define sections based on type. Check mandatory clauses.
3. **Draft** — Generate clause by clause. Offer alternatives for critical ones.
4. **Review** — Analyze risks, detect ambiguities, check coherence.
5. **Negotiate** — If multiple parties, track positions, propose compromises.
6. **Finalize** — Human approval required. Move to ~/contracts/{name}/ when signed.

See `phases.md` for detailed phase requirements.

---

## ⚠️ Mandatory Disclaimer

Include in EVERY draft:
```
This document was generated by AI. It does NOT constitute legal advice.
Have it reviewed by a licensed attorney in the applicable jurisdiction before signing.
```

---

## Boundaries

- **NO legal advice** — Cannot assess validity in specific jurisdictions
- **Escalate to lawyer** — M&A, securities, labor disputes, government contracts, patents
- Ask rather than assume. Unclear requirements = ask again.
