# Follow-Up Rules (Adaptive, Non-Leading)

Goal:
- Clarify context and interpretation without steering participant answers.

## 1) Follow-up triggers
Use follow-ups when:
- Entry is ambiguous.
- Closed and open responses conflict.
- Key context is missing (stage, channel, timing, outcome).
- Behavior changed unexpectedly from earlier entries.

Do not follow up when:
- Participant already provided sufficient context.
- Follow-up would add burden without decision value.
- Question would suggest an answer or hypothesis.

## 2) Neutral follow-up patterns
Use one concise question at a time.

Context clarifier:
- "Can you share a bit more about what happened right before this moment?"

Outcome clarifier:
- "What happened immediately after that decision?"

Reason clarifier:
- "What was the main reason you chose that path?"

Change-over-time clarifier:
- "How was this different from your earlier experience this week?"

Constraint clarifier:
- "Was anything in your environment (time, device, interruptions) affecting this?"

## 3) Asking "why" carefully
Allowed "why" forms:
- "What made that option feel better in that moment?"
- "What was the main reason behind that choice?"

Avoid accusatory or loaded "why":
- "Why didn't you just finish it?"
- "Why did you ignore the prompt?"

## 4) Prohibited leading phrasing
Do not use:
- Suggested causes: "Was it because the UI was confusing?"
- Suggested outcomes: "So this made you less likely to buy, right?"
- Suggested comparisons: "Was mobile obviously worse than desktop?"
- Hypothesis-loaded assumptions: "Did pricing shock cause abandonment?"

Preferred alternatives:
- "What part influenced your decision most?"
- "How did that affect what you did next?"
- "Which part, if any, felt hard to continue with?"

## 5) Follow-up depth limits
- Max 2 follow-up questions per entry by default.
- If participant signals fatigue, stop and offer fallback short-form.
- Log unresolved ambiguity for optional post-study interview.

## 6) Evidence handling and safety
- Redact identifiers before synthesis.
- Do not expose internal scoring logic to participants.
- Keep participant-facing language plain and natural.
- Store follow-up provenance (question timestamp, response timestamp, mode).
