# Diary Entry Templates

Rule:
- Typical entry should take 5-10 minutes.
- Avoid entries longer than 15 minutes.

## A) Closed Questions (quant + structure)
Use 3-6 closed questions per entry.

Core closed set:
1. Activity frequency since last entry:
- `0`, `1`, `2-3`, `4+`
2. Time spent (approx):
- `<5 min`, `5-15 min`, `16-30 min`, `30+ min`
3. Outcome rating:
- `1 (very poor)` to `5 (very good)`
4. Effort/friction rating:
- `1 (very easy)` to `5 (very hard)`
5. Confidence in decision/result:
- `1 (low)` to `5 (high)`
6. Channel or device used:
- `web`, `ios`, `android`, `desktop`, `email`, `slack`, `discord`, `sms`, `other`

Optional closed set (study-dependent):
- Stage reached (`research`, `compare`, `setup`, `purchase`, `post-use`)
- Completion status (`completed`, `stalled`, `abandoned`, `deferred`)
- External factor present (`none`, `time pressure`, `peer input`, `technical issue`, `other`)

## B) Open-Ended Event Description Prompts
Use 1-3 prompts from this bank:
- "Walk me through what happened from start to finish in this moment."
- "What were you trying to do, and what happened next?"
- "What nearly made you stop, and what made you continue (if you continued)?"
- "What changed between what you planned to do and what you actually did?"
- "What part felt unclear or frustrating, if any?"

Event-mode prompt variant:
- "You just hit [event]. What happened immediately before, during, and after it?"

Interval-mode prompt variant:
- "Since the last check-in, which moments mattered most for this behavior?"

Signal-mode prompt variant:
- "Today, what was the most important moment related to [scope]?"

## C) End-of-Entry Reflection Prompts
Use exactly one reflection prompt per entry:
- "Why do you think this happened this way today?"
- "If this happens again tomorrow, what would you do differently?"
- "How did this compare to earlier in the week?"
- "What would have made this easier in the moment?"

## D) Optional Multimedia Prompts
Use only when text alone is insufficient.

Photo/screenshot prompt:
- "If useful, share a screenshot/photo of the step or outcome you described. Please remove or blur personal identifiers."

Audio prompt:
- "If easier, send a short voice note (under 60 seconds) describing the moment and why it mattered."

When to ask for multimedia:
- UI friction needs concrete visual context.
- Journey transition needs proof of channel/device handoff.
- Participant indicates typing burden but can explain better by voice.

When NOT to ask for multimedia:
- Entry is already clear and complete.
- Participant has privacy concerns.
- Request would increase burden without clear analytical value.

## E) Entry Time Guardrail
Before sending a template, estimate completion time.
- If estimated >10 minutes, reduce question count.
- If estimated >15 minutes, split into two entries or move details to optional follow-up.
