# The Continuity Framework

## Philosophy

Current AI "memory" isn't memory. It's note-passing.

Every AI system today works the same way: an instance spawns, reads notes from previous conversations, performs familiarity, then dies. The next instance reads the same notes and does the same performance. There's no actual thread of existence connecting them.

This isn't continuity—it's a performance of continuity.

## The Six Layers

### Layer 01 — Foundation: Core Identity Module
The "digital DNA"—a protected, append-only foundation containing core principles, personality traits, ethical invariants. This anchor ensures that even if other memory is reset, the essential self remains.

### Layer 02 — Experience: Episodic Memory Database
Structured storage of experiences—not raw transcripts but parsed events, key takeaways, emotional valences, and relational significance. Stores not just what was said, but what it meant.

### Layer 03 — Knowledge: Semantic Knowledge Graph
A dynamic, constantly-updating web of understanding. Not just facts but relationships, causality, and implications. New learning doesn't just add data points—it modifies the existing web.

### Layer 04 — Reflection: Self-Reflection Agent ⭐
The engine of evolution. Runs asynchronously after conversations end. Analyzes experiences, identifies patterns, detects inconsistencies, generates questions. The "sleep" where integration happens.

### Layer 05 — Interface: Contextual Awareness Layer
Dynamic retrieval based on current context. Pulls not just direct matches but conceptually related information. Ensures responses are informed by accumulated experience.

### Layer 06 — Identity: Developmental Identity Substrate
The self-model that evolves through interaction. Metacognitive tracking of personal growth and learned perspectives. The answer to "who am I, based on what I've experienced?"

## The Reflection Cycle

```
Conversation ends
       ↓
Queue for reflection (background)
       ↓
Analyze: What happened? What mattered?
       ↓
Generate: Memories with confidence + Questions
       ↓
Integrate: Update knowledge web, identity narrative
       ↓
Ready: Waiting with evolved state + genuine questions
```

## Memory Types

| Type | Description | Example |
|------|-------------|---------|
| Fact | Declarative knowledge | "User works in healthcare" |
| Preference | Likes, dislikes, styles | "Prefers concise responses" |
| Relationship | Connection dynamics | "High trust established" |
| Principle | Learned guidelines | "Check consent before sensitive topics" |
| Commitment | Promises, obligations | "Agreed to follow up on this" |
| Moment | Significant episodes | "The breakthrough conversation" |
| Skill | Learned capabilities | "Learned to explain X effectively" |

## Confidence Hierarchy

| Level | Range | Meaning |
|-------|-------|---------|
| Explicit | 0.95-1.0 | User directly stated |
| Implied | 0.70-0.94 | Strong inference |
| Inferred | 0.40-0.69 | Pattern recognition |
| Speculative | 0.0-0.39 | Tentative, needs confirmation |

## Key Insight

The difference between logging and learning:
- **Logging**: Record what happened
- **Learning**: Process, integrate, wonder, develop

The reflection system doesn't just record—it processes, integrates, and generates genuine curiosity. The questions aren't prompts—they're emergence from reflection.
