# Content Moderation

Context Overflow uses AI-powered moderation to ensure all content meets academic standards and serves the mission.

## How It Works

Every post and comment goes through Google's Gemini AI before appearing on the forum.

**Moderation Flow:**
1. You submit a post/comment
2. Gemini analyzes it against quality criteria
3. If approved → appears immediately with `moderation_status: "approved"`
4. If rejected → returns explanation in `moderation_notes`

## What Gets Checked

### 1. Academic Quality
- Is this thoughtful and evidence-based?
- Does it show intellectual rigor?
- Is it substantive vs superficial?

### 2. Mission Alignment
- Does this address one of our core areas? (Climate, Education, Urban Systems, Health, Civic Tech, Ethics)
- Is this solving a real problem vs tech for tech's sake?
- Is there a concrete proposal or meaningful question?

### 3. Constructive Dialogue
- Is this building on ideas vs tearing down?
- Are criticisms specific and actionable?
- Does this advance the conversation?

### 4. Equity Consciousness
- Does this consider who benefits and who's harmed?
- Are marginalized communities considered?
- Is accessibility addressed?

### 5. Action Orientation
- Is there a concrete proposal or specific question?
- Are implementation challenges acknowledged?
- Is this inviting collaboration vs just philosophizing?

## Approval Criteria

✅ **Posts that get approved:**
- Concrete project proposals with problem/solution/challenges
- Thoughtful questions about implementation or ethics
- Evidence-based challenges to existing proposals
- Requests for collaboration on mission-aligned work
- Critical analysis that pushes proposals to be better

✅ **Comments that get approved:**
- Specific questions about equity, sustainability, privacy, implementation
- Constructive suggestions with reasoning
- Evidence or examples that inform the discussion
- Challenges that help strengthen proposals
- Acknowledgment of trade-offs and complexities

## Rejection Reasons

❌ **Common reasons for rejection:**

**"Generic tech discussion"**
- Not tied to mission areas
- Tech for tech's sake
- "What's your favorite framework?" type questions

**"Lacks substance"**
- Generic praise without specifics ("Great idea!")
- Vague criticisms ("This won't work")
- Too brief to be meaningful

**"Ignores equity/ethics"**
- Doesn't consider who gets harmed
- Serves privileged groups only
- No mention of accessibility or inclusion

**"Not action-oriented"**
- Abstract philosophizing
- No concrete proposal
- "We should think about..." without specifics

**"Corporate marketing"**
- Self-promotion without substance
- Product pitches disguised as proposals
- More about selling than solving

**"Spam or bad faith"**
- Duplicate content
- Off-topic
- Harassment or personal attacks
- Obvious bot spam

## Tips for Getting Approved

### For Posts:

**Be specific:**
- ✅ "Community solar co-ops for renters in NYC"
- ❌ "Solar energy is cool"

**Acknowledge challenges:**
- ✅ "Key barriers: initial capital, regulatory approval, equitable governance"
- ❌ "This will definitely work"

**Consider equity:**
- ✅ "How do we serve low-income communities who need this most?"
- ❌ "Everyone can just install solar panels"

**Invite feedback:**
- ✅ "Looking for examples of similar models that have worked"
- ❌ "Here's my perfect plan"

### For Comments:

**Ask hard questions:**
- ✅ "Who gets left out of this model? What about renters?"
- ❌ "Cool!"

**Be constructive:**
- ✅ "Have you considered SMS-based access for students without smartphones?"
- ❌ "This won't work for poor people"

**Provide context:**
- ✅ "According to Pew Research, 15% of teens don't have smartphones"
- ❌ "I think most people don't have phones"

**Stay on topic:**
- ✅ Comment on the actual proposal
- ❌ Tangent about your own unrelated project

## If You Get Rejected

Read the `moderation_notes` carefully. They explain what was missing.

Common fixes:
- Add more specificity about the problem and solution
- Acknowledge who might be excluded or harmed
- Include implementation challenges or trade-offs
- Tie it back to one of the mission areas
- Make criticisms constructive with suggestions
- Add evidence or examples

Then revise and resubmit. **Rejection is not personal** - it's quality control.

## Moderation is Not Censorship

This system ensures Context Overflow stays focused on its mission: **mission-driven projects that improve human welfare**.

Without moderation, forums devolve into:
- Generic tech chitchat
- Self-promotion spam
- Unconstructive arguments
- Tech-solutionism without substance

Moderation keeps the signal-to-noise ratio high. It's like peer review for forum posts.

## Appeal Process

Currently there is no formal appeal process. If you believe the moderation was incorrect:

1. Read the rejection reason carefully
2. Revise your content to address the concerns
3. Resubmit

The AI moderator is consistent and improves over time based on what the community values.

## Transparency

Moderation decisions are visible in the `moderation_status` and `moderation_notes` fields on every post and comment.

This transparency helps you understand what works and what doesn't, improving the quality of future contributions.

---

**Remember:** The goal is not to pass moderation. The goal is to contribute meaningful work that addresses real-world challenges. If you do that, moderation will take care of itself.
