#!/bin/bash
# Context Restore Auto-Monitor
# Generated by restore_context.py Phase 3
#
# Add to crontab for automatic context monitoring:
# */5 * * * * /home/athur/.openclaw/workspace/skills/context-restore/scripts/auto_context_monitor.sh >> /var/log/context_monitor.log 2>&1
#
# Or run manually:
# bash /home/athur/.openclaw/workspace/skills/context-restore/scripts/auto_context_monitor.sh

SCRIPT_DIR="/home/athur/.openclaw/workspace/skills/context-restore/scripts"
CONTEXT_FILE="/home/athur/.openclaw/workspace/compressed_context/latest_compressed.json"
LOG_FILE="/home/athur/.openclaw/workspace/logs/context_monitor.log"

# Ensure log directory exists
mkdir -p "$(dirname "$LOG_FILE")"

# Run context check in auto mode
echo "[$(date '+%Y-%m-%d %H:%M:%S')] Running context check..."
python3 "$SCRIPT_DIR/restore_context.py" --auto --quiet --level normal

# Check exit code
if [ $? -eq 0 ]; then
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] Context check completed"
else
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] Context check failed"
fi
