# Context Manager v2.0.0 - 发布说明

## 🎉 重大更新：无感会话切换

### 核心突破
- ⭐ **自动创建新会话**：无需用户/new，系统自动切换
- ⭐ **零用户干预**：完全自动化，对话无中断
- ⭐ **无缝体验**：新会话自动加载记忆，就像没切换

### 新功能
1. **agentTurn机制**
   - 自动创建isolated会话
   - 新会话自动加载MEMORY.md
   - 自然接续对话

2. **智能记忆传递**
   - 自动提取会话关键信息
   - 保存到MEMORY.md + daily log
   - 保存当前任务状态

3. **双重保险**
   - 外部监控：每10分钟检查
   - 未来：AI内部检测（每次回复）

### 改进
- 阈值降低：95% → 85%（提前预警）
- 监控频率：1小时 → 10分钟
- 用户体验：手动提醒 → 自动切换

### 技术架构
```
外部监控（定时任务）
  ↓
检查上下文使用率
  ↓
超过85%
  ↓
保存记忆
  ↓
触发agentTurn
  ↓
创建新会话
  ↓
加载记忆继续
```

### 安装方式
```bash
# ClawHub安装（推荐）
clawhub install miliger-context-manager

# 手动安装
cd ~/.openclaw/skills
tar -xzf context-manager-v2.0.0.tar.gz
cd context-manager-v2
bash install.sh
```

### 使用方式
**完全无感 - 正常对话即可**

系统会自动：
- 监控上下文使用率
- 在85%时保存记忆
- 创建新会话
- 加载记忆继续工作

用户只需要继续聊天，其他一切自动完成。

### 兼容性
- ✅ OpenClaw 2026.3.0+
- ✅ QQ Bot
- ✅ 所有消息渠道

### 文件清单
- SKILL.md：技能说明（完整文档）
- README.md：快速开始
- install.sh：安装脚本
- scripts/seamless-switch.sh：核心脚本
- package.json：包信息
- RELEASE-NOTES.md：本文件

### 下一步计划
- [ ] 实现AI内部检测（每次回复检查）
- [ ] 智能任务识别（避免关键任务中断）
- [ ] 用户自定义配置
- [ ] 多会话管理

---

**发布时间**：2026-03-04
**版本**：2.0.0
**作者**：米粒儿
**许可**：MIT

**让上下文管理像呼吸一样自然** 🌟
