# Tech Stack

## Languages

| Language | Version | Purpose |
|----------|---------|---------|
| [e.g., TypeScript] | [e.g., 5.x] | [e.g., Primary application code] |
| [e.g., Python] | [e.g., 3.12+] | [e.g., Build scripts, data processing] |

## Frameworks

| Framework | Version | Purpose |
|-----------|---------|---------|
| [e.g., Next.js] | [e.g., 14.x] | [e.g., React framework, SSR] |
| [e.g., FastAPI] | [e.g., 0.110+] | [e.g., API backend] |

## Key Dependencies

| Package | Version | Purpose |
|---------|---------|---------|
| [e.g., zod] | [e.g., ^3.23] | [e.g., Schema validation] |
| [e.g., prisma] | [e.g., ^5.15] | [e.g., Database ORM] |

## Infrastructure

| Component | Technology | Notes |
|-----------|------------|-------|
| Database | [e.g., PostgreSQL 16] | [e.g., Primary data store] |
| Hosting | [e.g., Vercel] | [e.g., Frontend and API] |
| CI/CD | [e.g., GitHub Actions] | [e.g., Automated testing and deploy] |

## Development Tools

| Tool | Purpose |
|------|---------|
| [e.g., pnpm] | Package manager |
| [e.g., ESLint + Prettier] | Linting and formatting |
| [e.g., Vitest] | Unit testing |

## Constraints

- [e.g., Must support Node.js 20+ for deployment target]
- [e.g., No runtime dependencies over 100KB for bundle size]
- [e.g., All database queries must use parameterized inputs]
