class Digest {
  constructor(config = {}) {
    this.style = config.summaryStyle || 'bullet';
  }

  generate(articles) {
    const date = new Date().toLocaleDateString('zh-CN', {
      year: 'numeric',
      month: 'long',
      day: 'numeric',
      weekday: 'long'
    });

    let md = `# 📰 每日资讯摘要\n\n`;
    md += `**生成时间**: ${date}  \n`;
    md += `**文章数量**: ${articles.length} 篇  \n\n`;
    md += `---\n\n`;

    // Group by source
    const bySource = {};
    articles.forEach(a => {
      if (!bySource[a.source]) bySource[a.source] = [];
      bySource[a.source].push(a);
    });

    Object.entries(bySource).forEach(([source, items]) => {
      md += `## 📡 ${source}\n\n`;
      
      items.forEach((article, idx) => {
        md += `### ${idx + 1}. ${article.title}\n\n`;
        md += `**链接**: [阅读原文](${article.link})  \n`;
        md += `**作者**: ${article.author}  \n`;
        md += `**时间**: ${this.formatDate(article.pubDate)}  \n\n`;
        
        if (article.summary) {
          md += `**摘要**:\n${article.summary}\n\n`;
        }
        
        md += `---\n\n`;
      });
    });

    md += `\n*Generated by Content Watcher*  \n`;
    md += `*Powered by OpenClaw* 🐾`;

    return md;
  }

  formatDate(dateStr) {
    try {
      const d = new Date(dateStr);
      return d.toLocaleDateString('zh-CN');
    } catch {
      return dateStr;
    }
  }
}

module.exports = Digest;
