---
name: content-watcher
description: AI-powered content monitoring and summarization tool. Monitor RSS feeds, blogs, and news sources with automatic AI summarization and daily digest generation.
metadata:
  {
    "openclaw":
      {
        "emoji": "📰",
        "requires": { "bins": ["node", "npm"] },
        "install":
          [
            {
              "id": "npm",
              "kind": "node",
              "package": "content-watcher",
              "bins": ["content-watcher"],
              "label": "Install Content Watcher CLI",
            },
          ],
      },
  }
---

# Content Watcher

Monitor any RSS feeds, blogs, or news sources and get AI-powered daily digests.

## Quick Start

```bash
# Install dependencies
npm install

# Add your first source
content-watcher add https://techcrunch.com/feed/ --name "TechCrunch"

# Run once to test
content-watcher run

# Save digest to file
content-watcher run --output digest.md
```

## Commands

| Command | Description |
|---------|-------------|
| `add <url>` | Add a source to monitor |
| `remove <id>` | Remove a source |
| `list` | List all sources |
| `run` | Generate digest now |
| `config` | Show configuration |

## Features

- ✅ RSS/Atom feed parsing
- ✅ Web content extraction
- ✅ AI text summarization (local, no API key)
- ✅ Markdown digest generation
- ✅ Multi-source aggregation
- ✅ Duplicate detection
- ✅ Configurable via CLI

## Configuration

Config stored at `~/.config/content-watcher/config.json`:

```json
{
  "sources": [...],
  "delivery": "console",
  "summaryStyle": "bullet",
  "maxItemsPerSource": 5
}
```

## Use Cases

1. **Competitive Intelligence** - Monitor competitor blogs/news
2. **Industry Trends** - Track tech/finance/marketing trends
3. **Research Assistant** - Aggregate academic/sources
4. **Content Curation** - Create newsletters automatically

## Integration

Works great with:
- Feishu webhook (auto-post digest)
- Email delivery (send digest)
- Cron scheduling (daily runs)
