---
name: content-strategy
description: Build and execute a content marketing strategy for a solopreneur business. Use when planning what content to create, deciding on content formats and channels, building a content calendar, measuring content performance, or systematizing content production. Covers audience research for content, content pillars, distribution strategy, repurposing workflows, and metrics. Trigger on "content strategy", "content marketing", "what content should I create", "content plan", "content calendar", "content ideas", "content distribution", "grow through content".
---

# Content Strategy

## Overview
Content marketing is how solopreneurs build authority, attract customers, and grow without paid ads. But random content doesn't work — you need a strategy. This playbook builds a repeatable system for creating content that actually drives business results, not just likes.

---

## Step 1: Define Your Content Goals

Content without a goal is just noise. Before you create anything, answer: what is this content supposed to DO?

**Common solopreneur content goals:**
- **Generate awareness** (new people discover you exist)
- **Build trust** (people see you as credible and knowledgeable)
- **Drive leads** (people give you their email or book a call)
- **Enable sales** (content answers objections and shortens sales cycles)
- **Retain customers** (existing customers stay engaged and see ongoing value)

**Rule:** Pick ONE primary goal per piece of content. You can have secondary benefits, but clarity on the main goal determines format, channel, and CTA.

Example: A tutorial blog post might have the primary goal of "generate awareness" (via SEO) and a secondary goal of "drive leads" (with an email signup CTA at the end).

---

## Step 2: Research Your Audience's Content Needs

Great content solves a specific problem for a specific person. Bad content talks about what YOU want to talk about.

**Research workflow (spend 2-3 hours on this before creating anything):**

1. **Mine customer conversations.** Go through support tickets, sales calls, discovery calls. What questions do prospects and customers ask repeatedly? Those are your content topics.

2. **Check competitor content.** What are the top 3-5 players in your space publishing? Look for gaps — topics they're NOT covering or covering poorly.

3. **Keyword research (if doing SEO).** Use free tools (Google autocomplete, AnswerThePublic, or "People Also Ask" in Google results) to see what people are actually searching for related to your niche.

4. **Community mining.** Go to Reddit, Slack communities, Facebook groups, or forums in your space. What questions get asked over and over? Those are high-value topics.

**Output:** A list of 20-30 content ideas ranked by: (a) relevance to your ICP, (b) search volume or community demand, (c) your unique perspective or experience on the topic.

---

## Step 3: Build Content Pillars

Content pillars are 3-5 broad topic areas that all your content falls under. They keep you focused and prevent random one-off content that doesn't build momentum.

**How to define pillars:**
- Each pillar should map to a core problem your product/service solves or a key interest area of your ICP.
- Pillars should be broad enough to generate dozens of pieces of content but specific enough to be relevant.
- Aim for 3-5 pillars max. More than that dilutes focus.

**Example (for an n8n automation consultant):**
```
Pillar 1: Workflow Automation Fundamentals
Pillar 2: No-Code Tool Comparisons
Pillar 3: Business Process Optimization
Pillar 4: Real Client Case Studies
```

Every piece of content you create should fit under one of these pillars. If it doesn't, don't create it.

---

## Step 4: Choose Your Content Formats and Channels

Solopreneurs can't do everything. Pick 1-2 primary formats and 1-2 primary channels. Go deep, not wide.

**Content formats:**
| Format | Best For | Time Investment | Longevity |
|---|---|---|---|
| **Blog posts** | SEO, teaching, depth | 2-4 hrs/post | High (evergreen) |
| **Videos (YouTube)** | Visual topics, personality-driven brands | 3-6 hrs/video | High (evergreen) |
| **Podcasts** | Thought leadership, interviews | 2-3 hrs/episode | Medium |
| **Twitter/X threads** | Quick insights, community building | 30 min/thread | Low (24-48hr shelf life) |
| **LinkedIn posts** | B2B, professional content | 30-60 min/post | Low-medium |
| **Email newsletters** | Relationship building, owned audience | 1-2 hrs/newsletter | Medium (subscribers keep it) |
| **Short-form video (TikTok, Reels)** | Viral potential, younger demos | 1-2 hrs/video | Low (algorithmic churn) |

**Selection criteria:**
- Where does your ICP hang out? (B2B = LinkedIn. Developers = Twitter. Visual products = Instagram.)
- What format do you NOT hate creating? (If you hate being on camera, don't pick YouTube.)
- What has the best ROI for your goals? (Lead gen = blog + email. Brand building = Twitter + LinkedIn.)

**Recommended solopreneur starting stack:**
- **Primary format:** Blog posts or long-form LinkedIn posts (depending on B2B vs B2C)
- **Secondary format:** Email newsletter (this is your owned channel — never skip this)

---

## Step 5: Build a Content Calendar

A content calendar prevents the "what should I post today?" panic. Plan 2-4 weeks ahead.

**Calendar structure:**
```
DATE | PILLAR | TOPIC | FORMAT | CHANNEL | CTA | STATUS
```

**Example:**
```
Feb 10 | Automation | "5 n8n workflows every SaaS founder needs" | Blog | Website + LinkedIn | Email signup | Draft
Feb 13 | Case Study | "How we saved Client X 20hrs/week" | LinkedIn post | LinkedIn | Book a call | Scheduled
Feb 17 | Tool Comparison | "Zapier vs n8n: Which is right for you?" | Blog | Website + Twitter | Free guide download | Outline
```

**Cadence recommendations:**
- Blog: 1-2x/week (minimum 2x/month to maintain SEO momentum)
- Newsletter: 1x/week or biweekly (consistency matters more than frequency)
- Social (LinkedIn/Twitter): 3-5x/week

**Rule:** Batch creation. Write 4 posts in one sitting rather than 1 post four different days. Batching is 3x faster and produces better quality.

---

## Step 6: Distribution and Amplification

Creating content is 30% of the work. Distribution is the other 70%.

**Distribution checklist for every piece:**
- [ ] Publish on primary channel (blog, YouTube, etc.)
- [ ] Share on 2-3 social channels with unique captions per platform (don't just copy-paste the same message)
- [ ] Send to email list (if it's a high-value piece)
- [ ] Post in 1-2 relevant communities (but add value to the discussion, don't just drop links)
- [ ] DM it to 3-5 people who you think would find it genuinely useful
- [ ] Repurpose into 2-3 other formats (see next step)

**Timing:** Publish early in the week (Tuesday-Thursday) for best engagement. Avoid Fridays and weekends unless your audience is specifically active then.

---

## Step 7: Repurpose Everything

One piece of long-form content can become 5-10 smaller pieces. This is how solopreneurs produce high volume without burning out.

**Repurposing workflow (example: one blog post):**
1. Original: 1,500-word blog post
2. Repurpose into: LinkedIn post (first 3 paragraphs + a hook)
3. Repurpose into: Twitter thread (key points broken into 8-10 tweets)
4. Repurpose into: Email newsletter (add a personal intro, link to full post)
5. Repurpose into: Carousel post (main points as slides on LinkedIn or Instagram)
6. Repurpose into: Short video (you on camera summarizing the key takeaway in 60 seconds)

**Rule:** Repurpose the high-performers. If a blog post gets good traffic or a LinkedIn post gets strong engagement, milk it — turn it into 5 more formats.

---

## Step 8: Measure What Matters

Track content performance so you can double down on what works and stop doing what doesn't.

**Metrics by goal:**

| Goal | Metrics to Track |
|---|---|
| Awareness | Impressions, reach, new visitors, social followers |
| Trust | Engagement rate (comments, shares), time on page, repeat visitors |
| Lead generation | Email signups, CTA clicks, lead magnet downloads |
| Sales enablement | Content assists (how many deals involved this content?), proposal open rates (if content is attached) |

**Dashboard (monthly check-in):**
- Top 5 performing pieces (by traffic or engagement)
- Traffic source breakdown (organic, social, direct, referral)
- Conversion rate (visitors → email signups or leads)
- Time investment vs results (which content type has the best ROI?)

**Iteration rule:** Every month, identify the top-performing content type and topic. Do 2x more of that next month. Identify the worst performer. Stop doing that format or adjust the approach.

---

## Content Strategy Mistakes to Avoid
- Creating content without a goal. Every piece should have a purpose tied to a business outcome.
- Not researching what your audience actually wants. Your assumptions are often wrong — validate with real data.
- Trying to be on every platform. Pick 1-2 and dominate them before expanding.
- Publishing inconsistently. One post a month doesn't build momentum. Consistency compounds.
- Not repurposing. Creating 10 original pieces is 5x harder than creating 2 original pieces and repurposing them into 8 more.
- Ignoring metrics. If you don't measure, you can't improve. Check your numbers monthly at minimum.
