---
name: content-repurposer
description: Transform long-form content into multiple formats for distribution. Automatically converts blog posts, articles, or transcripts into Twitter/X threads, LinkedIn posts, email newsletters, and social media snippets. Use when you need to maximize content reach without rewriting from scratch, when repurposing webinar transcripts, or when creating a content calendar from existing assets.
---

# Content Repurposer

Turn one piece of content into many. This skill extracts key insights from long-form content and reformats them for different platforms and audiences.

## What It Does

- **Blog Post → Twitter/X Thread**: Breaks long articles into 280-character chunks with hooks
- **Article → LinkedIn Post**: Professional tone, storytelling format, engagement prompts
- **Transcript → Newsletter**: Key takeaways, section headers, call-to-action
- **Video → Social Snippets**: Timestamped quotes, audiograms (text-based), carousel ideas
- **Podcast → Show Notes**: Summary, timestamps, key quotes, resources

## Quick Start

### 1. Repurpose a Blog Post

Paste your blog post and specify target formats:

```
"Repurpose this blog post into a Twitter thread and LinkedIn post:
[paste content]

Target audience: SaaS founders
Tone: Educational but conversational
Include: 2-3 engagement questions"
```

### 2. Batch Repurpose from URL

```
"Repurpose the content at https://example.com/blog-post into:
1. A 5-tweet Twitter thread
2. A LinkedIn post with bullet points
3. An email newsletter subject line + preview

Style: Thought leadership
CTA: Subscribe to newsletter"
```

### 3. Podcast/Video Transcript

```
"Turn this transcript into show notes and 3 social snippets:
[paste transcript]

Host: [name]
Guest: [name]
Episode topic: [topic]"
```

## Output Formats

### Twitter/X Thread
- Hook tweet (attention-grabbing opener)
- 3-7 value tweets (key insights)
- Closing tweet with CTA
- Optional: Engagement tweet (question/poll)

### LinkedIn Post
- Hook (personal story or bold statement)
- 3-5 bullet points or short paragraphs
- Insight/wrap-up
- Engagement question
- Relevant hashtags (3-5)

### Newsletter
- Subject line options (3 variants)
- Preview text
- Opening hook
- 3-5 key sections with headers
- Resource links
- CTA block

### Social Snippets
- Quote cards (text for image overlay)
- Carousel slide ideas (5-7 slides)
- Short-form video scripts (15-30 sec)

## Advanced Usage

### Content Calendar Generation

```
"From this one blog post, create a 2-week content calendar:
- Week 1: Twitter thread (Monday), LinkedIn (Wednesday), Newsletter snippet (Friday)
- Week 2: Quote graphics (Tuesday), Carousel post (Thursday), Engagement question (Saturday)

Include posting times and platform-specific formatting."
```

### Multi-Language Repurposing

```
"Repurpose this content for [language] audience:
- Translate the core message
- Adapt cultural references
- Adjust tone for [region] business culture
- Output: LinkedIn post + Twitter thread"
```

### Tone Adaptation

Available tones:
- **Professional**: Corporate, authoritative, data-driven
- **Conversational**: Friendly, approachable, story-driven
- **Edgy/Bold**: Contrarian, provocative, meme-aware
- **Educational**: Tutorial-style, step-by-step, helpful
- **Inspirational**: Motivational, aspirational, emotional

## Best Practices

1. **Start with quality source material** — garbage in, garbage out
2. **Specify your audience** — the more specific, the better the output
3. **Include context** — your expertise angle, unique insights, personal experience
4. **Review and personalize** — add your voice, examples, and stories
5. **Test hooks** — the first line determines everything; generate 3-5 options

## Platform-Specific Tips

### Twitter/X
- Front-load value in first tweet
- Use line breaks for readability
- End with engagement question
- Avoid external links in first tweet (algorithm preference)

### LinkedIn
- Lead with personal experience or contrarian take
- Use short paragraphs (1-2 sentences)
- Include white space for mobile readability
- Tag relevant people sparingly

### Newsletter
- Subject line is 80% of the battle — test multiple
- Preview text should complement, not repeat subject
- One clear CTA per email
- Mobile-optimize (most opens are on phone)

## Common Patterns

### The "One Idea, Five Formats" Workflow

1. **Original**: Long-form blog post (2000 words)
2. **Twitter**: 7-tweet thread with key insights
3. **LinkedIn**: Personal story + 3 lessons learned
4. **Newsletter**: Curated roundup with original as feature
5. **Instagram**: Carousel with 5 slides (visual summary)
6. **TikTok/Reels**: 3 video scripts (15s each)

### The "Evergreen Content" Workflow

1. Identify your top-performing content (use analytics)
2. Update with new data/examples
3. Repurpose with current trends/angles
4. Schedule for optimal times
5. Cross-promote across platforms

## Integration Ideas

- Pair with **seo-content-engine** to optimize repurposed content for search
- Use with **client-intake-bot** to capture leads from engagement
- Connect to **proposal-generator** when content attracts consulting inquiries
- Track ROI with **invoice-tracker** when content drives revenue

## Monetization Note

This skill is part of the **Content Creator Suite**. For maximum value, use alongside:
- `seo-content-engine` — ensure repurposed content ranks
- `client-intake-bot` — capture leads from viral content

Bundle available: Content Creator Suite ($79)
