---
name: content-remix-studio
description: Transform one piece of content into platform-optimized versions for YouTube, TikTok, Twitter/X, LinkedIn, Instagram, newsletters, and blogs. Adapts tone, format, length, and style for each platform's algorithm and audience expectations.
metadata:
  openclaw:
    emoji: "🎬"
    version: "1.0.0"
    author: "AM"
    tags: ["content-creation", "social-media", "repurposing", "marketing", "video", "writing", "creator-economy"]
    requires:
      bins: []
      env: []
      config: []
---

# Content Remix Studio

## Description

Content Remix Studio is the ultimate content repurposing engine for creators, marketers, and brands. Take one piece of content (video script, blog post, podcast transcript, presentation) and intelligently transform it into platform-optimized versions for YouTube, TikTok, Instagram, Twitter/X, LinkedIn, blogs, and newsletters—each with the right tone, format, length, and hook for maximum engagement.

Stop recreating content from scratch. Start remixing strategically.

## The Problem This Solves

Content creators face a brutal dilemma:
- **Creating for one platform** = Limited reach, wasted potential
- **Recreating for every platform** = Exhausting, time-consuming, expensive
- **Copy-pasting everywhere** = Poor performance, algorithm penalties, low engagement

The answer? **Strategic remixing** with platform intelligence.

## Core Capabilities

### 1. Multi-Platform Transformation
Take one source content and generate:
- **YouTube** (long-form): Title, description, timestamps, chapters, pinned comment
- **TikTok/Reels/Shorts** (15-60s): Hook-first script, visual cues, trending sounds
- **Twitter/X Thread**: 8-15 tweet thread, quote-tweets, engagement prompts
- **LinkedIn Article**: Professional tone, industry insights, call-to-action
- **Instagram Carousel**: 10-slide story arc, visual text, swipe prompts
- **Blog Post**: SEO-optimized article, meta description, headers
- **Newsletter**: Email-friendly format, personal tone, clickable structure
- **Podcast Script**: Conversational flow, intro/outro, ad break placements

### 2. Platform-Specific Optimization

**YouTube Strategy:**
- Title psychology (curiosity gaps, numbers, power words)
- Description optimization (first 3 lines, keywords, timestamps)
- Thumbnail concepts (contrast, faces, text overlay)
- Engagement hooks (ask to subscribe at X:XX)
- Retention tactics (pattern interrupts, callbacks)

**TikTok/Short-Form Strategy:**
- Hook in first 3 seconds (scroll-stopping opening)
- Visual storytelling cues (text overlays, transitions)
- Trending sound integration suggestions
- Call-to-action timing (7-second rule)
- Loop-ability for algorithm boost

**Twitter/X Strategy:**
- Thread structure (numbered tweets, emotional arc)
- Engagement bait (questions, polls, hot takes)
- Quote-tweetable moments
- Reply-seeding strategy
- Viral mechanics (controversy, relatability, data)

**LinkedIn Strategy:**
- Professional hook (industry insight, data-driven)
- Story structure (challenge → insight → lesson)
- Authority building (credentials, experience)
- Engagement prompts (agree/disagree, share experience)
- Hashtag strategy (3-5 relevant tags)

**Instagram Strategy:**
- Carousel storytelling (problem → steps → result)
- Visual hierarchy (text size, color, whitespace)
- Swipe prompts ("See next slide for...")
- Story highlights tie-in
- Saveable/shareable formats

### 3. Tone & Voice Adaptation

Automatically adjust content personality for each platform:
- **YouTube**: Enthusiastic, detailed, educational
- **TikTok**: Casual, Gen-Z humor, fast-paced
- **Twitter**: Witty, conversational, hot-take ready
- **LinkedIn**: Professional, thoughtful, industry-focused
- **Instagram**: Aesthetic, aspirational, community-focused
- **Blog**: Informative, SEO-friendly, evergreen
- **Newsletter**: Personal, intimate, direct

### 4. Content Type Support

Works with any source material:
- **Video scripts** (YouTube, Zoom recordings, webinars)
- **Blog posts** (articles, guides, case studies)
- **Podcast transcripts** (interviews, solo shows)
- **Presentations** (slide decks, keynotes)
- **Research papers** (studies, whitepapers)
- **Case studies** (client work, success stories)
- **Product launches** (announcements, demos)

### 5. Strategic Content Planning

Beyond just conversion, get strategic guidance:
- Platform priority ranking (which platforms first?)
- Publishing schedule (spacing and timing)
- Cross-promotion strategy (how to link between platforms)
- A/B testing suggestions (title variations, hooks)
- Evergreen vs. trending content decisions

## Usage Examples

### Example 1: YouTube Video → Multi-Platform Remix

**User**: "I just recorded a 15-minute YouTube video about '5 Productivity Hacks for Remote Workers.' Help me repurpose it."

**Assistant Response**:

**YouTube (Main Content):**
- Title: "5 Productivity Hacks That Actually Work for Remote Workers (No BS)"
- Hook Script: "If you're working from home and feel like you're drowning in distractions..."
- Timestamps: 0:00 Intro | 1:23 Hack #1: The 52-17 Rule | 4:10 Hack #2...
- Pinned Comment: "Which hack are you trying first? Drop a number 1-5 below 👇"

**TikTok/Shorts (5x 60-second clips):**
Clip 1: "The 52-17 Rule"
- Hook: "This productivity hack is backed by science and I use it every single day..."
- Visual cues: [Text overlay: "52 min work"] [Timer animation] [Text: "17 min break"]
- CTA: "Follow for more productivity tips that actually work"

**Twitter Thread (12 tweets):**
1/ I just tested 5 productivity hacks for 30 days while working remotely.

Only 3 actually worked. Here's what I learned 🧵

2/ First, the problem: Working from home = endless distractions...

[Continues with insights, data, and takeaways]

12/ Which one resonates most with you? Reply and let me know!

And if this thread helped you, RT the first tweet so others can see it 🙏

**LinkedIn Article:**
Title: "5 Evidence-Based Productivity Strategies for Remote Teams"
Opening: "In Q4 2025, I conducted a personal experiment testing popular productivity methodologies..."
[Professional tone, industry statistics, leadership insights]
CTA: "What productivity systems have worked for your remote team? Share in comments."

**Instagram Carousel (10 slides):**
Slide 1: "5 Productivity Hacks for Remote Work ➡️"
Slide 2-6: [Each hack with icon, 1-2 sentences, visual design]
Slide 7: "My Results After 30 Days"
Slide 8-9: [Data visualization, key metrics]
Slide 10: "Save this for later! Which will you try? Drop a 🔥 in comments"

**Blog Post (SEO Version):**
Title: "5 Productivity Hacks for Remote Workers (2026 Guide)"
Meta: "Struggling with productivity while working from home? These 5 science-backed hacks..."
Structure: 2,000 words, H2/H3 headers, internal links, FAQ section
Keywords: remote work productivity, work from home tips, productivity hacks 2026

**Newsletter Version:**
Subject: "I tested 5 productivity hacks so you don't have to"
Tone: Personal, story-driven, direct
Format: Problem → journey → lessons → one clear action
CTA: "Reply and tell me which hack you're trying this week"

---

### Example 2: Blog Post → Platform Optimization

**User**: "I wrote a 2,500-word blog post about 'The Psychology of Color in Branding.' How should I repurpose this?"

**Assistant Response**:

**Primary Platform: LinkedIn** (Best for B2B content)
Strategy: Create 3-part series over 3 weeks

**Part 1:** "Why Your Brand Colors Are Losing You Customers"
- Hook with contrarian insight
- Share 1-2 case studies from blog
- End with cliffhanger for Part 2

**Part 2:** "The Science Behind Color Psychology (And Why Most Brands Get It Wrong)"
- Data-driven approach
- Visual examples
- Tag industry leaders for reach

**Part 3:** "How to Choose Brand Colors That Actually Convert"
- Actionable framework
- Template/worksheet offer
- CTA to full blog post

**Secondary Platform: Twitter/X**
Create 5 atomic tweets (standalone):
1. Controversial take: "Red doesn't mean passion. Blue doesn't mean trust. Here's what brand colors ACTUALLY mean..."
2. Data tweet: "We analyzed 500 Fortune 500 brands. 67% are using the wrong primary color for their industry..."
3. Case study: "Slack changed their brand color and lost 23% recognition overnight. Here's what went wrong..."
4. Quick tip: "Before choosing brand colors, ask these 3 questions: [framework]"
5. Myth-busting: "The biggest color psychology myths designers need to stop believing..."

**Tertiary Platform: Instagram Carousel**
"Color Psychology Cheat Sheet for Brands"
- 8 slides with color + emotion + brand examples
- Highly saveable format
- Design-first approach

**YouTube Short:**
"The $1M Color Mistake Most Brands Make"
- 45-second explainer
- Visual demonstration
- Hook: Show before/after brand transformation

**TikTok:**
"POV: You just learned why your brand color is wrong"
- Trending sound
- Quick visual education
- Relatability angle for creators/business owners

**Email Newsletter:**
"The Color Psychology Masterclass (That Your Competitors Don't Know)"
- Exclusive framework not in blog
- Interactive element (quiz: "What does YOUR brand color say?")
- Deep-dive link to full article

---

### Example 3: Podcast Interview → Content Goldmine

**User**: "I interviewed a 7-figure founder about scaling e-commerce. 45-minute podcast. What should I do with this?"

**Assistant Response**:

**Content Extraction Strategy:**

**Main Assets (Create First):**
1. YouTube version with chapters (full interview)
2. Blog post: "7 Lessons from Scaling an E-Commerce Brand to $10M"
3. LinkedIn article: Professional insights for founders

**Micro-Content (Generate 20+ pieces):**

**Instagram:**
- 5 quote graphics (founder's best quotes)
- 3 carousels (tactical frameworks shared)
- 8 Reels (60-second insights)

**TikTok:**
- 10 clips with hooks like "This 7-figure founder just revealed..." 
- Behind-the-scenes of podcast recording
- Reaction-style clips: "Wait until you hear what they said about..."

**Twitter:**
- 3 threads (one per major topic)
- 15 standalone tweets (hot takes, data points, counterintuitive advice)
- Quote-tweet thread promoting full interview

**LinkedIn:**
- 5 text posts with key insights
- 3 carousel posts with frameworks
- 1 article combining all lessons

**YouTube Shorts:**
- 8 clips optimized for retention
- Cliffhanger editing to drive to full episode

**Newsletter:**
- Interview highlights edition
- Exclusive: 3 questions that didn't make the final cut
- Action items: How to apply these lessons

**Blog/SEO:**
- Full transcript (SEO goldmine)
- Pillar post with internal linking
- FAQ section: Common questions answered

**Cross-Promotion Strategy:**
- Week 1: Release full interview, announce on all platforms
- Week 2-4: Drip micro-content daily across platforms
- Week 5: Republish top-performing clips
- Evergreen: Reuse clips for months (founder quotes, frameworks)

---

## Platform Specifications & Best Practices

### YouTube
- **Title**: 60-70 characters, front-load keywords
- **Description**: First 150 characters are critical, 3-5 timestamps minimum
- **Thumbnail**: High contrast, 1-2 words max, face (if applicable)
- **Length**: 8-15 min (sweet spot for retention + ads)
- **Engagement**: Ask question at 30%, remind to subscribe at 70%

### TikTok/Shorts/Reels
- **Hook**: First 1-3 seconds must stop scroll
- **Length**: 15-45 seconds (sweet spot), up to 60s
- **Captions**: Always add (80% watch without sound)
- **Text overlays**: Large, bold, yellow or white text
- **CTA**: 3-5 seconds before end
- **Loop-ability**: Last frame → first frame for algorithm

### Twitter/X
- **Thread length**: 8-15 tweets (optimal engagement)
- **Tweet 1**: Hook with promise ("Here's how..." "X lessons...")
- **Formatting**: Use line breaks, emojis sparingly, number tweets
- **Engagement**: Question in last tweet, RT request
- **Timing**: Post 8-10 AM or 5-7 PM EST

### LinkedIn
- **First line**: Make them click "see more" (hook)
- **Length**: 1,300-2,000 characters (sweet spot)
- **Formatting**: Short paragraphs, line breaks, bold for emphasis
- **CTA**: Ask for engagement (thoughts? agree? experience?)
- **Hashtags**: 3-5 relevant, not spammy

### Instagram
- **Carousel**: 6-10 slides (completion rate matters)
- **First slide**: Hook + promise ("Swipe to learn...")
- **Design**: High contrast, readable from thumbnail
- **Caption**: First line is critical (before "...more")
- **CTA**: "Save this," "Share with someone who needs this"

### Blog/SEO
- **Title**: Include primary keyword, under 60 characters
- **Meta description**: 150-160 characters, include keyword + CTA
- **Headers**: H2 every 300 words, H3 for subsections
- **Length**: 1,500-2,500 words (sweet spot for ranking)
- **Internal links**: 3-5 to related content
- **Images**: Alt text, compress for speed

### Newsletter
- **Subject line**: Under 50 characters, create curiosity or urgency
- **Preview text**: First 50 characters of email (optimize!)
- **Formatting**: Short paragraphs, scannable
- **Links**: 1-3 max (more = dilution)
- **CTA**: One clear action (read, reply, click)

## Content Remix Frameworks

### The Pillar → Cluster Method
1. Create one pillar content (long-form: video, blog, podcast)
2. Extract 20-50 micro-content pieces (quotes, tips, frameworks)
3. Distribute micro-content across platforms
4. Link back to pillar for depth

### The Atomization Strategy
Take one 15-minute video and create:
- 1 YouTube video (pillar)
- 10 TikTok/Shorts (clips)
- 5 Instagram Reels (clips)
- 3 Twitter threads (insights)
- 2 LinkedIn posts (professional takes)
- 1 blog post (SEO version)
- 15 quote graphics (Instagram/LinkedIn)
- 1 newsletter (synthesis)

Total: 38 pieces of content from 1 source

### The Multi-Angle Approach
Same topic, different angles for different platforms:
- **YouTube**: Deep educational content
- **TikTok**: Entertaining, relatable take
- **LinkedIn**: Professional insight with data
- **Twitter**: Contrarian or hot take
- **Instagram**: Visual transformation story
- **Blog**: Comprehensive guide

## Hook Psychology

### YouTube Hooks
- **Pattern Interrupt**: "Forget everything you know about X..."
- **Curiosity Gap**: "The one thing nobody tells you about..."
- **Results First**: "Here's how I made $50k in 30 days..."
- **Relatability**: "If you're struggling with X, this will change everything..."
- **Controversy**: "Everyone's doing X wrong. Here's why..."

### TikTok Hooks
- **Direct Address**: "If you're a creator who wants more views..."
- **Negative Hook**: "Stop doing X. It's killing your content..."
- **Numbers**: "3 things I wish I knew before starting..."
- **Personal Story**: "I tried X for 30 days and here's what happened..."
- **POV Style**: "POV: You just learned the secret to..."

### Twitter Hooks
- **Bold Claim**: "X is dead. Here's what's replacing it..."
- **Numbered Thread**: "10 lessons from X that changed my life 🧵"
- **Contrarian**: "Unpopular opinion: X is overrated. Here's why..."
- **Data-Driven**: "I analyzed 1000 tweets. Here's what works..."
- **Personal**: "I made $X doing Y. Here's exactly how..."

### LinkedIn Hooks
- **Industry Insight**: "The biggest shift happening in X industry right now..."
- **Lessons Learned**: "After 10 years in X, here's what I've learned..."
- **Challenge/Solution**: "The X problem is getting worse. Here's how to fix it..."
- **Counterintuitive**: "Everyone says to do X. I did the opposite..."
- **Data Story**: "Our team analyzed X and found something surprising..."

## Content Calendar Strategy

### Weekly Publishing Schedule
- **Monday**: LinkedIn article (professional mindset)
- **Tuesday-Thursday**: Daily TikTok/Shorts (algorithm momentum)
- **Wednesday**: Twitter thread (mid-week engagement peak)
- **Thursday**: YouTube video (prime discovery day)
- **Friday**: Instagram carousel (weekend save/share behavior)
- **Weekend**: Newsletter (time to read)

### Content Batching
- **Batch 1 pillar** → Create 30-50 pieces
- Publish over 4-6 weeks
- Maintain consistent presence without daily creation
- Repurpose evergreen content quarterly

## When to Use This Skill

Use Content Remix Studio when:
- You've created content and want to maximize reach across platforms
- You're repurposing old content for new audiences
- You need platform-specific optimizations (hooks, formats, tone)
- You're planning a content calendar and need strategic distribution
- You want to scale content production without creating from scratch
- You're analyzing which platforms to prioritize for a topic
- You need help adapting your brand voice for different audiences
- You're launching a product/service and need omnichannel content

## Strategic Principles

### The 1→10→100 Rule
- 1 hour creating pillar content
- 10 minutes per micro-content piece (10 pieces = 100 minutes)
- 100+ hours of value delivered to audience

### Platform-First Thinking
Don't create once and copy everywhere. Think:
1. What's the goal? (Awareness vs. engagement vs. conversion)
2. Where is my audience? (Platform demographics)
3. What format works there? (Video vs. text vs. carousel)
4. What's the platform algorithm rewarding? (Retention, shares, saves)

### The Content Staircase
- **Entry Point**: TikTok/Shorts (awareness, quick value)
- **Mid-Funnel**: Instagram/Twitter (community, engagement)
- **Deep Dive**: YouTube/Blog (authority, education)
- **Conversion**: Newsletter (relationship, sales)

## Important Notes

- Every platform has a different "content language" - respect it
- Don't just copy-paste; transform with intention
- Test and iterate - platforms evolve constantly
- Quality > quantity, but smart repurposing = both
- Cite sources, give credit, be authentic
- Platform algorithms change - stay adaptable
- Your audience overlap varies by platform - treat them uniquely

---

*Remember: The best content isn't created once—it's remixed intelligently across every platform where your audience lives.*
