# 🎬 Content Remix Studio

Transform one piece of content into platform-optimized versions for every major social platform. Stop recreating from scratch—start remixing strategically.

## What This Skill Does

Content Remix Studio is an intelligent content repurposing engine that takes your pillar content (YouTube video, blog post, podcast, presentation) and transforms it into optimized versions for:

- 🎥 **YouTube** - Titles, descriptions, timestamps, hooks
- 📱 **TikTok/Reels/Shorts** - Hook-first scripts, visual cues
- 🐦 **Twitter/X** - Engaging threads with viral mechanics
- 💼 **LinkedIn** - Professional insights and thought leadership
- 📸 **Instagram** - Carousel stories and quote graphics
- ✍️ **Blogs** - SEO-optimized articles with meta data
- 📧 **Newsletters** - Personal, email-friendly formats

Each transformation includes platform-specific:
- ✅ Optimal length and format
- ✅ Algorithm-friendly structure
- ✅ Tone and voice adaptation
- ✅ Engagement hooks and CTAs
- ✅ Publishing strategy

## The Problem It Solves

**Every creator faces this challenge:**
- Creating content for ONE platform = Limited reach 😞
- Recreating for EVERY platform = Exhausting ⚡️
- Copy-pasting everywhere = Poor performance 📉

**The solution? Strategic remixing with platform intelligence.**

One 15-minute video becomes:
- 1 YouTube video
- 10 TikTok clips
- 5 Instagram Reels
- 3 Twitter threads
- 2 LinkedIn posts
- 1 blog post
- 15 quote graphics
- 1 newsletter

**Total: 38 pieces from 1 source** 🚀

## Installation

### Via ClawHub CLI (Recommended)

```bash
# Search for the skill
clawhub search content-remix

# Install
clawhub install content-remix-studio
```

### Manual Installation

1. Create the skill directory:
```bash
mkdir -p ~/.openclaw/skills/content-remix-studio
```

2. Copy `SKILL.md` to the directory:
```bash
cp SKILL.md ~/.openclaw/skills/content-remix-studio/
```

3. Restart OpenClaw or reload skills:
```bash
openclaw reload-skills
```

## Quick Start Examples

### Example 1: Repurpose a YouTube Video

```
You: I just recorded a 15-min YouTube video about "5 Productivity Hacks 
for Remote Workers." Help me repurpose this across all platforms.

AI: [Generates platform-specific versions]

YouTube: Title, description, timestamps, pinned comment strategy
TikTok: 5 separate 60-second clips with hooks and visual cues
Twitter: 12-tweet thread with engagement tactics
LinkedIn: Professional article with data-driven insights
Instagram: 10-slide carousel with swipe prompts
Blog: SEO-optimized 2,000-word article
Newsletter: Personal story-driven version with CTA

[Plus strategic publishing schedule and cross-promotion tactics]
```

### Example 2: Blog Post → Multi-Platform

```
You: I wrote a 2,500-word blog post about "The Psychology of Color 
in Branding." How should I repurpose this?

AI: Let me create a strategic remix plan...

Primary Platform: LinkedIn (3-part series over 3 weeks)
Secondary: Twitter (5 atomic standalone tweets)
Tertiary: Instagram (Saveable carousel cheat sheet)
Quick Wins: TikTok (45-sec explainer), YouTube Short (visual demo)
Nurture: Newsletter (exclusive framework + quiz)

[Provides specific content for each with hooks, formatting, and timing]
```

### Example 3: Podcast → Content Goldmine

```
You: I interviewed a 7-figure founder. 45-minute podcast. 
What should I do with this?

AI: This is a content goldmine! Here's your extraction strategy:

Main Assets:
- Full YouTube video with chapters
- Blog post: "7 Lessons from Scaling to $10M"
- LinkedIn article for founders

Micro-Content (20+ pieces):
- 5 Instagram quote graphics
- 10 TikTok clips with scroll-stopping hooks
- 3 Twitter threads
- 8 YouTube Shorts

[Plus 4-week publishing calendar and cross-promotion strategy]
```

## Key Features

### 🎯 Platform Intelligence
- Knows each platform's algorithm preferences
- Optimizes for length, format, and engagement
- Adapts hooks for platform-specific psychology

### 🗣️ Voice Adaptation
- YouTube: Enthusiastic, educational
- TikTok: Casual, Gen-Z humor
- Twitter: Witty, conversational
- LinkedIn: Professional, thoughtful
- Instagram: Aesthetic, aspirational

### 📊 Strategic Planning
- Platform priority ranking
- Publishing schedule recommendations
- Cross-promotion tactics
- A/B testing suggestions

### 🔄 Content Types Supported
- ✅ Video scripts (YouTube, webinars, Zoom)
- ✅ Blog posts (articles, guides, case studies)
- ✅ Podcast transcripts (interviews, solo shows)
- ✅ Presentations (slide decks, keynotes)
- ✅ Research papers (studies, whitepapers)
- ✅ Case studies (client work, success stories)

## Platform Specifications

### YouTube
- **Title**: 60-70 chars, front-load keywords
- **Hook**: First 15 seconds critical
- **Length**: 8-15 min sweet spot
- **Timestamps**: 3-5 minimum

### TikTok/Shorts
- **Hook**: Stop scroll in 1-3 seconds
- **Length**: 15-45 seconds optimal
- **Captions**: Always (80% watch muted)
- **Loop**: Last frame → first frame

### Twitter/X
- **Thread**: 8-15 tweets optimal
- **Tweet 1**: Promise value upfront
- **Format**: Line breaks, emojis sparingly
- **CTA**: Question in last tweet

### LinkedIn
- **Hook**: First line = click "see more"
- **Length**: 1,300-2,000 characters
- **Format**: Short paragraphs, bold key points
- **Hashtags**: 3-5 relevant

### Instagram
- **Carousel**: 6-10 slides
- **Design**: High contrast, readable
- **Caption**: First line is critical
- **CTA**: Save/share prompts

## Use Cases

### For Content Creators
- Maximize reach from one piece of content
- Maintain consistent presence without burnout
- Test which platforms work best for your niche

### For Marketers
- Scale content production efficiently
- Maintain brand voice across platforms
- Track what resonates where

### For Businesses
- Repurpose thought leadership content
- Generate month's worth of social from one interview
- Build authority across multiple channels

### For Course Creators
- Turn course modules into marketing content
- Create preview content for every platform
- Build anticipation across channels

## Content Remix Strategies

### The Pillar Method
1. Create one pillar content (15+ minutes)
2. Extract 20-50 micro-content pieces
3. Distribute across platforms over 4-6 weeks
4. Link back to pillar for depth

### The Atomization Strategy
- 1 long video → 38 pieces of content
- Post daily across all platforms
- Never run out of content ideas

### The Multi-Angle Approach
- Same topic, different angles per platform
- Respect each platform's content language
- Optimize for platform-specific algorithms

## Requirements

- **OpenClaw**: Compatible with OpenClaw 2.0+
- **Dependencies**: None - pure knowledge skill
- **API Keys**: Not required
- **External Tools**: Not required

## Best Practices

### Do's ✅
- Transform with intention, not copy-paste
- Respect each platform's content language
- Test and iterate based on performance
- Maintain consistent brand voice (adapted per platform)
- Credit sources and be authentic

### Don'ts ❌
- Don't post identical content everywhere
- Don't ignore platform-specific best practices
- Don't sacrifice quality for quantity
- Don't forget to engage with your audience
- Don't skip the hook - it's everything

## Tips for Maximum Results

1. **Start with your strongest platform** - Build momentum
2. **Batch your remixing** - Do it all at once for efficiency
3. **Track what works** - Double down on winning formats
4. **Repurpose evergreen content** - Some topics work year-round
5. **Update and refresh** - Remix your top performers quarterly

## Content Calendar Template

**Weekly Schedule:**
- Monday: LinkedIn (professional mindset)
- Tuesday-Thursday: Daily TikTok/Shorts (momentum)
- Wednesday: Twitter thread (mid-week peak)
- Thursday: YouTube video (discovery day)
- Friday: Instagram carousel (weekend saves)
- Weekend: Newsletter (reading time)

## Advanced Features

### Hook Psychology
Platform-specific hook formulas:
- YouTube: Pattern interrupts, curiosity gaps
- TikTok: Direct address, negative hooks
- Twitter: Bold claims, contrarian takes
- LinkedIn: Industry insights, lessons learned

### The 1→10→100 Rule
- 1 hour creating pillar
- 10 minutes per micro-piece (10 pieces)
- 100+ hours value to audience

### Platform-First Thinking
1. What's the goal?
2. Where is my audience?
3. What format works there?
4. What's the algorithm rewarding?

## Version History

- **v1.0.0** (February 2026): Initial release
  - Multi-platform transformation
  - Platform-specific optimization
  - Tone and voice adaptation
  - Strategic content planning
  - Hook psychology frameworks

## Contributing

Found a bug or want to suggest improvements? Contributions welcome!

1. Fork the repository
2. Create a feature branch
3. Submit a pull request

## License

MIT License - Use, modify, and share freely!

## Author

Created by AM for the OpenClaw creator community.

## Acknowledgments

Built on insights from analyzing thousands of viral content pieces across every major platform and years of content creation experience.

---

**Stop recreating. Start remixing. 🎬**

*One piece of content. Unlimited reach. That's the power of strategic remixing.*
