CREATE TABLE `crawl_results` (
	`id` text PRIMARY KEY NOT NULL,
	`task_id` text NOT NULL,
	`source_account_id` text NOT NULL,
	`platform` text NOT NULL,
	`source_url` text NOT NULL,
	`source_id` text,
	`author_name` text,
	`author_id` text,
	`title` text,
	`content` text,
	`content_type` text,
	`media_urls` text,
	`media_local_paths` text,
	`tags` text,
	`engagement` text,
	`publish_time` integer,
	`crawl_time` integer NOT NULL,
	`curation_status` text NOT NULL,
	`curation_notes` text,
	`curated_by` text,
	`curated_at` integer,
	`quality_score` integer,
	`is_available` integer,
	`usage_count` integer NOT NULL,
	`last_used_at` integer,
	FOREIGN KEY (`task_id`) REFERENCES `crawl_tasks`(`id`) ON UPDATE no action ON DELETE no action,
	FOREIGN KEY (`source_account_id`) REFERENCES `source_accounts`(`id`) ON UPDATE no action ON DELETE no action
);
--> statement-breakpoint
CREATE TABLE `crawl_tasks` (
	`id` text PRIMARY KEY NOT NULL,
	`task_name` text NOT NULL,
	`source_account_id` text NOT NULL,
	`status` text NOT NULL,
	`query_list` text NOT NULL,
	`target_count` integer NOT NULL,
	`crawled_count` integer NOT NULL,
	`scheduled_at` integer,
	`started_at` integer,
	`completed_at` integer,
	`task_config` text,
	`created_by` text,
	`created_at` integer NOT NULL,
	`updated_at` integer NOT NULL,
	FOREIGN KEY (`source_account_id`) REFERENCES `source_accounts`(`id`) ON UPDATE no action ON DELETE no action
);
--> statement-breakpoint
CREATE TABLE `publish_metrics_daily` (
	`id` text PRIMARY KEY NOT NULL,
	`publish_task_id` text NOT NULL,
	`target_account_id` text NOT NULL,
	`metric_date` text NOT NULL,
	`platform` text NOT NULL,
	`post_url` text,
	`platform_post_id` text,
	`impressions` integer,
	`clicks` integer,
	`engagement_rate` real,
	`reddit_score` integer,
	`reddit_upvotes` integer,
	`reddit_downvotes` integer,
	`reddit_upvote_ratio` real,
	`reddit_comments` integer,
	`reddit_awards` integer,
	`pinterest_saves` integer,
	`pinterest_closeups` integer,
	`pinterest_outbound_clicks` integer,
	`discord_reactions` text,
	`discord_replies` integer,
	`is_complete` integer,
	`fetch_error` text,
	`fetched_at` integer NOT NULL,
	`created_at` integer NOT NULL,
	FOREIGN KEY (`publish_task_id`) REFERENCES `publish_tasks`(`id`) ON UPDATE no action ON DELETE no action,
	FOREIGN KEY (`target_account_id`) REFERENCES `target_accounts`(`id`) ON UPDATE no action ON DELETE no action
);
--> statement-breakpoint
CREATE TABLE `publish_tasks` (
	`id` text PRIMARY KEY NOT NULL,
	`task_name` text NOT NULL,
	`target_account_id` text NOT NULL,
	`source_corpus_ids` text,
	`status` text NOT NULL,
	`content_type` text,
	`content` text,
	`adaptation` text,
	`scheduled_at` integer,
	`published_at` integer,
	`created_by` text,
	`reviewed_by` text,
	`reviewed_at` integer,
	`review_notes` text,
	`created_at` integer NOT NULL,
	`updated_at` integer NOT NULL,
	FOREIGN KEY (`target_account_id`) REFERENCES `target_accounts`(`id`) ON UPDATE no action ON DELETE no action
);
--> statement-breakpoint
CREATE TABLE `source_accounts` (
	`id` text PRIMARY KEY NOT NULL,
	`account_type` text NOT NULL,
	`platform` text NOT NULL,
	`account_name` text NOT NULL,
	`login_status` text NOT NULL,
	`session_data` text,
	`daily_quota` integer NOT NULL,
	`quota_used_today` integer NOT NULL,
	`quota_reset_at` integer,
	`crawl_config` text,
	`last_login_at` integer,
	`last_crawl_at` integer,
	`created_at` integer NOT NULL,
	`updated_at` integer NOT NULL
);
--> statement-breakpoint
CREATE TABLE `target_accounts` (
	`id` text PRIMARY KEY NOT NULL,
	`account_type` text NOT NULL,
	`platform` text NOT NULL,
	`account_name` text NOT NULL,
	`account_id` text,
	`homepage_url` text,
	`status` text NOT NULL,
	`api_config` text,
	`positioning` text,
	`target_audience` text,
	`content_direction` text,
	`platform_config` text,
	`created_at` integer NOT NULL,
	`updated_at` integer NOT NULL
);
--> statement-breakpoint
CREATE TABLE `target_accounts_metrics_daily` (
	`id` text PRIMARY KEY NOT NULL,
	`target_account_id` text NOT NULL,
	`platform` text NOT NULL,
	`metric_date` text NOT NULL,
	`followers` integer,
	`followers_change` integer,
	`total_posts` integer,
	`posts_change` integer,
	`total_engagement` integer,
	`engagement_change` integer,
	`reddit_total_karma` integer,
	`reddit_karma_change` integer,
	`reddit_link_karma` integer,
	`reddit_comment_karma` integer,
	`pinterest_monthly_views` integer,
	`pinterest_total_pins` integer,
	`pinterest_total_boards` integer,
	`top_post_id` text,
	`top_post_engagement` integer,
	`avg_post_engagement` real,
	`growth_rate` real,
	`engagement_rate` real,
	`posting_consistency` real,
	`is_complete` integer,
	`fetch_error` text,
	`fetched_at` integer NOT NULL,
	`created_at` integer NOT NULL,
	FOREIGN KEY (`target_account_id`) REFERENCES `target_accounts`(`id`) ON UPDATE no action ON DELETE no action
);
