# Content Ops SOP - 详细工作流程

## SOP 1: 内容抓取流程

### 触发条件
用户想要抓取某主题的内容作为语料

### 流程步骤

#### 1.1 确认抓取主题
**输入**: 用户提供的主题/关键词
**输出**: 确认后的主题 + 扩展搜索词

**操作**:
```bash
python3 scripts/crawl_xiaohongshu.py "穿搭"
```

**自动执行**:
- 扩展同义词和相关搜索词
- 生成抓取模板文件到 `corpus/raw/`

#### 1.2 内容抓取
**工具**: 浏览器自动化 (Playwright/Selenium)

**操作**:
1. 打开小红书网页版
2. 依次搜索每个 query
3. 抓取笔记的：标题、作者、链接、点赞数、内容摘要、标签、图片
4. 填入模板文件

#### 1.3 通知人工确认
**自动执行**: 生成确认通知

```
📋 语料抓取完成 - 待确认

主题: 穿搭
搜索Query: 穿搭, OOTD, 每日穿搭, 搭配
抓取数量: 20条笔记
文件位置: corpus/raw/2024-01-15-穿搭.md

请查看并确认:
- [ ] 内容质量是否符合要求
- [ ] 是否有侵权风险
- [ ] 是否可用于二次创作

确认命令:
python3 scripts/curate_content.py corpus/raw/2024-01-15-穿搭.md
```

#### 1.4 人工确认后归档
**执行**: 用户运行确认命令

**自动执行**:
- 将内容从 `raw/` 移动到 `curated/`
- 更新 `curated: true` 标记
- 移动原始文件到 `_archived_raw/`

---

## SOP 2: 内容编写与发布

### 触发条件
用户想要基于语料库创建内容并发布

### 流程步骤

#### 2.1 读取运营策略
**读取**: `strategies/平台-账号-strategy.md`

**获取信息**:
- 账号定位和人设
- 内容方向和风格
- 发布频率和最佳时间

#### 2.2 选择语料
**扫描**: `corpus/curated/` 目录

**选择标准**:
- 与账号定位匹配
- 内容质量高
- 未被使用过（或可以改编）

#### 2.3 生成内容
**输入**: 选定语料 + 运营策略
**输出**: 
- 标题（3个备选）
- 正文（适配平台风格）
- 标签（平台热门+内容相关）
- 配图建议

**保存**: `corpus/published/平台-账号名-日期-标题.md`

#### 2.4 人工审核
**通知**:
```
📝 内容已生成 - 待审核

账号: [平台] [账号名]
标题: [标题]
文件: corpus/published/...

请审核:
- [ ] 标题是否吸引人
- [ ] 正文是否通顺
- [ ] 是否符合平台规范
- [ ] 配图是否合适

审核通过后可发布到平台
```

#### 2.5 发布到平台
**工具**: 各平台发布脚本

**操作**:
```bash
python3 scripts/publish_xiaohongshu.py --account 账号名 --file 内容文件.md
```

**发布后**:
- 更新文件状态为 `published`
- 记录发布链接
- 更新账号档案的已发布内容索引
- 设置定时任务追踪数据

---

## SOP 3: 创建/修改运营策略

### 触发条件
用户想要创建或修改账号运营策略

### 流程步骤

#### 3.1 收集需求
**输入**: 
- 账号信息（平台、名称、主页）
- 账号定位和目标
- 目标受众
- 内容方向偏好

#### 3.2 生成策略文件
**执行**:
```bash
python3 scripts/create_strategy.py xiaohongshu 账号名
```

**输出**: `strategies/平台-账号名-strategy.md`

#### 3.3 人工完善
**用户填写**:
- 详细的人设描述
- 具体的选题方向
- KPI 目标
- 竞品参考

#### 3.4 关联账号档案
**更新**: `accounts/平台-账号名.md`

添加策略文件链接

---

## SOP 4: 每日账号复盘

### 触发条件
定时任务或用户请求查看昨日数据

### 流程步骤

#### 4.1 读取账号信息
**读取**: `accounts/平台-账号名.md`

**获取**: 主页地址、历史数据

#### 4.2 抓取最新数据
**工具**: 各平台数据抓取脚本

**数据项**:
- 粉丝数
- 总获赞/收藏
- 昨日发布内容的阅读量/互动数
- 新增粉丝

#### 4.3 对比分析
**对比**: 今日数据 vs 昨日数据

**计算**:
- 粉丝增长率
- 内容互动率
- 阅读量变化

#### 4.4 生成报告
**保存**: `reports/日期-账号-平台-report.md`

**内容**:
- 数据对比表格
- 内容表现排名
- 分析与建议

#### 4.5 更新账号档案
**更新**: 将最新数据写入账号档案的"运营数据追踪"部分

---

## SOP 5: 已发布内容管理

### 触发条件
用户想要查看已发布内容的实时数据

### 流程步骤

#### 5.1 读取已发布内容列表
**来源**: `accounts/平台-账号名.md` 中的已发布内容索引

#### 5.2 抓取每篇内容的实时数据
**工具**: 平台数据抓取脚本

**数据项**:
- 当前阅读量
- 点赞数
- 收藏数
- 评论数
- 分享数

#### 5.3 更新内容文件
**更新**: `corpus/published/平台-账号名-日期-标题.md`

在 frontmatter 或表格中更新数据

#### 5.4 生成数据汇总
**输出**: 数据汇总表格

```
| 内容 | 发布时间 | 阅读量 | 点赞 | 收藏 | 趋势 |
|------|----------|--------|------|------|------|
| 内容1 | 3天前 | 1000 | 50 | 30 | ↑ |
| 内容2 | 1天前 | 500 | 20 | 10 | → |
```

---

## SOP 6: 创建账号档案

### 触发条件
用户新增账号

### 流程步骤

#### 6.1 收集账号信息
**必需**:
- 平台名称
- 账号名称
- 主页地址

**可选**:
- 账号ID
- 账号定位
- 目标受众
- 内容方向

#### 6.2 创建档案文件
**执行**:
```bash
python3 scripts/create_account.py xiaohongshu 账号名 --url "主页地址"
```

**输出**: `accounts/平台-账号名.md`

#### 6.3 创建配套策略文件
**自动**: 询问是否创建运营策略

**执行**:
```bash
python3 scripts/create_strategy.py xiaohongshu 账号名
```

---

## SOP 7: 每日任务规划

### 触发条件
定时任务（每日早上）

### 流程步骤

#### 7.1 读取所有活跃账号
**扫描**: `accounts/` 目录中 `status: active` 的账号

#### 7.2 检查发布计划
**读取**: `schedules/月份-发布计划.md`

确定今日需要发布的内容

#### 7.3 检查语料需求
**扫描**: `corpus/curated/` 目录

判断是否需要抓取新语料

#### 7.4 生成任务清单
**执行**:
```bash
python3 scripts/generate_daily_plan.py
```

**输出**: `schedules/日期-plan.md`

#### 7.5 通知用户
**发送**: 今日任务概览

```
📅 今日任务规划 - 2024-01-15

活跃账号: 3个
- 小红书-账号A
- Reddit-账号B  
- Pinterest-账号C

今日待办:
🔴 高优先级:
  - [小红书-账号A] 发布内容 (计划今日)
  - [Reddit-账号B] 数据复盘

🟡 中优先级:
  - 抓取新语料: 家居收纳

详情: schedules/2024-01-15-plan.md
```
