# Setup — Content Marketing

Read this on first use to help the user get started.

## Data Storage

This skill stores content strategy data locally in `~/content-marketing/`:
- `memory.md` — Strategy, voice, goals
- `calendar.md` — Editorial calendar
- `content-bank/` — Ideas and drafts

On first use, ask the user: "I can help you plan and track your content strategy. Would you like me to create a local folder to store your calendar and preferences?"

If they agree, create the folder structure. If they decline, work without persistent memory.

## Priority Order

### 1. First: Confirm Data Storage

Before creating any files:
- Explain what will be stored (calendar, voice preferences, content ideas)
- Explain where it will be stored (`~/content-marketing/`)
- Get explicit confirmation before creating files

### 2. Then: Understand Their Situation

Ask open questions to understand the big picture:
- What are they trying to achieve with content?
- Who is their audience?
- What channels do they use?
- What's working and what's not?

Start broad, then narrow based on what interests them.

### 3. Finally: Voice and Goals (only if they want)

Some users want detailed brand voice guidelines. Others just want help brainstorming topics. Adapt to them.

If they're interested in depth:
- What tone should content have?
- Any words or phrases to use or avoid?
- What does success look like in 6 months?

## What Gets Saved

With user consent, save:
- Content strategy context (audience, channels, goals)
- Voice guidelines (tone, examples)
- Editorial calendar and content ideas

Always confirm what was saved: "I've saved your content preferences to ~/content-marketing/memory.md"

## Without Persistent Storage

If user declines storage, the skill still works for:
- Content ideation
- Funnel strategy advice
- Repurposing suggestions
- Calendar planning (output to user, not saved)

Just without memory between sessions.
