# Repurposing Workflows — Content Marketing

## The Core Principle

Create once, distribute everywhere. Every pillar piece should generate 5-10 derivative pieces.

## Pillar to Derivatives

### From Long-Form Blog Post

| Derivative | Format | Platform |
|------------|--------|----------|
| Thread | 5-10 tweets | Twitter/X |
| Carousel | 5-10 slides | LinkedIn, Instagram |
| Summary video | 60-90 seconds | TikTok, Reels, Shorts |
| Newsletter section | 200-300 words | Email |
| Quote graphics | 3-5 images | All social |
| Podcast talking points | Outline | Audio platforms |
| Infographic | Visual summary | Pinterest, LinkedIn |

### From Video/Podcast

| Derivative | Format | Platform |
|------------|--------|----------|
| Blog post | Transcript + editing | Website |
| Clips | 30-60 second cuts | Short-form video |
| Audiogram | Audio + waveform | Social |
| Quote cards | Key moments | Image platforms |
| Thread | Key insights | Twitter/X |

### From Webinar/Workshop

| Derivative | Format | Platform |
|------------|--------|----------|
| Replay | Full video | YouTube, course platform |
| Clips | Best moments | Social |
| Blog post | Written version | Website |
| Slides | PDF download | Lead magnet |
| Email series | Key lessons | Newsletter |

## The 10x Rule

Before publishing any pillar content, plan 10 derivatives:

```markdown
## Repurposing Plan for: [Title]

Pillar: [Blog post / Video / Podcast]

Derivatives:
1. [ ] Twitter thread
2. [ ] LinkedIn carousel
3. [ ] Instagram carousel
4. [ ] Newsletter mention
5. [ ] Quote graphic 1
6. [ ] Quote graphic 2
7. [ ] Quote graphic 3
8. [ ] Short video clip
9. [ ] Community post
10. [ ] Updated evergreen (in 6 months)
```

## Timing Strategy

Don't publish all derivatives at once. Spread over 2-4 weeks:

| Week | Derivatives |
|------|-------------|
| Week 1 (publish) | Pillar + thread + newsletter |
| Week 2 | Carousel + quote graphics |
| Week 3 | Video clip + community post |
| Week 4 | Reshare pillar with new angle |

## Evergreen Updates

Every 6-12 months, update pillar content:
- Refresh stats and examples
- Add new sections
- Update screenshots
- Republish with "Updated for [Year]"

Evergreen content should improve, not decay.
