# Memory Template — Content Marketing

Create `~/content-marketing/memory.md` with this structure:

```markdown
# Content Marketing Memory

## Status
status: ongoing
version: 1.0.0
last: YYYY-MM-DD
integration: pending

## Strategy
<!-- Goals, audience, channels -->
<!-- Add as you learn from conversations -->

## Voice
<!-- Tone, style, words to use/avoid -->
<!-- Infer from their existing content and feedback -->

## Current Focus
<!-- What they're working on now -->
<!-- Update when priorities shift -->

## Notes
<!-- Internal observations -->
<!-- What's working, what's not -->

---
*Updated: YYYY-MM-DD*
```

## Status Values

| Value | Meaning | Behavior |
|-------|---------|----------|
| `ongoing` | Still learning their needs | Gather context opportunistically |
| `complete` | Has enough context | Work normally |
| `paused` | User said "not now" | Don't ask, work with what you have |
| `never_ask` | User said stop | Never ask for more context |

## Calendar Template

Create `~/content-marketing/calendar.md`:

```markdown
# Editorial Calendar

## This Week
| Day | Content | Type | Funnel | Status | Channel |
|-----|---------|------|--------|--------|---------|

## Next Week
| Day | Content | Type | Funnel | Status | Channel |
|-----|---------|------|--------|--------|---------|

## Content Bank
<!-- Ideas to develop -->
- 
- 
- 

---
*Updated: YYYY-MM-DD*
```

## Key Principles

- **No config keys visible** — use natural language sections
- **Learn from behavior** — observe their content style, don't interrogate
- **Most users stay `ongoing`** — always learning, that's fine
- Update `last` on each use
