# Funnel Strategy — Content Marketing

## The Three Stages

Every piece of content serves one funnel stage. Know which before creating.

### TOFU — Top of Funnel (Awareness)

**Goal:** Attract new audience who don't know you exist.

**Content types:**
- SEO blog posts on broad topics
- Social content for virality
- Podcasts and YouTube for discovery
- Guest posts and collaborations

**Metrics that matter:**
- Traffic, impressions, reach
- New followers, subscribers
- Social shares

**Trap:** TOFU content that doesn't lead anywhere. Always include a path to MOFU.

### MOFU — Middle of Funnel (Consideration)

**Goal:** Educate people who know you but haven't decided.

**Content types:**
- How-to guides and tutorials
- Comparison posts (vs competitors, vs alternatives)
- Case studies (showing process)
- Webinars and workshops
- Email sequences

**Metrics that matter:**
- Email signups, lead magnets downloaded
- Time on page, content completion
- Return visits

**Trap:** Too much MOFU without TOFU means no new people enter. Balance.

### BOFU — Bottom of Funnel (Decision)

**Goal:** Convert people ready to buy.

**Content types:**
- Product demos and walkthroughs
- Customer testimonials and case studies (results-focused)
- Pricing pages and comparisons
- FAQ and objection-handling content
- Sales pages and landing pages

**Metrics that matter:**
- Conversions, signups, purchases
- Cost per acquisition
- Trial to paid rate

**Trap:** Going straight to BOFU with cold traffic. They're not ready.

## Funnel Ratios

Healthy content mix:
- **60% TOFU** — Feed the top, always
- **30% MOFU** — Nurture interest
- **10% BOFU** — Convert the ready

If you're only creating BOFU, you're only selling to people already decided. If you're only creating TOFU, you're entertaining but not converting.

## Content Bridges

Every piece should bridge to the next stage:

| From | Bridge | To |
|------|--------|-----|
| TOFU blog post | Lead magnet CTA | MOFU email sequence |
| MOFU tutorial | "See how X did it" | BOFU case study |
| BOFU case study | "Start your trial" | Conversion |

No dead ends. Every piece leads somewhere.
