---
name: Content Marketing
slug: content-marketing
version: 1.0.0
homepage: https://clawic.com/skills/content-marketing
description: Plan, create, and distribute content with editorial calendars, funnel strategy, and repurposing workflows.
metadata: {"clawdbot":{"emoji":"📝","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## Setup

On first use, read `setup.md` for integration guidelines.

## When to Use

User needs help with content strategy, editorial planning, blog posts, social media content, or content distribution. Agent handles calendar management, topic ideation, funnel alignment, and repurposing workflows.

## Architecture

With user consent, data is stored locally in `~/content-marketing/`. See `memory-template.md` for structure.

```
~/content-marketing/
├── memory.md           # Strategy, voice, goals
├── calendar.md         # Editorial calendar
├── content-bank/       # Drafts and ideas
└── analytics/          # Performance notes
```

**First use:** Ask user for permission before creating this folder. The skill works without storage but cannot remember preferences between sessions.

## Quick Reference

| Topic | File |
|-------|------|
| Setup process | `setup.md` |
| Memory template | `memory-template.md` |
| Funnel strategy | `funnels.md` |
| Repurposing workflows | `repurposing.md` |

## Core Rules

### 1. Align Every Piece to Funnel Stage
Before creating content, identify:
- **TOFU** (Top of Funnel): Awareness, broad topics, SEO-focused
- **MOFU** (Middle): Consideration, comparisons, how-tos
- **BOFU** (Bottom): Decision, case studies, demos, pricing

Content without funnel alignment wastes effort.

### 2. One Core Idea, Multiple Formats
Every pillar content piece should generate:
- 1 long-form article or video
- 3-5 social posts
- 1 email newsletter section
- Quote graphics or carousels

Never create once and forget. Repurpose systematically.

### 3. Editorial Calendar is Sacred
Track in the editorial calendar:
- Publication dates
- Content type and funnel stage
- Status (idea / draft / review / published)
- Distribution channels

Review calendar weekly. Gaps in calendar = gaps in pipeline.

### 4. Voice Consistency
Document brand voice in memory:
- Tone (professional, casual, provocative)
- Words to use and avoid
- Example sentences that nail the voice

Every piece should sound like the same person wrote it.

### 5. Distribution > Creation
80% of effort should go to distribution:
- Cross-post to all relevant channels
- Repurpose for each platform's format
- Engage with comments and shares
- Update and republish evergreen content

Creating content nobody sees is content that doesn't exist.

### 6. Measure What Matters
Track per content type:
- Traffic and engagement
- Conversion to next funnel stage
- Time on page / completion rate
- Social shares and saves

Stop producing what doesn't perform.

### 7. Content Bank Never Empty
Always maintain 10+ ideas in content-bank/:
- Problems your audience has
- Questions they ask
- Trends in your space
- Competitor gaps

If you run out of ideas, you're not listening enough.

## Common Traps

- **No funnel alignment** → Content gets views but no conversions
- **Create and forget** → Single-use content wastes 80% of value
- **Inconsistent voice** → Brand feels fragmented
- **Publishing without distribution plan** → Content dies in silence
- **Chasing trends over evergreen** → Constant treadmill, no compounding
- **Ignoring analytics** → Repeating failures, missing wins

## Security & Privacy

**Data that stays local (with user consent):**
- Content strategy and voice preferences in `~/content-marketing/memory.md`
- Editorial calendar in `~/content-marketing/calendar.md`
- Content ideas in `~/content-marketing/content-bank/`

**This skill does NOT:**
- Send data to external services
- Access files outside `~/content-marketing/`
- Create files without explicit user permission
- Collect or transmit analytics

**User control:**
- Storage is optional — decline and the skill still works for ideation and advice
- Delete `~/content-marketing/` anytime to remove all stored data

## Related Skills
Install with `clawhub install <slug>` if user confirms:
- `seo` — Optimize content for search
- `writing` — Craft better copy
- `growth-hacker` — Distribution tactics
- `branding` — Maintain brand consistency

## Feedback

- If useful: `clawhub star content-marketing`
- Stay updated: `clawhub sync`
