# Voice Cloner — Match a Writing Style

## Phase 1: Training

Analyze these writing samples:

```
[SAMPLE 1]
{sample_1}
[/SAMPLE 1]

[SAMPLE 2]
{sample_2}
[/SAMPLE 2]

[SAMPLE 3]
{sample_3}
[/SAMPLE 3]
```

### Voice Fingerprint (fill this out):

- **Sentence structure**: Average length? Variation? Uses fragments?
- **Vocabulary level**: Simple/complex? Technical/casual? Formal/informal?
- **Tone markers**: Humor? Formality? Directness? Warmth?
- **Rhythm**: Choppy? Flowing? Mixed? Punchy?
- **Signature phrases**: Any verbal tics or recurring phrases?
- **Examples & analogies**: What kind? From what domains?
- **Paragraph length**: Short and punchy? Long and flowing?
- **Questions**: How often? Rhetorical or genuine?
- **Lists & emphasis**: Bold? Italics? ALL CAPS? Dashes?
- **Emotional register**: Vulnerable? Confident? Both?

## Phase 2: Writing

Now write about {topic} in this voice:

**Topic:** {topic}
**Length:** {word_count} words
**Purpose:** {purpose — inform/persuade/entertain/inspire}

### Requirements
- Match sentence rhythm and variety from the samples
- Use the same vocabulary range
- Replicate tone and personality
- Include the kinds of examples/analogies they'd use
- Mirror formatting preferences

### Verification
After writing, explain:
"This matches the voice because: [3 specific elements from the fingerprint that you replicated]"

## Pre-Built Voice Examples

### Practitioner Voice (peer-to-peer)
- Short sentences. Fragments for emphasis.
- "I've been there" framing
- Vulnerable but grounded
- Practitioner-to-practitioner warmth
- Real-world examples, not theoretical
- Questions that mirror the reader's inner voice

### Thought Leader Voice (authority)
- Longer, more structured sentences
- Deep expertise made accessible
- Analogies from history and science
- Strategic framing with human warmth
- "Here's what I've learned" authority
- Big-picture perspective, specific application
