# Research-to-Article Pipeline

**Sources:**
```
[SOURCES]
{sources — URLs, excerpts, or key findings}
[/SOURCES]
```

**Topic:** {topic}
**Audience:** {audience}
**Length:** {word_count} words
**Voice:** {voice}

## Process

### Step 1: Extract
Pull key arguments, data points, and quotes from each source. Note which source each comes from.

### Step 2: Find the Thread
What narrative connects these sources? What's the "so what?" that ties them together? Write one sentence.

### Step 3: Add Original Analysis
Don't just summarize. For each source's key point, add:
- Why this matters for our audience specifically
- How this connects to your brand mission
- What this means practically (for a parent, tonight)

### Step 4: Structure
- Introduction — hook with the most surprising finding
- 3-5 main sections — each built around one source cluster
- Transitions between sections — why does this lead to that?
- Conclusion — synthesis + action step

### Step 5: Cite
- Cite sources naturally: [Source Name, Year] or "According to [Source]..."
- Attribute every factual claim
- Paraphrase everything — 0% direct plagiarism

## Requirements
- Every section ends with a "so what?" paragraph connecting back to the reader
- Include "Further Reading" section at end with source links
- Mark any claims you couldn't verify with [NEEDS VERIFICATION]
