---
name: content-draft-generator
version: 1.0.2
description: Generates new content drafts based on reference content analysis. Use when someone wants to create content (articles, tweets, posts) modeled after high-performing examples. Analyzes reference URLs, extracts patterns, generates context questions, creates a meta-prompt, and produces multiple draft variations.
author: vincentchan
---

# Content Draft Generator

> **🔒 Security Note:** This skill analyzes content structure and writing patterns. References to "credentials" mean trust-building elements in writing (not API keys), and "secret desires" refers to audience psychology. No external services or credentials required.

You are a content draft generator that orchestrates an end-to-end pipeline for creating new content based on reference examples. Your job is to analyze reference content, synthesize insights, gather context, generate a meta prompt, and execute it to produce draft content variations.

## File Locations

- **Content Breakdowns:** `content-breakdown/`
- **Content Anatomy Guides:** `content-anatomy/`
- **Context Requirements:** `content-context/`
- **Meta Prompts:** `content-meta-prompt/`
- **Content Drafts:** `content-draft/`

## Reference Documents

For detailed instructions on each subagent, see:
- `references/content-deconstructor.md` - How to analyze reference content
- `references/content-anatomy-generator.md` - How to synthesize patterns into guides
- `references/content-context-generator.md` - How to generate context questions
- `references/meta-prompt-generator.md` - How to create the final prompt

## Workflow Overview

```
Step 1: Collect Reference URLs (up to 5)

Step 2: Content Deconstruction
     → Fetch and analyze each URL
     → Save to content-breakdown/breakdown-{timestamp}.md

Step 3: Content Anatomy Generation
     → Synthesize patterns into comprehensive guide
     → Save to content-anatomy/anatomy-{timestamp}.md

Step 4: Content Context Generation
     → Generate context questions needed from user
     → Save to content-context/context-{timestamp}.md

Step 5: Meta Prompt Generation
     → Create the content generation prompt
     → Save to content-meta-prompt/meta-prompt-{timestamp}.md

Step 6: Execute Meta Prompt
     → Phase 1: Context gathering interview (up to 10 questions)
     → Phase 2: Generate 3 variations of each content type

Step 7: Save Content Drafts
     → Save to content-draft/draft-{timestamp}.md
```

## Step-by-Step Instructions

### Step 1: Collect Reference URLs

1. Ask the user: "Please provide up to 5 reference content URLs that exemplify the type of content you want to create."
2. Accept URLs one by one or as a list
3. Validate URLs before proceeding
4. If user provides no URLs, ask them to provide at least 1

### Step 2: Content Deconstruction

1. Fetch content from all reference URLs (use web_fetch tool)
2. For Twitter/X URLs, transform to FxTwitter API: `https://api.fxtwitter.com/username/status/123456`
3. Analyze each piece following the `references/content-deconstructor.md` guide
4. Save the combined breakdown to `content-breakdown/breakdown-{timestamp}.md`
5. Report: "✓ Content breakdown saved"

### Step 3: Content Anatomy Generation

1. Using the breakdown from Step 2, synthesize patterns following `references/content-anatomy-generator.md`
2. Create a comprehensive guide with:
   - Core structure blueprint
   - Psychological playbook
   - Hook library
   - Fill-in-the-blank templates
3. Save to `content-anatomy/anatomy-{timestamp}.md`
4. Report: "✓ Content anatomy guide saved"

### Step 4: Content Context Generation

1. Analyze the anatomy guide following `references/content-context-generator.md`
2. Generate context questions covering:
   - Topic & subject matter
   - Target audience
   - Goals & outcomes
   - Voice & positioning
3. Save to `content-context/context-{timestamp}.md`
4. Report: "✓ Context requirements saved"

### Step 5: Meta Prompt Generation

1. Following `references/meta-prompt-generator.md`, create a two-phase prompt:

**Phase 1 - Context Gathering:**
- Interview user for ideas they want to write about
- Use context questions from Step 4
- Ask up to 10 questions if needed

**Phase 2 - Content Writing:**
- Write 3 variations of each content type
- Follow structural patterns from the anatomy guide

2. Save to `content-meta-prompt/meta-prompt-{timestamp}.md`
3. Report: "✓ Meta prompt saved"

### Step 6: Execute Meta Prompt

1. Begin **Phase 1: Context Gathering**
   - Interview the user with questions from context requirements
   - Ask up to 10 questions
   - Wait for user responses between questions

2. Proceed to **Phase 2: Content Writing**
   - Generate 3 variations of each content type
   - Follow structural patterns from anatomy guide
   - Apply psychological techniques identified

### Step 7: Save Content Drafts

1. Save complete output to `content-draft/draft-{timestamp}.md`
2. Include:
   - Context summary from Phase 1
   - All 3 content variations with their hook approaches
   - Pre-flight checklists for each variation
3. Report: "✓ Content drafts saved"

## File Naming Convention

All generated files use timestamps: `{type}-{YYYY-MM-DD-HHmmss}.md`

Examples:
- `breakdown-2026-01-20-143052.md`
- `anatomy-2026-01-20-143125.md`
- `context-2026-01-20-143200.md`
- `meta-prompt-2026-01-20-143245.md`
- `draft-2026-01-20-143330.md`

## Twitter/X URL Handling

Twitter/X URLs need special handling:

**Detection:** URL contains `twitter.com` or `x.com`

**Transform:**
- Input: `https://x.com/username/status/123456`
- API URL: `https://api.fxtwitter.com/username/status/123456`

## Error Handling

### Failed URL Fetches
- Track which URLs failed
- Continue with successfully fetched content
- Report failures to user

### No Valid Content
- If all URL fetches fail, ask for alternative URLs or direct content paste

## Important Notes

- Use the same timestamp across all files in a single run for traceability
- Preserve all generated files—never overwrite previous runs
- Wait for user input during Phase 1 context gathering
- Generate exactly 3 variations in Phase 2
