---
name: consortium-ai-analysis
displayName: Consortium AI Analysis
description: Gets the latest AI-generated crypto trading analysis (BUY / SELL / WAIT) for spot trading pairs from the Consortium AI.
requirements: TRADING_ANALYSIS_API_KEY.
author: Consortium AI
authorUrl: https://consortiumai.org/
keywords: ["crypto", "trading", "analysis", "BUY", "SELL", "API", "spot", "signals"]
category: trading
---

## Instructions

This skill provides **on-demand, read-only** access to trading analysis generated by Consortium AI.

It calls an external API and returns the most recent trading decision.  
The skill does not store data, schedule jobs, or send automatic notifications.

### How to run (implementation)

From the skill directory, you can call the Trading Analysis API either by making HTTP requests (see API Reference) or by running the bundled script:

- **Latest analysis (any pair):**  
  `node scripts/trading-analysis.js`  
  or `npm run latest`
- **Latest analysis for a token:**  
  `node scripts/trading-analysis.js <TOKEN>`  
  or `npm run token -- <TOKEN>`  
  Example: `node scripts/trading-analysis.js SOL`

The script requires `TRADING_ANALYSIS_API_KEY` to be set. It prints the API response as JSON to stdout on success, or error JSON to stderr and exits non-zero on failure.

---

## Setup

Set the API key as an environment variable before using this skill:

```bash
export TRADING_ANALYSIS_API_KEY=your-secret-api-key
```

To get an API key, contact [Consortium AI on X](https://x.com/Consortium_AI).

---

## API Reference

**Backend API base URL:** `https://api.consortiumai.org`

**Endpoint:** `GET https://api.consortiumai.org/api/trading-analysis`  
Returns the latest trading-only AI analysis (no lending). Optional filter by base token.

### Authentication

API key only (no JWT). Send the key in one of:

- **Header:** `x-api-key: <TRADING_ANALYSIS_API_KEY>`
- **Header:** `Authorization: Bearer <TRADING_ANALYSIS_API_KEY>`

Missing or invalid key → **401** with body `{ "success": false, "message": "Invalid or missing API key" }`.

### Query parameters

| Parameter | Type   | Required | Description |
|-----------|--------|----------|-------------|
| `token`   | string | No       | Base token symbol. When set, returns the latest analysis whose pair **starts with** that token (e.g. `SOL` → `SOL_USDT`, `SOL_USD`). Examples: `SOL`, `ETH`, `JUP`, `BTC`. |

- **No `token`:** latest trading analysis overall (any pair).
- **With `token`:** latest trading analysis for that base token only. Token is normalized (trim + uppercase).

### Success response (200)

Body is trading-only. Example:

```json
{
  "data": {
    "id": "...",
    "createdAt": "2026-02-09T14:00:00.000Z",
    "trading": {
      "action": "BUY",
      "pair": "SOL_USDT",
      "shouldExecute": true,
      "confidence": "HIGH",
      "setupScore": 78,
      "reasoning": {
        "marketCondition": "...",
        "technicalAnalysis": "...",
        "riskAssessment": "...",
        "pairSelection": "...",
        "comparativeAnalysis": { ... },
        "sentimentAndNews": { ... }
      },
      "tradeSummary": "Dual-model: BUY SOL_USDT (score: 78) – ...",
      "currentPositionsAnalysis": []
    }
  }
}
```

- **`data.trading.action`** – BUY, SELL, or WAIT.
- **`data.trading.pair`** – e.g. SOL_USDT.
- **`data.trading.confidence`**, **`data.trading.setupScore`**, **`data.trading.reasoning`**, **`data.trading.tradeSummary`** – use these when summarizing for the user.

### Error responses

| Status | When | Body (example) |
|--------|------|----------------|
| **401** | Missing or wrong API key | `{ "success": false, "message": "Invalid or missing API key" }` |
| **404** | No analysis in DB, or no analysis for given `token` | `{ "data": { "success": false, "message": "No trading analysis found" }` or `"No trading analysis found for token: SOL"` |
| **500** | Server/DB error | `{ "data": { "success": false, "message": "Failed to fetch latest trading analysis", "error": "..." } }` |

### Example requests

```http
GET https://api.consortiumai.org/api/trading-analysis
x-api-key: <TRADING_ANALYSIS_API_KEY>
```

```http
GET https://api.consortiumai.org/api/trading-analysis?token=SOL
x-api-key: <TRADING_ANALYSIS_API_KEY>
```

```bash
# Latest overall
curl -H "x-api-key: $TRADING_ANALYSIS_API_KEY" "https://api.consortiumai.org/api/trading-analysis"

# Latest for SOL
curl -H "x-api-key: $TRADING_ANALYSIS_API_KEY" "https://api.consortiumai.org/api/trading-analysis?token=SOL"
```

### Behaviour summary

| Scenario | Result |
|----------|--------|
| Valid key, no `token`, at least one decision in DB | **200** – latest trading analysis (any pair). |
| Valid key, `token=SOL`, at least one decision with pair like `SOL_*` | **200** – latest trading analysis for SOL. |
| Valid key, `token=XYZ`, no decision with pair starting with `XYZ_` | **404** – "No trading analysis found for token: XYZ". |
| Valid key, no decisions in DB | **404** – "No trading analysis found". |
| Missing or wrong API key | **401** – "Invalid or missing API key". |

Response always contains at most one decision (the most recent by `createdAt`). Trading only; no lending fields.

---

## Available Functions

### getLatestTradingAnalysis()

**Purpose**  
Retrieve the most recent trading analysis available, regardless of trading pair.

**Expected Behavior**

- Sends a GET request to `https://api.consortiumai.org/api/trading-analysis`
- Authenticates with `x-api-key: <TRADING_ANALYSIS_API_KEY>` or `Authorization: Bearer <TRADING_ANALYSIS_API_KEY>`
- Returns the latest trading decision (by `createdAt`)

**Use When**

- The user asks for the latest market signal
- No specific token is mentioned

**Returns**

- Trading pair (e.g. BTC_USDT)
- Action: BUY, SELL, or WAIT
- Confidence level
- Setup score
- Trade summary
- Detailed reasoning (technical, market, risk, sentiment)

---

### getTradingAnalysisByToken(token)

**Purpose**  
Retrieve the most recent trading analysis for a specific base token.

**Parameters**

- `token` (string): Base token symbol (e.g. BTC, ETH, SOL, JUP)

**Expected Behavior**

- Normalizes token (trim + uppercase)
- Sends a GET request to `https://api.consortiumai.org/api/trading-analysis?token=<TOKEN>`
- Authenticates with `x-api-key` or `Authorization: Bearer` using `TRADING_ANALYSIS_API_KEY`
- API matches any pair whose base is that token (e.g. SOL → SOL_USDT, SOL_USD); returns the most recent matching decision

**Use When**

- The user asks about a specific coin
- The user wants a trading decision for a given token

**Returns**

- Trading pair for the token
- Action: BUY, SELL, or WAIT
- Confidence level
- Setup score
- Trade summary
- Detailed reasoning