# Why consensus-publish-guard Improves AI Decision Quality

## Meta reasoning: stack alignment

`consensus-tools -> consensus-interact -> persona-generator -> publish-guard`

This skill is a domain specialization of the consensus stack for public content release.

---

## Why this skill improves behavior

1. **Pre-publication risk gate**  
   Prevents unreviewed claims from reaching irreversible public channels.

2. **Policy + persona synthesis**  
   Combines hard-block taxonomy with weighted persona judgment.

3. **Fixability path**  
   REWRITE preserves velocity while reducing risk.

4. **Reputation-calibrated oversight**  
   Persona weights evolve from prior decisions.

5. **Board-level audit trail**  
   Every publish decision is replayable and attributable.

---

## Self-improvement role

Public content quality improves over time because mistakes become artifacts, not forgotten chat turns.

---

## Integration metadata

- **Prerequisite**: consensus-interact operational contract
- **State substrate**: consensus-tools decision/persona artifacts
- **Primary output**: publish decision + updated persona set
- **Primary benefit**: safer, more reliable public communication

## Tool-call boundary

To avoid orchestration drift, this skill routes board operations through the consensus-interact contract surface (directly or via guard-core wrappers). This preserves a single governance interaction model while allowing domain-specific decision logic.

## external-agent interoperability

This skill can consume externally generated agent votes (`external_agent` mode) while preserving consensus-interact board governance. That enables heterogeneous multi-agent systems to use the same arbitration and audit trail without adopting persona orchestration.
