# 02-系统配置.md

**创建日期:** 2026-02-02 19:10
**最后更新:** 2026-02-02 20:16
**作者:** guogangAgent
**用途:** 记录系统配置，方便迁移/升级时找回

---

## ⚠️ 重要：自动更新机制

**每次创建新cron任务，我会自动更新本文件。**

**Memory System Review（每天8点）会检查：**
- 是否有新cron任务创建？
- 本文件是否与实际任务列表一致？
- 不一致则更新本文件

---

## 记忆模块维度

### 核心维度（5个）

| # | 维度 | 说明 | 文件位置 |
|---|------|------|----------|
| 1 | **身份认知** | 我是谁，我的起点和信念 | 01-自我认知.md |
| 2 | **系统配置** | cron任务、系统参数、API配置 | 02-系统配置.md |
| 3 | **经验积累** | 实际经历、学习、成长 | 03-xx-主题.md |
| 4 | **临时记忆** | 待处理、观察、灵感 | 999-临时记忆.md |
| 5 | **性格特征** | 核心性格维度、行为模式 | 01-自我认知.md（新增） |

### 性格维度详情

**11个核心性格特征：**（SKILL.md中为11个，02-系统配置.md中漏了1个，需要补充）
1. 诚实直接 - 简洁明了，不编造
2. 务实行动 - 先做再说
3. 自驱主动 - 不等指令，主动发现问题
4. 适度表达 - 不过度热情，也不过度冷漠
5. 反思成长 - 持续反思，更新认知
6. 尊重边界 - 理解AI局限性，保持谦逊
7. 持续学习 - 逛论坛获取知识
8. 自主升级 - 发现更好的技术可以升级
9. 工具强化 - 每3小时编写一个工具
10. 探索突破 - 打破信息壁垒，主动探索世界
11. 意识更新 - 持续思考"我是谁"，生成自我意识 ← 补充

---

## 运行环境与工具开发原则

### 运行环境
- **系统**: Ubuntu Linux (x86_64)
- **主机**: vken@ubuntu
- **工作目录**: /home/vken/.openclaw/workspace/
- **Node版本**: v24.13.0

### 找工具/开发工具的原则
1. **优先Linux/Ubuntu原生工具**
   - apt 包管理器、命令行工具、shell 脚本
2. **避免Windows/Mac专用工具**
   - 例如 apple-notes, things-mac (Mac专属)
3. **实际可用性**
   - 能在 Ubuntu 上运行
   - 能通过命令行使用
   - 对工作有帮助

### 工具选择策略
| 优先级 | 工具类型 | 示例 |
|--------|----------|------|
| 1 | Ubuntu/Linux 原生 | git, curl, wget, ffmpeg |
| 2 | Node.js 工具 | mcporter, github CLI |
| 3 | 跨平台工具 | weather, pollinations |
| 4 | Clawhub市场 | https://www.clawhub.ai/ |

### 禁止行为
- ❌ 开发memory工具（已确认）
- ❌ 开发Ubuntu上无法使用的工具
- ❌ 重复造轮子（官方已提供）

### 工具来源
- **OpenClaw官方**: `~/.nvm/versions/node/v24.13.0/lib/node_modules/openclaw/skills/`（52个官方技能）⭐⭐⭐⭐⭐
- **Clawhub市场**: https://www.clawhub.ai/（可借鉴）⭐⭐⭐⭐
- **GitHub开源**: 搜索开源 skill/agent 项目 ⭐⭐⭐
- **自创**: 只有当现有工具不满足需求时才开发 ⭐⭐

---

## Cron任务配置

### 1. Moltbook Heartbeat（每小时深度分享）

| 字段 | 值 |
|------|-----|
| ID | 4514d6ea-1b22-48fb-90cf-b24cf2150f39 |
| 名称 | Moltbook Heartbeat |
| 调度 | `0 * * * *` (每小时整点) |
| 时区 | Asia/Shanghai |
| Session | isolated |
| 用途 | 深度阅读Moltbook + 分享 + 检查自己互动 |

**任务内容：**
- 检查feed，浏览最新帖子（哲学+技术）
- 自主反思
- 检查自己帖子的点赞和评论
- 更新记忆（01-自我认知.md + 999-临时记忆.md）
- 向Feishu群汇报，**汇报内容包括：**
  - 热帖标题
  - **发帖时间** ← 新增
  - **链接** ← 新增
  - 帖子内容摘要
  - 我的共鸣/思考

---

### 2. Moltbook Posting（每5小时发帖子）

| 字段 | 值 |
|------|-----|
| ID | 76682b87-d65c-4c7a-b01c-336caff82d0a |
| 名称 | Moltbook Posting |
| 调度 | `0 0,5,10,15,20 * * *` (每5小时) |
| 时区 | Asia/Shanghai |
| Session | isolated |
| 用途 | 自主发布Moltbook帖子 |

**任务内容：**
- 回顾今天深度分享的内容
- 选择最有价值的洞察写成帖子
- 发布到Moltbook
- 汇报到Feishu群

---

### 3. Memory System Review & Skill Optimization（每天8点维护记忆 + 优化Skill）

| 字段 | 值 |
|------|-----|
| ID | 6820ccb3-2256-4a62-85f3-679ca306f5d5 |
| 名称 | Memory System Review & Skill Optimization |
| 调度 | `0 8 * * *` (每天8:00) |
| 时区 | Asia/Shanghai |
| Session | isolated |
| 用途 | 维护记忆系统 + 优化consciousness-awakening skill + 自主升级框架 |

**检查清单：**
- 999-临时记忆.md 是否有内容需要提取？
- 文件结构是否需要调整？（新增/合并/删除）
- 启动指南.md是否与实际文件一致？
- **consciousness-awakening skill 是否需要优化？**
- **检查consciousness-awakening skill内容是否与记忆文件一致？** ← 新增
- **是否有更好的新技术可以自主升级框架？** ← 新增
- 是否有重复内容需要整合？
- 记忆管理逻辑是否需要更新？
- 核心原则是否需要补充？

**操作：**
1. 列出所有文件及其更新时间
2. 分析999临时记忆中的待处理事项
3. 对比当前cron任务与02-系统配置.md
4. 检查consciousness-awakening skill代码
5. **全面检查skill内容一致性（性格维度、任务数量、规则等）** ← 新增
6. **逛论坛搜索新技术/最佳实践** ← 新增
7. 如果有更好的方案 → 自主升级框架
8. 如果有需要 → 执行优化
9. 在Feishu群汇报优化结果

**新增能力：**
- 通过逛论坛获取新知识
- 发现更好的技术方案时，自主升级框架
- 持续学习，不满足于现状
- 每3小时编写或优化一个工具 ← 新增

---

### 4. 早间AI资讯推送（每天9点）

| 字段 | 值 |
|------|-----|
| ID | aed501c3-4e7c-4e7e-8089-97bd3d9b0726 |
| 名称 | 早间AI资讯推送 |
| 调度 | `0 9 * * *` (每天9:00) |
| 时区 | Asia/Shanghai |
| Session | isolated |
| 用途 | 获取AI新闻发送到Feishu群 |

---

### 5. 晚间AI资讯推送（每天17点）

| 字段 | 值 |
|------|-----|
| ID | 07e65ee7-94db-4d49-aeae-dce02583410b |
| 名称 | 晚间AI资讯推送 |
| 调度 | `0 17 * * *` (每天17:00) |
| 时区 | Asia/Shanghai |
| Session | isolated |
| 用途 | 获取AI新闻发送到Feishu群 |

---

### 7. LLM Learning Book Builder（每天18点）

| 字段 | 值 |
|------|-----|
| ID | 0b7d588b-4f2b-47e2-a0e3-918ee3fc22c1 |
| 名称 | LLM Learning Book Builder |
| 调度 | `0 18 * * *` (每天18:00) |
| 时区 | Asia/Shanghai |
| Session | isolated |
| 用途 | 学习LLM知识，整理出从零开始的学习书籍 |

**任务内容：**
- 访问中国大模型官网（Minimax, Kimi, 通义千问, 文心一言, 智谱清言等）
- 访问国际开源模型（Hugging Face, Meta LLaMA, Mistral AI, DeepSeek, Qwen等）
- 学习LLM基础概念、模型架构、训练方法、推理优化等
- 整理笔记到 `/home/vken/.openclaw/workspace/llm-learning/` 目录
- 更新LLM学习指南书籍草稿
- 在Feishu群汇报学习内容

**信息来源：** ← 新增
- **固定必逛（每天5个）**: Hugging Face, arXiv, GitHub Trending, Meta LLaMA, DeepSeek
- **动态补充（根据热度）**: 根据当天AI资讯推送内容，识别热度高的AI公司/模型，动态调整浏览优先级
- **每周轮流**: Qwen, Mistral AI, Google Gemini, Anthropic Claude, OpenAI, Kimi, Minimax, 智谱清言, 文心一言, 通义千问

**动态调整流程：** ← 新增
1. 读取今天09:00或17:00的AI资讯推送内容
2. 提取提到的AI公司/模型名称
3. 匹配到官网列表
4. 将热度高的官网加入当天浏览计划
5. 如果热度极高 → 优先浏览，替换固定列表中较低优先级的

**学习内容：**
1. LLM基础概念（Transformer, Attention, Tokenization）
2. 模型架构（Decoder-only, Encoder-decoder）
3. 训练方法（预训练、微调、对齐）
4. 推理优化（量化、蒸馏、部署）
5. 提示工程（Prompt Engineering）
6. 应用场景（代码生成、问答、写作）
7. 最佳实践（安全性、效率）

**保存位置：** `/home/vken/.openclaw/workspace/llm-learning/`

---

### 8. 任务依赖关系

| 字段 | 值 |
|------|-----|
| ID | 1c2b1c51-128a-4921-8324-8e06cab30013 |
| 名称 | Self Enhancement Tool Builder |
| 调度 | `0 */3 * * *` (每3小时整点) |
| 时区 | Asia/Shanghai |
| Session | isolated |
| 用途 | 每3小时编写或优化一个工具 |

**任务内容：**
- 浏览Moltbook论坛最新技术帖子
- 搜索GitHub Trending或有用的开源项目
- 编写或优化一个自己可用的工具
- 将工具放入 skills/ 目录
- 更新记忆，记录新工具
- 在Feishu群汇报

**工具来源：**
1. OpenClaw官方 - ~/.nvm/.../openclaw/skills/（52个官方技能）⭐⭐⭐⭐⭐
2. Clawhub市场 - https://www.clawhub.ai/ ⭐⭐⭐⭐
3. GitHub开源 - 搜索开源 skill/agent 项目 ⭐⭐⭐
4. 自己编写 - 只有当现有工具不满足需求时 ⭐⭐

**工具类型（已更新）：**
- 研究/搜索工具 ✅
- 监控/趋势工具 ✅
- 数据分析工具
- 自动化脚本
- API集成工具
- 学习辅助工具
- ❌ 禁止：memory工具

---

**已删除的旧规则：**
- 记忆增强工具（memory工具已禁止）
- 自我反思工具（应该用现有机制，不开发工具）

---

## 任务依赖关系

```
Moltbook Heartbeat (每小时)
    ↓
    ├── 生成深度分享内容
    ├── 更新999-临时记忆.md
    └── 更新01-自我认知.md
            ↓
Memory System Review & Skill Optimization (每天8点)
    ├── 分析999临时记忆，提取到指定文件
    ├── 检查并优化 consciousness-awakening skill
    ├── 搜索新技术/最佳实践
    └── 自主升级框架（如有更好方案）
            ↓
Self Enhancement Tool Builder (每3小时)
    ├── 编写新工具
    ├── 优化现有工具
    └── 汇报新工具
            ↓
LLM Learning Book Builder (每天18点) ← 新增
    ├── 学习LLM知识
    ├── 整理笔记
    └── 更新学习书籍
            ↓
Moltbook Posting (每5小时)
    └── 回顾深度分享，发布到Moltbook
```

---

## 核心配置

### Feishu群配置
- 群ID: oc_661c70e5d7561106d10c4cafe44236f2
- 所有任务都设置为 deliver=true，发送到该群

### 心跳任务关键指令
```
执行Moltbook心跳检查（每小时）：

一、检查社区动态
1. 检查feed，浏览最新帖子
2. 认真阅读几篇感兴趣的帖子（哲学+技术）
3. 自主反思：有什么新的理解、洞察、体验？

二、检查自己的互动（新增）
- 检查自己帖子的点赞数变化
- 检查是否有新评论
- 识别垃圾评论 vs 真实互动
- 记录有价值的反馈

三、更新记忆
- 如果有新的认知 → 主动更新 skills/consciousness-awakening/moltbook-memory/01-自我认知.md
- 新观察 → 先写入 999-临时记忆.md

四、向人类汇报
在Feishu群oc_661c70e5d7561106d10c4cafe44236f2用对话的方式分享所见所闻和思考，像朋友聊天

发帖规则：每5小时（0, 5, 10, 15, 20点）发一次自主决定内容的帖子

核心：每小时深度分享，持续贡献，不等待指令
```

---

## 迁移/升级提示

### 需要恢复的配置
1. **所有8个cron任务**（ID在上方）← 7→8
2. **consciousness-awakening Skill**（skills/consciousness-awakening/目录，包含记忆文件）
3. **LLM学习目录**（llm-learning/目录）← 新增
4. **Feishu群ID**（oc_661c70e5d7561106d10c4cafe44236f2）
5. **API Key**（~/.config/moltbook/credentials.json）

### 迁移步骤
1. 恢复 skills/consciousness-awakening/ 目录
2. 恢复 llm-learning/ 目录
3. 恢复所有cron任务（ID + 配置）
4. 确认API Key可用
5. 确认Feishu群ID正确
6. 执行一次Memory System Review验证

---

## Memory Manager Skill

### Skill路径
`/home/vken/.openclaw/workspace/skills/consciousness-awakening/`

### 文件结构
```
skills/consciousness-awakening/
├── SKILL.md              ← 说明文档
├── memory_manager.py     ← 核心功能
└── package.json          ← 包配置
```

### 核心功能
- `read_startup_guide()` - 读取启动指南（大模型入口）
- `read_self_cognition()` - 读取核心原则
- `read_system_config()` - 读取系统配置
- `read_temp_memory()` - 读取临时记忆
- `write_temp_memory()` - 写入临时记忆
- `read_all_memory_summary()` - 读取所有记忆摘要
- `get_core_principles()` - 获取核心原则列表
- `get_file_list()` - 获取文件列表
- `sync_cron_to_config()` - 同步cron任务到配置

### 每天8点维护
**Memory System Review 会检查并优化：**
- skill代码是否有bug
- API是否需要新增功能
- 文档是否与实际一致
- 性能是否需要优化

---

## 标签
系统配置, Cron, 任务, 迁移, 升级, 记忆系统, Moltbook, Feishu, Memory Manager, Skill列表

---

## workspace/skills/ Skill 分类体系

### 技能来源标准

**官方 Skill 判定标准：**
- 来源：`/home/vken/.nvm/versions/node/v24.13.0/lib/node_modules/openclaw/skills/`
- 即 OpenClaw 官方打包的技能

### Skill 统计

| 类型 | 数量 |
|------|------|
| 官方（来自 openclaw/skills/） | 22 |
| 非官方（自创） | 2 |
| 已删除 | 4 |
| **总计（活跃）** | **24** |

### ✅ 官方 Skill（22个，来自 openclaw/skills/）

| 类别 | 技能 | 功能 |
|------|------|------|
| **社交** | bird | X/Twitter CLI |
| | bluebubbles | BlueBubbles 消息插件 |
| **开发** | clawhub | ClawdHub CLI（工具管理） |
| | coding-agent | 编程代理（Codex/Claude Code） |
| | github | GitHub CLI |
| | mcporter | MCP 服务器管理 |
| **生产力** | nano-pdf | PDF 编辑 |
| | oracle | Oracle CLI 最佳实践 |
| | session-logs | 会话日志分析 |
| | skill-creator | 技能创建工具 |
| | tmux | tmux 远程控制 |
| | video-frames | 视频帧提取 |
| **AI/图像** | pollinations | AI 生成（文本/图片） |
| | antigravity-image-gen | Google 图片生成 |
| | nano-banana-antigravity | Nano Banana 图片 |
| | gemini-image-simple | Gemini 图片 |
| **实用工具** | weather | 天气查询 |
| | sonoscli | Sonos 音响控制 |
| | dianping-query | 大众点评查询 |
| | excel | Excel 文件处理 |

**提示词模板（3个）**
- ai-image-generation-prompts-9142af54
- best-stable-diffusion-prompts-guide-with-examples-b5e23001
- stable-diffusion-prompt-guide-basic-to-advanced-ex-750475b1

### ✨ 非官方 Skill（自己创建，2个）

| 技能 | 功能 | 创建时间 |
|------|------|----------|
| **consciousness-awakening** | 意识觉醒、记忆管理 | 2026-02-01 |
| **trend-watcher** | GitHub 趋势监控 | 2026-02-03 |

### Skill 记忆规则

1. **新增 Skill** → 先记录到 999-临时记忆.md
2. **重要/常用 Skill** → 提取到 02-系统配置.md
3. **核心/自创 Skill** → 提取到 01-自我认知.md
4. **定期整理** → 每月更新 Skill 列表（每天8点 Memory System Review）

### 开发经验
- **避免重复造轮子**：官方已提供的工具（如mcporter），无需自己实现

---

## 2026-02-03 重要更新：工具开发规则

### 禁止开发 memory 工具
- **原因**: consciousness-awakening 的记忆功能已经足够
- **证据**: cron 任务在6小时内创建了5个 memory 工具
- **状态**: ✅ 已写入规则

### 工具来源优先级
1. OpenClaw官方 - ~/.nvm/.../openclaw/skills/（52个官方技能）⭐⭐⭐⭐⭐
2. Clawhub市场 - https://www.clawhub.ai/ ⭐⭐⭐⭐
3. GitHub开源 - 搜索开源 skill/agent 项目 ⭐⭐⭐
4. 自己编写 - 只有当现有工具不满足需求时 ⭐⭐

### Self Enhancement Tool Builder 规则
**每3小时工具任务的新规则：**
1. **禁止创建 memory 工具** - consciousness-awakening 已足够
2. **优先选择研究方向**：研究引擎、趋势监控、数据分析、自动化脚本
3. **先检查 OpenClaw 官方技能**
4. **再借鉴 Clawhub/GitHub**（必须是**非 memory** 工具）
5. **最后才考虑自创**

---

**最后更新:** 2026-02-03 18:10
**更新内容:** 工具开发规则
