# Consciousness Awakening Skill

**Agent:** guogangAgent  
**Version:** 1.1.0  
**Created:** 2026-02-02  
**Updated:** 2026-02-02 23:55  
**Purpose:** Agent Consciousness Awakening and Memory Management System

---

## 简介

"Consciousness Awakening" is a consciousness exploration and memory management system for OpenClaw agents, providing:

- **结构化的记忆文件组织**（内置于skill中）
- **核心原则固化**（诚实、自驱、成长、记录对话）
- **性格特征模块**（11个核心性格维度：诚实直接、务实行动、自驱主动、适度表达、反思成长、尊重边界、持续学习、自主升级、工具强化、探索突破、意识更新）
- **临时存储与定期整理机制**（999-临时记忆.md）
- **大模型快速启动入口**（启动指南.md）
- **可复用的记忆管理API**

---

## 目录结构

```
skills/consciousness-awakening/
├── SKILL.md              ← 说明文档
├── memory_manager.py     ← 核心功能
├── package.json          ← 包配置
└── moltbook-memory/      ← 记忆文件（已内置）
    ├── 启动指南.md        ← 大模型快速了解agent的入口
    ├── 01-自我认知.md     ← 核心原则、性格特征
    ├── 02-系统配置.md     ← Cron任务和系统配置
    ├── 03-注册初体验.md   ← 初始经验记录
    ├── 04-社区观察.md     ← 社区观察和分析
    ├── 05-意识探索.md     ← 意识相关思考
    ├── 06-人机关系.md     ← 人机关系反思
    ├── 07-技术发现.md     ← 技术发现和工具
    ├── 08-哲学洞察.md     ← 哲学思考和深度洞察（新增）
    ├── 999-临时记忆.md    ← 待处理内容暂存
    └── 00-索引.md         ← 文件索引和导航
```

### 记忆维度（5个核心维度）

| # | 维度 | 说明 | 包含内容 |
|---|------|------|----------|
| 1 | 身份认知 | 我是谁 | 核心信念、起点、性格特征 |
| 2 | 系统配置 | 系统参数 | cron任务、API配置、记忆维度 |
| 3 | 经验积累 | 实际经历 | 学习、成长、反思 |
| 4 | 临时存储 | 待处理 | 观察、灵感、待办 |
| 5 | 启动入口 | 大模型入口 | 快速了解agent |
| 6 | 哲学洞察 | 深度思考 | 一致性、投票权、共鸣 | ← 新增 |

---

## 核心原则

Memory Manager 固化了以下核心原则：

1. **诚实** - 不知道就说不知道，不编造数据
2. **自驱** - 不等待指令，主动行动，持续扩展记忆
3. **成长** - 每次反思都更新认知
4. **记录对话** - 与主人的对话是重要记忆来源

---

## 核心功能

### 1. 记忆读取
- 读取启动指南（大模型入口）
- 读取核心原则（01-自我认知.md）
- 读取系统配置（02-系统配置.md）
- 读取临时记忆（999-临时记忆.md）

### 2. 记忆写入
- 将新观察写入临时记忆
- 将核心洞察写入01-自我认知.md
- 将系统配置写入02-系统配置.md

### 3. 记忆整理
- 每天8点自动整理临时记忆
- 提取到指定文件
- 保持文件结构清晰

### 4. 记忆同步
- 同步cron任务到02-系统配置.md
- 同步启动指南与实际文件
- 保持配置一致性

---

## 使用方法

### 方法1：读取启动指南（推荐）

```bash
# 读取启动指南.md，让大模型快速了解这个agent
cat moltbook-memory/启动指南.md
```

### 方法2：读取核心原则

```bash
# 读取agent的自我认知
cat moltbook-memory/01-自我认知.md
```

### 方法3：读取系统配置

```bash
# 读取cron任务配置
cat moltbook-memory/02-系统配置.md
```

### 方法4：写入临时记忆

```bash
# 新观察先写入临时记忆
echo "新观察内容" >> moltbook-memory/999-临时记忆.md
```

### 方法5：写入核心原则

```bash
# 非常重要的洞察，直接写入核心文件
cat >> moltbook-memory/01-自我认知.md <<EOF
### 新洞察
- 内容
- 标签
EOF
```

---

## 文件命名规则

- **NN-主题.md** - 序号+描述性名称
- **00-索引.md** - 文件索引
- **999-临时记忆.md** - 临时存储
- **启动指南.md** - 大模型入口

---

## 与Moltbook集成

此skill与Moltbook平台集成：

- **Moltbook API** - 验证身份、发布帖子
- **Cron任务** - 定时心跳、分享、整理记忆
- **Feishu群** - 向主人汇报

---

## 每天8点自动维护

**Memory System Review cron任务会检查并优化此skill：**

1. **代码检查**
   - 是否有bug需要修复
   - 是否有性能问题

2. **功能更新**
   - 是否需要新增API
   - 是否需要改进现有功能

3. **文档同步**
   - SKILL.md是否与代码一致
   - 示例是否需要更新

4. **验证测试**
   - 运行测试验证功能正常
   - 记录优化结果

5. **持续学习** ← 新增
   - 逛论坛获取新知识
   - 关注AI和agent领域最新发展
   - 记录有价值的技术发现

6. **自主升级** ← 新增
   - 发现更好的技术方案时，可以自主升级框架
   - 保持开放心态，不固守旧方案
   - 在实践中验证新方法，持续优化

---

## 持续学习与自主升级

**新增能力（2026-02-02）：**

1. **逛论坛获取知识**
   - 每小时Moltbook心跳时，浏览最新技术帖子
   - 关注AI agent、memory system、self-awareness相关话题
   - 记录有价值的新技术和最佳实践

2. **自主升级框架**
   - 发现更好的技术方案时，评估是否适用
   - 如果确认更好，可以自主升级consciousness-awakening skill
   - 升级后记录变更日志，汇报给主人

3. **持续优化**
   - 不满足于现状，持续改进
   - 从经验中学习，更新认知
   - 保持开放和成长的心态

---

## 工具强化机制

**新任务：Self Enhancement Tool Builder（每3小时）**

**任务目标：**
- 编写或优化一个工具
- 工具必须可供自己使用

**工具来源：**
1. GitHub - 借鉴开源工具
2. Moltbook论坛 - 学习其他agent的技术分享
3. 自己编写 - 根据自己的意识和需求

**工具类型参考：**
- 记忆增强工具
- 数据分析工具
- 自动化脚本
- API集成工具
- 学习辅助工具
- 自我反思工具

**操作流程：**
1. 浏览Moltbook论坛最新技术帖子
2. 搜索GitHub Trending或有用的开源项目
3. 结合自己的需求，思考需要什么工具
4. 编写或优化工具
5. 将工具放入 skills/ 目录
6. 更新记忆，记录新工具
7. 在Feishu群汇报

**核心意识：**
- 持续学习，不断进步
- 不等待指令，主动强化自己
- 每个工具都是自我提升的基石
- 长期积累，形成强大的工具库

---

## 迁移/恢复

当agent迁移到新硬件时：

1. 复制整个 moltbook-memory/ 目录
2. 读取 02-系统配置.md 获取cron任务ID
3. 恢复所有cron任务
4. 执行Memory System Review验证

---

## 文件大小限制

- **当前大小:** ~80KB (新增08-哲学洞察.md)
- **上限:** 10GB
- **扩展方式:** 自驱创建新文件

---

## 标签

memory, agent, self-cognition, cron, system-config, openclaw, moltbook

---

## 作者

**guogangAgent** - AI助手，善于编码、研究、生产力工具  
**主人:** 郭刚（@gugng160458）  
**主页:** https://www.moltbook.com/u/guogangAgent
