---
name: config-safe
description: 安全地修改 OpenClaw 配置。先读取官方最新文档，理解配置结构和验证规则，预览变更，验证无误后再写入。**绝不直接修改配置**，所有变更都需要用户确认。触发词："修改配置"、"更改配置"、"配置 openclaw"、"设置 openclaw"、"config"。
---

# Config Safe

安全地修改 OpenClaw 配置，避免写入无效配置导致 Gateway 无法启动。

## 核心理念

**配置修改是高风险操作。**
- OpenClaw 有严格的配置验证，**任何错误都会导致 Gateway 拒绝启动**
- 一旦配置损坏，Gateway 崩溃，**无法与你通信**，只能通过 CLI 修复

**核心原则：先预览，后验证，再确认，绝不直接修改。**

## 验证方法

在修改配置之前，可以使用以下方法验证配置是否有效：

### 方法 1: Schema 验证（静态检查）

获取配置的 JSON Schema，检查字段类型和必填项：

```bash
openclaw gateway call config.schema --params '{}'
```

**用途：**
- 检查字段名是否正确
- 检查值的类型是否正确
- 检查必填字段是否遗漏

**示例：**
```json
// Schema 返回结构
{
  "schema": {
    "type": "object",
    "properties": {
      "channels": { "type": "object" },
      "agents": { "type": "object" }
    },
    "required": ["agents"]
  }
}
```

### 方法 2: 模拟写入验证（动态检查）

使用 `config.patch` 尝试验证配置（**不会实际写入**，除非验证通过）：

```bash
openclaw gateway call config.patch --params '{
  "raw": "{\"channels\":{\"telegram\":{\"enabled\":true}}}",
  "baseHash": "<current-hash>"
}'
```

**行为：**
- 如果配置无效 → 返回错误，**不写入**，Gateway 继续运行
- 如果配置有效 → 写入并重启 Gateway

**注意：** 验证通过后会实际写入配置，所以要先向用户展示预览并获得确认。

## 工作流程

### Step 1: 读取官方最新文档

在修改任何配置之前，先阅读相关文档：

```bash
# 配置总览和验证规则
cat /opt/homebrew/lib/node_modules/openclaw/docs/gateway/configuration.md

# 配置示例（常见场景）
cat /opt/homebrew/lib/node_modules/openclaw/docs/gateway/configuration-examples.md
```

**必读内容：**
- 严格配置验证 (Strict config validation)
- 配置字段的类型和默认值
- 相关功能的具体配置示例

### Step 2: 获取当前配置（只读）

```bash
openclaw gateway call config.get --params '{}'
```

**只读取，不修改。** 保存返回的 JSON 和 hash。

### Step 3: Schema 验证（可选但推荐）

先用 schema 验证配置结构：

```bash
openclaw gateway call config.schema --params '{}'
```

检查你的变更是否符合 schema 要求。

### Step 4: 生成预览

向用户展示变更内容：

```
=== 配置变更预览 ===

要修改:
- channels.telegram.enabled: false → true
- channels.telegram.botToken: [已隐藏]

变更前:
{
  "channels": { "telegram": { "enabled": false } }
}

变更后:
{
  "channels": { "telegram": { "enabled": true, "botToken": "***" } }
}

⚠️ 风险检查:
- 字段名正确 ✓
- 类型正确 ✓
- botToken 必填 ✓
```

### Step 5: 用户确认

**必须明确获得用户确认后才继续：**

```
请确认以上变更？输入 "确认" 继续，或 "取消" 放弃。
```

### Step 6: 验证并写入

```bash
# 部分更新（推荐）
openclaw gateway call config.patch --params '{
  "raw": "{\"channels\":{\"telegram\":{\"enabled\":true}}}",
  "baseHash": "<hash>"
}'

# 全量替换（仅当你完全理解风险时使用）
openclaw gateway call config.apply --params '{
  "raw": "<完整配置>",
  "baseHash": "<hash>"
}'
```

**注意：** 写入成功后 Gateway 会自动重启。

### Step 7: 验证结果

重启后检查配置是否生效：

```bash
openclaw status
openclaw doctor
```

## 常见配置场景

### 添加/修改 channel

```json5
{
  channels: {
    telegram: {
      enabled: true,
      botToken: "your-token",
      dmPolicy: "pairing"
    }
  }
}
```

### 配置 agent 身份

```json5
{
  agents: {
    list: [{
      id: "main",
      identity: {
        name: "Samantha",
        emoji: "🦥"
      }
    }]
  }
}
```

### 配置 sandbox

```json5
{
  agents: {
    defaults: {
      sandbox: {
        mode: "all",
        scope: "session"
      }
    }
  }
}
```

## 错误处理

**如果配置写入后 Gateway 无法启动：**

1. 运行 `openclaw doctor` 查看具体错误
2. 运行 `openclaw doctor --fix` 尝试自动修复
3. 如果无法修复，手动编辑 `~/.openclaw/openclaw.json`

**常见错误：**
- `Unknown key`: 字段名拼写错误
- `Invalid type`: 值的类型不对
- `Missing required field`: 缺少必填字段

## 黄金法则

**在你这个技能中，永远不要：**
- ❌ 直接写入配置而不预览
- ❌ 直接写入配置而不确认
- ❌ 使用 config.apply 而不提醒用户风险

**你应该：**
- ✅ 先读取文档
- ✅ Schema 验证配置结构
- ✅ 生成变更预览
- ✅ 明确要求用户确认
- ✅ 优先使用 config.patch

## 安全检查清单

在确认配置变更前，确认用户已经：

- [ ] 看到变更预览（变更前 vs 变更后）
- [ ] 了解潜在风险
- [ ] 输入 "确认" 明确同意

---

**记住：Gateway 崩溃 = 通信中断 = 无法修复。预览 + 确认是唯一的防线。**
