# 复杂任务三步法 — S0→S3 立体评估与执行方法论

*Complex Task Three-Step Methodology — A Layered Assessment & Execution Framework*

---

## 为什么需要这个技能

AI 代理面对的任务复杂度跨越巨大的光谱——从"几点了"到"从零搭建一个分布式系统"。但大多数代理的处理方式是扁平的：要么一视同仁地跑完整流程（浪费），要么一律直接执行（冒进）。

这就像让一个外科医生用同一套手术流程处理纸片割伤和心脏搭桥。

**核心矛盾**是：

- 你不想每条消息都花 token 做复杂度评估——那是对 90% 简单消息的浪费
- 你也不想跳过评估直接执行——那会让 10% 的复杂任务在混乱中失败，回退成本远高于评估成本

这个技能的出发点是：**把任务复杂度评估本身，也当作一个需要被精心设计的工程问题来解决。**

---

## 思想原则

### 1. 分层防御，而非一刀切

灵感来自网络安全领域的纵深防御（Defense in Depth）。不是一道墙挡住所有攻击，而是多层过滤器，每层只做它擅长的事：

- **S0** 是门卫——规则匹配，零成本，挡住绝大多数"显然简单"的请求
- **S1** 是初诊医生——快速检查，给出复杂度评分，决定是否需要专家会诊
- **S2** 是手术规划——深度分析、多角度审计、锁定执行蓝图
- **S3** 是手术执行——分阶段、有质量控制、有回退机制

每一层只处理上一层无法判定的案例。流量逐层递减，成本逐层递增，但总成本被压到最低。

### 2. 灵敏度-成本的帕累托平衡

这是一个经典的信号检测问题。两种错误：

- **漏报**（False Negative）：复杂任务被当作简单任务执行 → 失败、返工、浪费
- **误报**（False Positive）：简单任务被当作复杂任务评估 → 多花了几百 token，但无害

漏报的代价远大于误报。所以系统的设计哲学是**宁可多评估一些，也不要漏掉真正复杂的任务**。具体来说：

- S0 的触发信号设计为**宽进严出**——多种信号（长度、意图动词、范围词、多步模式）中任一命中就进入 S1
- S1 的阈值设计为**保守分流**——只有明确简单（≤8分）才跳过规划
- 即使前面都漏了，还有**动态升级兜底**——执行中发现复杂度超预期，可以中途切入完整流程

### 3. 规划是铁约束，不是参考建议

很多任务失败不是因为没有规划，而是因为规划完了就忘了。S2 产出的执行蓝图被设计为**锁定的**——S3 的所有执行都围绕它展开，偏离必须记录原因。

这个设计借鉴了工程领域的"设计冻结"（Design Freeze）概念：在某个节点之后，设计不再随意变更，变更必须走正式流程。不是因为计划一定完美，而是因为**无纪律的变更**比**不完美的计划**更危险。

### 4. 并行是天然的，串行是例外

真实世界的任务很少是纯线性的。前端和后端可以同时开发，多个数据源可以同时查询，文档和代码可以同时推进。

S2 的步骤规划使用 **DAG（有向无环图）** 结构而非线性列表。每个步骤声明自己的依赖（`depends_on`），执行引擎自动并行调度所有依赖已满足的步骤。这不是优化——这是还原任务的真实结构。

### 5. 质量不是事后检查，而是贯穿全程

S3 的三道防线（Audit → QA → Defect Rule）不是在最后做一次大检查，而是**每个步骤完成时就审计**。问题越早发现，修复成本越低。

缺陷修改的四级分级（Critical/High/Medium/Low）是对"谁有权修改已锁定成果"的权限控制——不是所有问题都需要人类介入，也不是所有问题都可以自动修复。

---

## 架构总览

```
用户消息
    │
    ▼
┌──────────────────────────────────────────┐
│  S0  零成本预筛选                          │
│  规则匹配 · 0 token · 过滤 ~80% 消息       │
│  ✓ 简单 → 直接执行                         │
│  ? 疑似复杂 → 进入 S1                      │
└──────────────┬───────────────────────────┘
               │ ~20% 消息
               ▼
┌──────────────────────────────────────────┐
│  S1  轻量复杂度评估                        │
│  五维打分 · ~300 token                     │
│  ≤ 8 分  → 直接执行                        │
│  9-15 分 → 轻规划，边做边调整               │
│  > 15 分 → 进入 S2                         │
└──────────────┬───────────────────────────┘
               │ ~5% 消息
               ▼
┌──────────────────────────────────────────┐
│  S2  深度规划 & 审计                        │
│  Plan Mode → Audit Mode → ≤2 轮修改       │
│  DAG 并行步骤 · 执行蓝图锁定               │
└──────────────┬───────────────────────────┘
               │
               ▼
┌──────────────────────────────────────────┐
│  S3  分阶段执行 & 质量控制                  │
│  Phase 并行(DAG) · QA 审计循环             │
│  成果锁定 · 缺陷修改分级                    │
│  三道防线: Audit → QA → Defect Rule        │
└──────────────────────────────────────────┘
               │
               ▼
           ✅ 完成
```

**动态升级兜底**：任何阶段执行过程中发现复杂度被低估，可中途触发重新评估并升级到完整流程。

---

## S0：零成本预筛选

每条用户消息都经过此层。纯规则匹配，不调用模型。

**直接放行**（白名单）：
- 单轮问答："几点了"、"天气怎样"
- 延续指令："继续"、"下一步"
- 简单指令："搜索X"、"发消息给Y"
- 闲聊确认："好的"、"谢谢"

**触发 S1 的信号**（任一命中）：

| 信号 | 示例 |
|------|------|
| 长度 > 200 字 | 多段落描述的需求 |
| 意图动词 | 开发、构建、设计、部署、迁移、重构 |
| 范围词 | 整个、全部、系统、架构、从零开始 |
| 多步模式 | "先…然后…最后…" |
| 不确定性 | 代理无法判断单步执行路径 |
| 显式触发 | "复杂任务"、"三步法"、"需要规划" |

---

## S1：轻量复杂度评估

五个维度，每项 1-5 分：

| 维度 | 评估内容 |
|------|----------|
| 步骤数 | 预估需要几步 |
| 知识域 | 涉及几个不同领域 |
| 不确定性 | 有多少未知需要先搜索 |
| 失败代价 | 做错了的回退成本 |
| 工具链 | 需要协调几个工具/系统 |

**决策阈值**：
- **≤ 8 分**：直接执行
- **9-15 分**：轻规划（列步骤，边做边调整）
- **> 15 分**：完整三步法（S2 → S3）

---

## S2：深度规划 & 审计

**Plan Mode**（高能力模型）→ 任务分解为 DAG 结构，标注依赖和风险

**Audit Mode**（审计模型）→ 检查完整性、合理性、可行性

最多 2 轮 Plan-Audit 修改循环，通过后锁定为执行蓝图。

### DAG 并行步骤

```json
{
  "steps": [
    {"id": 1, "action": "分析需求", "depends_on": []},
    {"id": "2a", "action": "搜索文档", "depends_on": [1]},
    {"id": "2b", "action": "查本地缓存", "depends_on": [1]},
    {"id": 3, "action": "综合结果", "depends_on": ["2a", "2b"]}
  ]
}
```

所有 `depends_on` 已完成的步骤同时执行。

---

## S3：分阶段执行 & 质量控制

- 按 Phase 执行，同 Phase 内步骤可并行
- 每步完成后 QA 审计 → 通过则成果锁定
- 后续 Phase 使用前置 Phase 的锁定成果

**缺陷修改分级**：

| 严重度 | 处理 |
|--------|------|
| Critical | 自动批准 |
| High | 自动批准 + 通知人类 |
| Medium | 人类确认后修改 |
| Low | QA 自行决定 |

---

## 适用范围

这不是一个只为软件开发设计的流程。它适用于任何被评估为复杂的任务：

- **开发**：构建系统、重构架构、迁移数据库
- **研究**：调研报告、竞品分析、技术选型
- **运维**：故障诊断、系统迁移、安全审计
- **内容**：长文写作、翻译项目、文档体系
- **规划**：项目计划、预算编制、流程设计

S0 的预筛选规则和 S1 的评估维度本身也是可配置的——不同领域可以调整触发词和阈值。

---

## 与 AI 代理生态的关系

| 机制 | 关系 |
|------|------|
| 语义路由 | S0 预筛选复用同一模式匹配思路 |
| 任务执行规范 | 三步法是其上层框架 |
| Coding Team | 三步法的一个特化实例 |
| Heartbeat 主动任务 | 默认走 S0 筛选 |

---

## 安装

```bash
clawhub install complex-task-methodology
```

## 配置

关键参数在 `SKILL.md` 中可调：

| 参数 | 默认值 | 说明 |
|------|--------|------|
| S0 长度阈值 | 200 字 | 触发 S1 的消息长度 |
| S1 简单上限 | 8 分 | 低于此分直接执行 |
| S1 中等上限 | 15 分 | 低于此分轻规划，高于进 S2 |
| S2 最大修改轮数 | 2 | Plan-Audit 循环上限 |
| 动态升级失败阈值 | 2 | 连续失败几次触发升级 |

---

## 设计哲学小结

> **用最少的资源识别真正需要资源的任务，然后把资源集中在那些任务上。**

这不是一个复杂的系统。它是一个对"什么时候该复杂、什么时候该简单"这个问题的系统性回答。

大多数消息不需要规划。少数消息需要精密规划。区分它们的成本应该接近于零。这就是 S0 存在的意义。

规划不是浪费时间。没有规划的执行才是。这就是 S2 存在的意义。

执行不是一个人的事。它需要审计、质量控制、和分级的问题修复机制。这就是 S3 存在的意义。

---

*Version 1.0.0 · Created 2026-03-01*
*Authors: Sir & DeepEye · Collaborative Design*
*License: MIT*
