# Research Frameworks — Competitor Research

## Quick Scan Framework
**Time:** 15-30 minutes
**When:** Initial exploration, validating a hunch

### Process
1. Google "[niche] + competitors" and "[niche] + alternatives"
2. Check G2/Capterra category pages
3. Look at "Compare" pages of known players
4. Scan Product Hunt for recent entrants

### Output
- List of 5-10 players
- One-sentence description each
- Quick observation on who dominates

---

## Standard Research Framework
**Time:** 1-2 hours
**When:** Business planning, market entry decisions

### Process
1. **Landscape scan** (20 min)
   - All players in the space
   - Categorize by segment
   
2. **Competitive matrix** (30 min)
   - Compare on 5-7 key dimensions
   - Note pricing tiers
   
3. **Positioning analysis** (20 min)
   - How each positions themselves
   - What space is unclaimed
   
4. **Gap analysis** (20 min)
   - Customer complaints
   - Underserved segments
   - Missing features

### Output
- Market overview
- Competitive matrix table
- 3-5 identified gaps
- Recommended positioning angle

---

## Deep Dive Framework
**Time:** Half day or more per competitor
**When:** Serious competitive threat, strategic decisions

### Process per Competitor

**Hour 1: Public Intel**
- Website deep scan (all pages, not just home)
- Pricing page analysis
- Blog/changelog review (last 6 months)
- About/team page
- Press releases

**Hour 2: Customer Voice**
- G2/Capterra reviews (read actual reviews, not just scores)
- Twitter/social mentions
- Reddit discussions
- Review site comments
- Support forum if public

**Hour 3: Product**
- Check demo videos and screenshots
- Watch demo videos
- Check integration pages
- Feature comparison pages
- API documentation (signals technical depth)

**Hour 4: Business Intel**
- Crunchbase/LinkedIn for size, funding
- Job postings (reveal priorities)
- Glassdoor (internal culture signals)
- News/press coverage
- Conference presentations

### Output
- Detailed competitor profile
- SWOT analysis
- Win/Lose analysis
- Strategic recommendations

---

## SWOT Template

```
STRENGTHS (internal, positive)
- What they do well
- Resources they have
- Reputation/brand

WEAKNESSES (internal, negative)
- Where they struggle
- Known complaints
- Resource gaps

OPPORTUNITIES (external, positive)
- Market trends favoring them
- Expansion possibilities
- Underserved segments they could grab

THREATS (external, negative)
- Market trends against them
- Competitive pressure
- Technology shifts
```

---

## Jobs-to-Be-Done Analysis

For each competitor, identify:

**Functional Jobs**
- What task does the customer accomplish?
- "When I [situation], I want to [action], so I can [outcome]"

**Emotional Jobs**
- How does the customer want to feel?
- What anxiety does it reduce?

**Social Jobs**
- How does the customer want to be perceived?
- What status does it signal?

**Underserved Jobs**
- What jobs are customers trying to do that nobody serves well?
- Where is satisfaction lowest?

---

## Positioning Analysis

### Elements to Capture
| Element | What to Look For |
|---------|------------------|
| Headline | Main claim on homepage |
| Subhead | Supporting value prop |
| Visual identity | Premium, playful, technical, etc. |
| Proof points | How they back up claims |
| Target signal | Who they're clearly for |
| Differentiation | What they claim is unique |

### Positioning Map
Plot competitors on two axes that matter:
- X: Price (low to high) or Simplicity (easy to complex)
- Y: Target (SMB to Enterprise) or Feature depth (basic to advanced)

Find the empty quadrant.

---

## Win/Lose Framework

### Questions to Answer
| Question | Why It Matters |
|----------|----------------|
| Who is their ideal customer? | Know when you're competing and when you're not |
| What do they do better than anyone? | Respect their strengths |
| Where do they fall short? | Your opportunity |
| What would make someone switch TO them? | Their wedge |
| What would make someone switch FROM them? | Your wedge |

### Red Flags
Watch for competitors who:
- Have recent significant funding (can outspend you)
- Are owned by larger company (resources, distribution)
- Have network effects (hard to disrupt)
- Own the "default" position in the market

---

## Gap Analysis Framework

### Types of Gaps

**Segment gaps**
- Who is underserved?
- Who do all competitors ignore?

**Feature gaps**  
- What's missing that should exist?
- What's broken that nobody fixes?

**Price gaps**
- Is the market overpriced for some segment?
- Is there room for premium where none exists?

**Experience gaps**
- What's unnecessarily hard?
- What causes the most complaints?

**Positioning gaps**
- What story is nobody telling?
- What angle is unclaimed?

### Validation
For each gap, ask:
- Is this a real problem or just a curiosity?
- Would people pay to have this solved?
- Why hasn't anyone solved it? (might be a reason)
- Can you actually deliver on this?
