---
name: competitive-intelligence-market-research
description: B2B SaaS competitive intelligence with 24 scenarios across Sales/HR/Fintech/Ops Tech
metadata: {"clawdbot":{"emoji":"🔍","homepage":"https://github.com/shashwatgtm","always":true}}
---
## **🎯 Multi-Dimensional Navigator**

**This skill serves B2B SaaS companies across multiple dimensions. Find your path:**

### **STEP 1: What's Your Industry Vertical?**

Your industry determines:
- Which competitors to track
- What research is critical vs nice-to-have
- Regulatory constraints
- Competitive positioning strategies
- Risk tolerance for aggressive tactics

```
→ Sales Tech (Gong, Outreach, Salesloft) - See Section A
→ HR Tech (Culture Amp, Lattice, BambooHR) - See Section B  
→ Fintech (Razorpay, Happay, Stripe) - See Section C
→ Operations Tech (FieldAssist, Locus, logistics/retail) - See Section D
→ Other B2B SaaS - Use Sales Tech as base, adapt as needed
```

### **STEP 2: What's Your Company Stage?**

Your stage determines:
- Research budget available
- Tool sophistication
- Time you can invest
- Depth of analysis needed
- Who does the work

```
→ Series A ($1M-10M ARR, 10-200 employees) - Path 1
→ Series B/C ($10M-50M ARR, 200-1000 employees) - Path 2
→ Series D+ ($50M+ ARR, 1000+ employees) - Path 3
```

### **STEP 3: What's Your Primary Market?**

Your geography determines:
- Competitor set (local vs global)
- Pricing benchmarks
- Market size calculation methods
- Research sources available
- Language/cultural considerations

```
→ India-first market - India guidance
→ US-first market - US guidance  
→ Global/multi-market - Hybrid approach
```

### **STEP 4: Who's Doing This Research?**

Your role determines:
- Autonomy level
- Approval workflows
- Time available
- Output format needed

```
→ Founder/Co-Founder - Full autonomy
→ VP/Director - Manager approval
→ Product Marketing Manager - Team collaboration
→ Strategy/Insights Team - Stakeholder coordination
```

---

## **Quick Navigation by Common Scenarios**

**Most Common Use Cases:**

1. **"I'm a Series A founder building battle cards for my sales team"**
   → Go to: **Section A1** (Sales Tech, Series A, Founder-Led Research)

2. **"I'm a PMM at Series B HR Tech, need competitive analysis for upmarket move"**
   → Go to: **Section B2** (HR Tech, Series B, Professional Research)

3. **"I'm CMO at Series C fintech, board wants market landscape"**
   → Go to: **Section C3** (Fintech, Series C+, Strategic Intelligence)

4. **"I'm VP at ops tech selling to India retail, need to size market"**
   → Go to: **Section D1** (Operations Tech, India Market Sizing)

---

# 📊 SECTION A: SALES TECH COMPETITIVE INTELLIGENCE

**When To Use This Section:**
- Your product: Sales engagement, conversation intelligence, sales enablement, coaching
- Your competitors: Gong, Outreach, Salesloft, Chorus, Apollo, ZoomInfo
- Your buyers: Sales leaders, CROs, RevOps
- Your go-to-market: PLG or sales-led for SMB/Mid-market

---

## **A1: Sales Tech @ Series A (Scrappy Founder Research)**

### **Your Reality Check:**

```
COMPANY PROFILE:
- Size: $1M-10M ARR, 10-100 employees
- Stage: Series A, finding PMF → scaling
- Team: Founder or PM doing research (side of desk)
- Budget: $0-500/month for ALL tools
- Timeline: 2-3 days max (need it for pitch/sales enablement)
```

### **The Sales Tech Competitive Landscape:**

**Your Competitor Tiers:**

```
TIER 1: Enterprise Incumbents (NOT your competition... yet)
- Gong ($500M+ valuation, enterprise-focused)
- Outreach (public, enterprise)
- Salesloft ($2.3B valuation, mid-market+)
WHY THEY MATTER: Buyers know these brands, you'll be compared
YOUR ANGLE: "Too expensive/complex for SMBs"

TIER 2: Growth-Stage Competitors (Your Real Competition)
- Chorus (acquired by ZoomInfo, mid-market)
- Revenue.io (Series B, conversation intelligence)
- Wingman (India-based, SMB focus)
WHY THEY MATTER: Similar stage, similar ICP
YOUR ANGLE: Feature differentiation, regional focus

TIER 3: Emerging Startups (Watch List)
- Seed/Series A conversation intelligence startups
- AI sales coaching tools
- Regional players (India, SEA)
WHY THEY MATTER: Could pivot into your space
YOUR ANGLE: Speed, innovation, local expertise
```

### **Series A Sales Tech Research: 3-Day Sprint**

**GOAL:** Positioning deck + battle cards for sales team

**DAY 1: Competitive Landscape Mapping (4 hours)**

```
09:00-10:00 | Define Your Competitive Set

For Sales Tech, consider:
□ Direct: Same solution (conversation intelligence)
□ Indirect: Different tech, same outcome (sales training platforms)
□ Adjacent: Complementary (CRM, sales engagement platforms)

India-specific search strings:
- "conversation intelligence India"
- "sales enablement software India"
- "alternatives to Gong for SMB"
- "affordable sales coaching tools"

US search strings:
- "Gong alternatives for small teams"
- "sales tech for Series A companies"
- "conversation intelligence under $10K"

10:00-11:30 | Categorize Competitors

TEMPLATE:
Company | Tier | ICP | Price Point | Geography | Strength | Weakness
Gong | Tier 1 | Enterprise | $20K-50K+ | US/Global | Deep analytics | Too expensive
Wingman | Tier 2 | SMB | $5K-15K | India | Local | Limited features
[Yours] | - | SMB | $3K-10K | India→US | AI coaching | New brand

11:30-13:00 | Pricing Research (Critical for Sales Tech)

Sales Tech = Price-sensitive market

FREE RESEARCH SOURCES:
□ G2 reviews mentioning price: "Filter by 'pricing' mentions"
□ Reddit r/sales: "What do you pay for [tool]?"
□ LinkedIn polls: "What's your sales tech budget?"
□ Competitor job posts: Sales compensation = pricing signals

WHAT TO FIND:
- Gong: $1,500-4,000/seat/year (from reviews)
- Outreach: $100-150/user/month
- YOUR TARGET: 50-70% cheaper than incumbents

PRICING POSITIONING:
"Enterprise features, SMB pricing"
"Gong-quality insights at 1/3 the cost"
```

**DAY 2: Feature & Positioning Deep Dive (4 hours)**

```
09:00-11:00 | G2 Review Mining (Sales Tech Specific)

Sales Tech buyers care about:
1. Ease of implementation (IT approval hurdle)
2. Call recording quality
3. CRM integration (Salesforce, HubSpot MUST-HAVE)
4. Coaching insights (actionable)
5. ROI/deal velocity improvement

WHAT TO EXTRACT:
□ Top 3 features mentioned in 5-star reviews
□ Top 3 complaints in 1-2 star reviews
□ "Switched from X because..." patterns
□ "Considering X vs Y" comparisons

SALES TECH SPECIFIC INSIGHTS:
- 67% mention "Salesforce integration" as critical
- 43% complain about "too many features we don't use"
- 31% say "too expensive for our team size"
- 22% want "real-time coaching vs post-call analysis"

YOUR OPPORTUNITY:
✅ Simplified feature set (80% of value, 20% of complexity)
✅ SMB pricing ($200-500/seat/year vs $1,500+)
✅ AI coaching focus (vs pure analytics)
✅ India-first, then global

11:00-13:00 | GTM Strategy Analysis

Sales Tech companies typically use:

ENTERPRISE (Gong, Outreach):
- Channel: Outbound sales (100+ SDRs)
- Content: Thought leadership, podcasts, events
- Pricing: Enterprise sales, no public pricing
- Cycle: 3-6 months

MID-MARKET (Chorus, Revenue.io):
- Channel: Hybrid (inbound + outbound)
- Content: SEO, webinars, free tools
- Pricing: Visible tiers, sales for enterprise
- Cycle: 1-3 months

SMB (Your Target):
- Channel: PLG + inbound
- Content: Tactical guides, YouTube, free tier
- Pricing: Self-serve, transparent pricing
- Cycle: <30 days

COMPETITIVE INTEL:
□ Check LinkedIn: Hiring SDRs = outbound motion
□ Check content: Blog topics = SEO keywords they target
□ Check ads: Facebook Ad Library for messaging
```

**DAY 3: Synthesis & Battle Cards (4 hours)**

```
09:00-10:30 | Positioning Matrix (Sales Tech Specific)

2×2 MATRIX:
X-Axis: Enterprise ←→ SMB
Y-Axis: Pure Analytics ←→ Coaching Focus

WHERE COMPETITORS LAND:
- Gong: Top-left (Enterprise, Analytics)
- Outreach: Left-center (Enterprise, Engagement)
- Chorus: Center (Mid-market, Analytics)
- [YOU]: Bottom-right (SMB, Coaching)

WHITE SPACE IDENTIFIED:
✅ SMB + Coaching focus = underserved
✅ India market (Gong expensive for Indian SMBs)
✅ AI-powered real-time coaching (vs post-call)

10:30-12:00 | Battle Cards (Top 3 Competitors)

BATTLE CARD TEMPLATE - SALES TECH FOCUS:

┌─────────────────────────────────────────────┐
│ VS. GONG (Enterprise Incumbent)             │
├─────────────────────────────────────────────┤
│ THEIR STRENGTHS:                            │
│ • Deep conversation analytics               │
│ • Forecasting accuracy                      │
│ • Enterprise-grade security                 │
│ • 1000+ integrations                        │
│                                             │
│ THEIR WEAKNESSES:                           │
│ • Price: $20K-50K+ annually (too expensive) │
│ • Complexity: Overkill for SMB (10-50 reps)│
│ • Setup: Requires IT, 2-4 week onboarding  │
│ • Contract: Annual commit, enterprise sales │
│                                             │
│ WHEN THEY WIN:                              │
│ • Large sales org (50+ reps)                │
│ • Complex B2B sales (6+ month cycles)       │
│ • Enterprise budget ($50K+ sales tech)      │
│ • Need forecasting + analytics depth        │
│                                             │
│ WHEN WE WIN:                                │
│ • SMB sales team (5-25 reps)                │
│ • Tight budget (< $10K/year sales tech)     │
│ • Need coaching > analytics                 │
│ • Fast setup required (< 1 week)            │
│                                             │
│ OUR COUNTER-POSITIONING:                    │
│ "Gong is built for Salesforce with 500 reps│
│  We're built for startups with 15 reps.    │
│  Same AI insights, 1/3 the price,           │
│  10× faster setup."                         │
│                                             │
│ SALES TALKING POINTS:                       │
│ 1. "Save $15K/year vs Gong"                 │
│ 2. "Setup in 1 day vs 4 weeks"              │
│ 3. "AI coaching, not just dashboards"       │
│ 4. "Built for Indian SMB sales teams"       │
│                                             │
│ OBJECTION HANDLERS:                         │
│ "But Gong is the category leader..."        │
│ → "For enterprise. You're not enterprise.   │
│    You need 80% of Gong at 20% of the cost."│
│                                             │
│ "Gong has more features..."                 │
│ → "Which features do your 12 reps actually  │
│    use? We focus on coaching that helps reps│
│    close deals this quarter."               │
└─────────────────────────────────────────────┘

12:00-13:00 | Market Sizing (Sales Tech, India Focus)

BOTTOM-UP APPROACH:

STEP 1: Define ICP
- B2B SaaS companies
- $1M-10M ARR
- 10-50 employees
- India geography
- Have sales team (5+ people)

STEP 2: Count Companies (FREE TOOLS)
□ LinkedIn Sales Navigator (free trial):
  - Filter: "B2B SaaS" + "India" + "10-50 employees"
  - Count: ~2,500 companies

□ Crunchbase (free tier):
  - Filter: "B2B" + "India" + "$1M-10M funding"
  - Count: ~1,800 companies

□ Cross-reference: ~2,000 companies (conservative)

STEP 3: Estimate Deal Size
□ Research 10 competitor pricing pages
□ G2 reviews mentioning price
□ Assume: $5K average annual contract value

STEP 4: Calculate SAM
2,000 companies × $5,000 = $10M SAM (India only)

VALIDATION:
- Does this feel right for India B2B SaaS sales tech?
- Cross-check: Wingman (Indian competitor) raised $X, implies $Y market
- Sense check with 3 sales leaders: "Does $10M India market sound right?"

TOP-DOWN VALIDATION:
- Global sales enablement: $5B (Gartner)
- India = ~1.5% of global B2B SaaS market
- $5B × 1.5% × 30% (conversation intel subset) = ~$22M
- Bottom-up $10M vs top-down $22M → Use conservative $10-15M SAM
```

### **Output: Series A Sales Tech Deliverable Package**

```
DELIVERABLE 1: Competitive Landscape (Google Slides)
- Slide 1: Market map (30+ companies plotted)
- Slide 2: 2×2 positioning matrix
- Slide 3: Competitive tiers (Enterprise/Growth/Emerging)
- Slide 4: White space opportunity

DELIVERABLE 2: Battle Cards (Google Doc)
- Top 5 competitors
- 1-page per competitor
- Sales talking points
- Objection handlers
- When we win/lose

DELIVERABLE 3: Market Sizing (Spreadsheet)
- TAM-SAM-SOM calculations
- Data sources cited
- Methodology explained
- Conservative + aggressive scenarios

DELIVERABLE 4: Strategic Recommendations (1-pager)
- Positioning: "Gong for Indian SMBs"
- Pricing: $3K-8K/year (vs Gong $20K+)
- GTM: PLG motion, self-serve, fast setup
- Roadmap: Must-have integrations (Salesforce, HubSpot)

TIME INVESTED: 12 hours over 3 days
TOOLS COST: $0 (used free trials)
OUTPUT QUALITY: Good enough for Series A pitch deck + sales enablement
```

### **Sales Tech Specific: Free Research Sources**

```
ESSENTIAL (Use These):
□ G2 Sales Software category (18,000+ reviews)
□ r/sales on Reddit (140K sales pros sharing)
□ Sales Hacker community (tactical insights)
□ Revenue Collective (sales leader slack)
□ LinkedIn Sales Navigator (15-day trial)

SALES-TECH SPECIFIC SOURCES:
□ Pavilion community (CRO insights)
□ SaaStr community (B2B SaaS)
□ Modern Sales Podcast (competitor mentions)
□ Gong's blog (learn from category leader)

INDIA-SPECIFIC:
□ SaaSBoomi community (India B2B SaaS)
□ Indian startup funding announcements
□ Economic Times tech coverage
□ Inc42 (Indian startup news)
```

---

## **A2: Sales Tech @ Series B (Professional Product Marketing Research)**

### **Your Reality Check:**

```
COMPANY PROFILE:
- Size: $10M-30M ARR, 150-500 employees
- Stage: Series B, scaling GTM
- Team: Product Marketing Manager (you) + maybe 1 analyst
- Budget: $1K-5K/month for research tools
- Timeline: 2 weeks for comprehensive analysis
- Stakeholders: VP Marketing, Sales leadership, Product
```

### **Why Series B Research is Different:**

```
SERIES A: Quick battle cards for selling
SERIES B: Strategic intelligence for scaling

You need to answer:
- Should we move upmarket? (Mid-market → Enterprise)
- Which features to build? (Product roadmap input)
- Where to invest marketing $? (Channel strategy)
- How to price for growth? (Pricing strategy)
- Which segments to prioritize? (ICP refinement)
```

### **Series B Sales Tech Research: 2-Week Sprint**

**WEEK 1: Comprehensive Competitive Analysis**

```
DAY 1-2: Deep Competitive Profiling (8 hours)

Now you analyze 15-20 competitors (not just 5-10)

FOR EACH COMPETITOR:
□ Website messaging (positioning evolution)
□ Pricing (tiers, changes over time via Wayback Machine)
□ G2 reviews (read 50+, analyze themes)
□ Product Hunt launches (reception, comments)
□ Job postings (where are they investing?)
□ Leadership LinkedIn (what are execs talking about?)
□ Funding announcements (investors, use of funds)
□ Tech stack (BuiltWith: what tools do they use?)

TOOLS YOU CAN NOW AFFORD:
✅ LinkedIn Sales Navigator ($99/mo) - Org charts, decision makers
✅ Crunchbase Pro ($29/mo) - Funding, M&A, investors
✅ SimilarWeb Starter ($125/mo) - Traffic, digital strategy
✅ Ahrefs Lite ($99/mo) - SEO competitive analysis
Total: ~$350/month (justified by time savings)

DAY 3-4: Win/Loss Analysis (8 hours)

Interview 10-15 customers who chose you vs competitors

SALES TECH WIN/LOSS QUESTIONS:
- "Which other tools did you evaluate?"
- "What almost made you choose [Competitor]?"
- "What feature tipped the scales for us?"
- "How did pricing compare?"
- "How does our team size compare to [Competitor] customers?"

PATTERN RECOGNITION:
We win when: [Small teams, fast setup, coaching focus]
We lose when: [Need forecasting, enterprise security, API access]

Recommendation: Build [X features] to reduce losses

DAY 5: Synthesis + Strategic Implications (4 hours)

OUTPUT:
- Competitive positioning map (updated)
- Feature gap analysis (what to build)
- Pricing benchmarking (how to price new tiers)
- Market trends (where is sales tech moving?)
```

**WEEK 2: Market Expansion Analysis**

```
DAY 6-7: Upmarket Feasibility (8 hours)

RESEARCH QUESTION: Can we compete for mid-market deals (50-200 reps)?

COMPETITOR ANALYSIS:
□ What features do mid-market buyers need?
  - From G2: Enterprise reviews mentioning must-haves
  - Security: SOC 2, SSO, role-based access
  - Integrations: Salesforce, Outreach, Gong
  - Analytics: Forecasting, pipeline visibility

□ How do competitors serve mid-market?
  - Chorus: Acquired by ZoomInfo, bundled strategy
  - Revenue.io: Series B, $X-$Y deal sizes
  - Our positioning: Can we credibly compete?

GAP ANALYSIS:
Missing for mid-market:
❌ SOC 2 compliance (need 6 months)
❌ SSO (need 3 months)
❌ Advanced analytics (need 4 months)
✅ Salesforce integration (have it)
✅ Core conversation intel (have it)

DECISION: 
- Timeline: 12 months to be mid-market ready
- Investment: $X engineering cost
- ROI: Mid-market ACV $15K vs SMB $5K = 3× uplift
- Recommendation: Prioritize mid-market readiness

DAY 8-9: Geographic Expansion Research (8 hours)

RESEARCH QUESTION: India → US expansion feasibility

MARKET SIZING (US):
- LinkedIn Sales Navigator: 15,000 SMB B2B SaaS companies (10-100 employees)
- vs India: 2,000 companies
- 7.5× larger market

COMPETITIVE LANDSCAPE (US):
- Gong: Dominant in enterprise
- Smaller players: Revenue.io, Chorus (acquired)
- WHITE SPACE: SMB coaching focus (same as India)

CHALLENGES:
- Price expectations: US buyers pay 2-3× more
- Sales motion: Need US-based sales team
- Brand: Unknown in US (need marketing investment)
- Support: US time zones (need US support team)

VALIDATION:
- Interview 5 US sales leaders: "Would you buy from India company?"
- Competitor analysis: Wingman (India) struggling in US = cautionary tale

DAY 10: Final Synthesis (4 hours)

DELIVERABLE: Strategic Recommendations Deck
- Slide 1: Executive summary
- Slides 2-5: Competitive landscape evolution
- Slides 6-10: Upmarket opportunity + roadmap
- Slides 11-15: Geographic expansion analysis
- Slides 16-20: Product roadmap priorities
- Slides 21-25: Pricing strategy recommendations
```

### **Series B Sales Tech: Tool Stack & Budget**

```
MONTHLY TOOL BUDGET: $350-500

TIER 1 (MUST-HAVE):
□ LinkedIn Sales Navigator ($99/mo)
  → WHY: Win/loss research, ICP sizing, org charts
  → ROI: Saves 10+ hours/month on manual research

□ Crunchbase Pro ($29/mo)
  → WHY: Competitor funding, M&A signals, investor insights
  → ROI: Early warning on competitive moves

□ SimilarWeb Starter ($125/mo)
  → WHY: Traffic analysis, digital strategy benchmarking
  → ROI: Understand competitor GTM investment

TIER 2 (SHOULD-HAVE):
□ Ahrefs Lite ($99/mo)
  → WHY: SEO competitive analysis, content gap identification
  → ROI: Inform content strategy, find keyword opportunities

TIER 3 (NICE-TO-HAVE):
□ Hunter.io ($49/mo)
  → WHY: Find stakeholder emails for research interviews
  → ROI: Better win/loss research, customer interviews

CANNOT YET JUSTIFY:
❌ Gartner ($30K/year) - Too expensive for Series B
❌ Klue ($15K/year) - Maybe at Series C
❌ ZoomInfo ($15K/year) - Sales Nav sufficient for now
```

---

## **A3: Sales Tech @ Series C+ (Strategic Intelligence Team)**

### **Your Reality Check:**

```
COMPANY PROFILE:
- Size: $50M+ ARR, 500+ employees
- Stage: Series C/D or preparing for IPO
- Team: Market Intelligence team (2-3 FTE) + you (Director/VP)
- Budget: $50K-150K/year for research
- Timeline: Ongoing monitoring + quarterly deep dives
- Stakeholders: C-suite, Board, Investors
```

### **Why Series C+ Research is Different:**

```
SERIES A: Battle cards for sales
SERIES B: Strategic positioning for scaling
SERIES C+: Board-level intelligence + M&A due diligence

You need to answer:
- M&A targets: Who should we acquire?
- Competitive moats: How defensible are we?
- Market trends: Where is category moving (5-year view)?
- Strategic threats: Who could disrupt us?
- IPO readiness: How do we compare to public comps?
```

### **Enterprise Sales Tech Intelligence: Continuous + Quarterly**

**ONGOING: Continuous Monitoring**

```
DAILY MONITORING (Automated):
□ Klue alerts: Competitor website changes, job postings, news
□ Google Alerts: Competitor mentions in media
□ G2 reviews: New reviews for top 10 competitors
□ Funding announcements: Crunchbase + news sources
□ Social media: Competitor exec LinkedIn posts

WHO MONITORS: Intelligence Analyst (dedicated role)
OUTPUT: Weekly email update to sales + marketing leadership

WEEKLY SYNTHESIS:
□ Competitive win/loss trends (from CRM)
□ Product updates (from competitor release notes)
□ Marketing campaigns (from ad tracking)
□ Pricing changes (from public sites + customer reports)

OUTPUT: Friday competitive update (5-10 min read)
AUDIENCE: Sales team (battle card updates as needed)
```

**QUARTERLY: Strategic Deep Dives**

```
Q1: Competitive Landscape Assessment

DELIVERABLE: Board-level presentation

SECTION 1: Market Evolution (10 slides)
- TAM/SAM trends (growing, stable, shrinking?)
- New entrants (who raised funding? acquisitions?)
- Category consolidation (M&A activity)
- Technology shifts (AI, new modalities)

SECTION 2: Competitive Position (15 slides)
- Market share estimates (us vs top 5)
- Win/loss trends (improving or declining?)
- NPS comparison (us vs competitors via G2)
- Product feature parity matrix
- Pricing position (are we premium or value?)

SECTION 3: Strategic Recommendations (10 slides)
- Competitive threats to watch
- White space opportunities
- M&A target shortlist (if acquiring)
- Product roadmap priorities (based on competitive gaps)
- GTM strategy adjustments

DATA SOURCES:
✅ Gartner Magic Quadrant (if in category)
✅ Forrester Wave (if in category)
✅ Custom research (commission primary research)
✅ Win/loss analysis (200+ interviews/year)
✅ G2 Grid analysis (track quarterly movement)

Q2: Strategic M&A Analysis

RESEARCH QUESTION: Who should we acquire? Why?

ACQUISITION CRITERIA (Sales Tech Example):
□ Strategic fit: Expand platform (e.g., add sales engagement)
□ Geographic expansion: Acquire EMEA leader
□ Talent acquisition: AI/ML team
□ Customer acquisition: Buy competitor's customer base
□ Technology: Buy IP/patents

TARGET IDENTIFICATION:
1. Map ecosystem (100+ companies in sales tech)
2. Filter by stage (Series A-B, $5M-30M valuation)
3. Analyze fit (tech, customers, team, geography)
4. Shortlist top 10 targets
5. Deep due diligence on top 3

DUE DILIGENCE (per target):
□ Financial analysis (ARR, growth, burn)
□ Customer overlap (would we lose customers?)
□ Technology assessment (IP, code quality)
□ Team assessment (would leadership stay?)
□ Integration complexity (how hard to integrate?)

OUTPUT: M&A target deck with 3 recommended acquisitions

Q3: Analyst Relations + Thought Leadership

GOAL: Influence Gartner/Forrester positioning

ACTIVITIES:
□ Analyst briefings (2× quarterly per analyst)
□ Gartner Magic Quadrant preparation (if applicable)
□ Forrester Wave participation
□ Commissioned research (sponsor reports)
□ Industry conference sponsorships

RESEARCH OUTPUT:
□ "State of Sales Tech 2026" report
□ Benchmark data (share anonymized metrics)
□ Thought leadership content
□ Media coverage (Forbes, TechCrunch, etc.)

WHY THIS MATTERS:
- Gartner/Forrester inclusion = enterprise sales credibility
- Commissioned research = brand building
- Thought leadership = category ownership

Q4: IPO Readiness / Public Market Comparables

RESEARCH QUESTION: How do we compare to public companies?

PUBLIC COMPS (Sales Tech):
- Outreach (if public)
- ZoomInfo (public, owns Chorus)
- Salesforce (Sales Cloud comparable)

METRICS TO BENCHMARK:
□ ARR growth rate (us vs public comps)
□ Gross margin (us vs public comps)
□ Net revenue retention (us vs public comps)
□ Sales efficiency (CAC, LTV/CAC ratio)
□ Market cap / ARR multiple

OUTPUT:
- "Public company readiness" assessment
- Competitive positioning for investor roadshow
- Analyst day preparation materials
```

### **Series C+ Sales Tech: Premium Tool Stack**

```
ANNUAL RESEARCH BUDGET: $75K-150K

TIER 1 (ESSENTIAL):
□ Gartner ($35K-50K/year)
  → WHY: Analyst access, Magic Quadrant inclusion
  → ROI: Enterprise credibility, required for upmarket

□ Klue or Crayon ($18K-25K/year)
  → WHY: Competitive intelligence platform, automated monitoring
  → ROI: Saves 20+ hours/week for intelligence team

□ ZoomInfo ($20K-30K/year)
  → WHY: Contact data, org charts, buying signals
  → ROI: Sales enablement, account-based targeting

TIER 2 (STRONGLY RECOMMENDED):
□ SimilarWeb Enterprise ($25K-40K/year)
  → WHY: Competitive traffic benchmarking, market share estimates
  → ROI: Track competitive digital strategy

□ Custom Research ($20K-40K/year)
  → WHY: Primary research, commissioned reports
  → ROI: Proprietary insights, thought leadership

TIER 3 (CONSIDER):
□ Forrester ($30K/year)
  → WHY: Alternative to Gartner, Wave analysis
  → ROI: If Gartner doesn't cover your category well

□ CB Insights ($20K/year)
  → WHY: Market maps, M&A intelligence, emerging competitors
  → ROI: Strategic planning, M&A target identification

TOTAL: $75K-150K/year
```

---

# 📊 SECTION B: HR TECH COMPETITIVE INTELLIGENCE

**When To Use This Section:**
- Your product: HRIS, employee engagement, performance management, recruiting, learning
- Your competitors: Workday, BambooHR, Culture Amp, Lattice, Lever, Greenhouse
- Your buyers: HR leaders, CHROs, People Ops
- Your go-to-market: Typically sales-led (HR is relationship-driven)

---

## **B1: HR Tech @ Series A (Founder-Led Research)**

### **Your Reality Check:**

```
COMPANY PROFILE:
- Size: $2M-8M ARR, 20-80 employees
- Stage: Series A, early PMF
- You: Founder (often ex-HR tech or HRBP background)
- Budget: $0-300/month
- Timeline: 1 week for competitive positioning
```

### **The HR Tech Competitive Landscape (Different from Sales Tech):**

**Key Differences vs Sales Tech:**

```
SALES TECH:
- Buyers: Sales leaders (aggressive, data-driven, ROI-focused)
- Buying cycle: 1-3 months (fast)
- Decision: Individual or small team
- Risk tolerance: High (experiment with tools)

HR TECH:
- Buyers: HR leaders (relationship-driven, risk-averse, people-focused)
- Buying cycle: 3-9 months (slower, more deliberate)
- Decision: Committee (HR + Finance + Legal + IT)
- Risk tolerance: LOW (can't screw up people data)
```

**This Changes Everything About Competitive Research:**

```
FOR SALES TECH:
✅ Aggressive competitive positioning okay ("We're 10× cheaper than Gong")
✅ Fast iteration, experiment
✅ Attack incumbents publicly

FOR HR TECH:
❌ NEVER attack competitors (HR community is small, reputation matters)
❌ Conservative positioning only
❌ Professional tone mandatory (HR is risk-averse)
✅ Emphasize: Trust, security, compliance, relationships
```

### **Series A HR Tech Research: Conservative Approach**

**DAY 1-2: Competitive Landscape (But Make It Professional)**

```
09:00-12:00 | Map HR Tech Ecosystem

HR Tech has sub-categories (pick yours):
□ HRIS/Core HR: Workday, BambooHR, Rippling, Deel
□ Employee Engagement: Culture Amp, Lattice, 15Five
□ Performance Management: Lattice, Betterworks, 7Geese
□ Recruiting: Lever, Greenhouse, Ashby
□ Learning: Degreed, EdCast, Docebo
□ Comp & Benefits: Pave, Figures, Carta (equity)

INDIA-SPECIFIC HR TECH:
□ Darwinbox (India HRIS leader)
□ Keka (SMB HRIS)
□ EngageWith (employee engagement)
□ SumHR (payroll + HR)

RESEARCH SOURCES (HR-Specific):
□ SHRM (Society for HR Management) - not for competitive intel, but industry trends
□ HR Brew newsletter (industry news)
□ HR Tech Conference exhibitor list
□ G2 HR Software categories

12:00-13:00 | Pricing Research (HR Tech Nuance)

HR Tech pricing is DIFFERENT from Sales Tech:

SALES TECH: Per-seat, usage-based, transparent
HR TECH: Per-employee, bundled, often hidden

PRICING MODELS:
- BambooHR: $X/employee/month (SMB)
- Workday: Enterprise-only, no public pricing
- Culture Amp: $3-7/employee/month (from reviews)
- Lattice: $4-11/employee/month

YOUR POSITIONING:
"Affordable for SMBs" (if BambooHR is $6/employee, you're $3-4)
NOT: "10× cheaper" (too aggressive for HR)
```

**DAY 3-4: Feature Analysis (HR Compliance is Critical)**

```
HR TECH MUST-HAVES (Regulatory):

FOR INDIA MARKET:
✅ PF/ESI compliance (mandatory)
✅ Gratuity calculations
✅ Leave policy (Indian labor law)
✅ Payroll (statutory deductions)

FOR US MARKET:
✅ EEOC compliance (equal employment)
✅ ADA compliance (disability)
✅ FMLA tracking (family medical leave)
✅ 401K integration

FOR EU MARKET:
✅ GDPR compliance (data privacy)
✅ Works council integration
✅ Country-specific labor laws

COMPETITOR ANALYSIS (Compliance Focus):
□ Which markets does competitor support?
□ What compliance features do they have?
□ Do they have SOC 2, ISO 27001, GDPR certifications?
□ What do reviews say about compliance failures?

THIS IS DIFFERENT FROM SALES TECH:
Sales Tech: Compliance nice-to-have
HR Tech: Compliance MANDATORY (you lose deals without it)
```

**DAY 5: Positioning (Conservative, Professional)**

```
HR TECH POSITIONING RULES:

❌ DON'T SAY:
"We're crushing competitors"
"Workday sucks"
"10× better than X"

✅ DO SAY:
"Trusted by 500+ HR leaders"
"Built specifically for mid-market"
"Compliant, secure, easy to use"
"Recommended by SHRM members"

POSITIONING FRAMEWORK (HR Tech):
- Emphasize: Trust, security, compliance
- Tone: Professional, warm, supportive
- Avoid: Aggressive, sales-y, attacking

EXAMPLE POSITIONING:
"Culture Amp for Mid-Market Companies
 Affordable, compliant, built for HR leaders who care about their people."

Not: "Culture Amp is too expensive. We're cheaper."
```

### **HR Tech Specific: Conservative Battle Cards**

```
┌────────────────────────────────────────────┐
│ VS. CULTURE AMP (Category Leader)          │
├────────────────────────────────────────────┤
│ WHEN TO POSITION AGAINST THEM:             │
│ • Mid-market companies (200-1000 employees)│
│ • Budget-conscious HR teams               │
│ • Need engagement + performance           │
│                                            │
│ NEVER SAY:                                 │
│ ❌ "Culture Amp is too expensive"          │
│ ❌ "We're better than Culture Amp"         │
│ ❌ "Culture Amp has bad customer support"  │
│                                            │
│ INSTEAD SAY:                               │
│ ✅ "Culture Amp is excellent for enterprise│
│    We're purpose-built for mid-market."   │
│ ✅ "We focus on X (performance management) │
│    Culture Amp is broader (engagement)."  │
│ ✅ "Mid-market companies love our pricing  │
│    and hands-on support."                 │
│                                            │
│ RESPECTFUL DIFFERENTIATION:                │
│ • We: Mid-market focus ($200-1K employees) │
│ • Them: Enterprise focus (1K+ employees)   │
│ • We: Hands-on support included           │
│ • Them: Self-serve + paid support tiers   │
│ • We: $3-4/employee/month                 │
│ • Them: $5-8/employee/month               │
│                                            │
│ WHY RESPECT MATTERS IN HR TECH:            │
│ - HR community is small (everyone knows everyone)│
│ - Today's competitor could be tomorrow's  │
│   integration partner or acquisition target│
│ - HR buyers HATE vendor trash-talk         │
│ - Culture Amp might refer customers to you │
│   for mid-market deals they don't want    │
└────────────────────────────────────────────┘
```

---

## **B2: HR Tech @ Series B (Professional Research + Win/Loss)**

### **Your Reality Check:**

```
COMPANY PROFILE:
- Size: $12M-40M ARR, 200-600 employees
- Stage: Series B, moving upmarket or expanding modules
- You: Director of Product Marketing or PMM
- Budget: $2K-6K/month for research
- Goal: Should we move upmarket? Which features to build?
```

### **Series B HR Tech: Different Questions Than Sales Tech**

```
SALES TECH @ SERIES B:
"Can we compete with Gong for mid-market?"
"Should we expand to US?"

HR TECH @ SERIES B:
"Should we add performance management to engagement?"
"Can we serve 1,000+ employee companies?"
"Do we need GDPR compliance for EU expansion?"
"Should we build AI features or partner?"
```

### **Week 1-2: Comprehensive HR Tech Competitive Analysis**

```
RESEARCH FOCUS AREAS:

1. MODULE EXPANSION ANALYSIS (HR Tech Specific)

HR Tech companies expand via modules:
- Start: Single point solution (e.g., just engagement)
- Expand: Add adjacent modules (engagement → performance)
- Platform: Full suite (HRIS → engagement → performance → learning)

COMPETITOR EVOLUTION EXAMPLES:
- Lattice: Started performance → added engagement → added goals
- Culture Amp: Started engagement → added performance
- BambooHR: Started HRIS → added performance → added hiring

RESEARCH QUESTIONS:
□ Which competitors started where we started?
□ What modules did they add? In what order?
□ How long did expansion take?
□ What was customer reception? (from reviews)
□ Did they build or acquire modules?

2. UPMARKET READINESS ANALYSIS (HR Compliance Focus)

TO SERVE 1,000+ EMPLOYEE COMPANIES (Enterprise):

MUST-HAVE FEATURES:
□ SSO (Okta, Azure AD) - Security team requirement
□ SCIM (automated user provisioning)
□ SOC 2 Type II compliance (InfoSec requirement)
□ Custom reporting (HRIS integrations)
□ API access (IT team requirement)
□ Role-based access controls (complex org structures)

MUST-HAVE COMPLIANCE (US Enterprise):
□ EEOC reporting (equal employment opportunity)
□ ADA compliance (Americans with Disabilities Act)
□ OFCCP compliance (if government contractors)
□ State-specific labor laws (CA, NY, etc.)

MUST-HAVE COMPLIANCE (India Enterprise):
□ ISO 27001 certification
□ PF/ESI at scale (10,000+ employees)
□ Multi-state operations (different state labor laws)
□ Large enterprise payroll complexity

COMPETITOR RESEARCH:
□ When did Culture Amp add enterprise features?
□ What compliance did Lattice need for Fortune 500?
□ How long did upmarket move take?

TIMELINE ESTIMATE:
- SSO/SCIM: 3-4 months engineering
- SOC 2: 6-12 months (audit process)
- Enterprise features: 6-9 months
- TOTAL: 12-18 months to be enterprise-ready

3. WIN/LOSS ANALYSIS (HR Tech Nuances)

Interview 20 customers (10 won, 10 lost)

HR TECH WIN/LOSS QUESTIONS:
- "Which other vendors did you evaluate?"
- "What was your decision-making process?" (committee? timeframe?)
- "Who was involved in decision?" (HR + Finance + IT + Legal?)
- "What almost made you choose [Competitor]?"
- "How important was compliance/security?" (1-10 scale)
- "How important was hands-on support?" (1-10 scale)
- "What's your relationship with vendor?" (transactional or partnership?)

PATTERN RECOGNITION (HR Tech Specific):

WE WIN WHEN:
✅ Mid-market (200-800 employees)
✅ Budget-conscious ($3-5/employee budget)
✅ Want hands-on support (not self-serve)
✅ HR team is small (1-3 people)
✅ Need fast implementation (<6 weeks)

WE LOSE WHEN:
❌ Enterprise (1,000+ employees) - lack SSO, SCIM
❌ Global (need GDPR, EU compliance)
❌ Complex hierarchy (role-based access insufficient)
❌ IT-led buying (they want API-first, we're UI-first)
❌ Want "platform" (we're point solution)

STRATEGIC IMPLICATIONS:
- Build SSO/SCIM for enterprise (6-month roadmap)
- Add GDPR compliance for EU (9-month roadmap)
- Partner with HRIS vendors (can't build full platform)
- Double down on mid-market (200-800 employees)
- Emphasize customer success (differentiation)
```

### **Series B HR Tech: Tool Stack**

```
MONTHLY BUDGET: $300-600

TIER 1 (ESSENTIAL):
□ LinkedIn Sales Navigator ($99/mo)
  → WHY: HR leader org charts, decision maker identification
  → HR TECH SPECIFIC: Track CHRO moves, HR team expansions

□ Crunchbase Pro ($29/mo)
  → WHY: HR Tech funding landscape, M&A activity
  → HR TECH SPECIFIC: Watch consolidation (lots of M&A in HR Tech)

TIER 2 (SHOULD-HAVE):
□ G2 Track ($150/mo)
  → WHY: Monitor competitor reviews, track review sentiment
  → HR TECH SPECIFIC: HR buyers rely heavily on G2 (conservative buyers)

SKIP FOR NOW:
❌ SimilarWeb ($125/mo) - Less relevant for HR Tech (not PLG)
❌ Ahrefs ($99/mo) - HR Tech = sales-led, SEO less critical

TOTAL: $280-350/month (conservative for HR Tech)
```

---

## **B3: HR Tech @ Series C+ (Compliance & Strategic Intelligence)**

### **Your Reality Check:**

```
COMPANY PROFILE:
- Size: $50M+ ARR, 800+ employees
- Stage: Series C/D, preparing for IPO or acquisition
- Team: Competitive Intelligence (2 FTE) + Compliance (2 FTE)
- Budget: $100K-200K/year (compliance mandates higher spend)
- Stakeholders: Board, Legal, Compliance, C-suite
```

### **Why HR Tech Enterprise Research is Unique:**

```
SALES TECH ENTERPRISE RESEARCH:
Focus: Market position, M&A targets, feature parity

HR TECH ENTERPRISE RESEARCH:
Focus: Regulatory compliance, audit readiness, data security
  + all the Sales Tech stuff

ADDITIONAL COMPLEXITY:
- SOC 2 Type II mandatory (can't sell enterprise without it)
- GDPR if EU (€20M fines for violations)
- HIPAA if health benefits (healthcare data)
- ISO 27001 for global enterprise
- Legal review of ALL competitive claims
```

### **Quarterly Research Cadence (HR Tech Specific)**

**Q1: Compliance Competitive Benchmark**

```
RESEARCH QUESTION: How do we compare on compliance/security?

COMPETITOR COMPLIANCE AUDIT:
For top 10 competitors, research:
□ SOC 2 Type II: Do they have it? (check website)
□ ISO 27001: Certified? (check trust center)
□ GDPR: Do they serve EU? Compliant?
□ HIPAA: Do they handle health data?
□ State-specific: CA CCPA, NY SHIELD Act?

COMPLIANCE GAP ANALYSIS:
Workday: SOC 2, ISO 27001, GDPR, HIPAA ✅✅✅✅
BambooHR: SOC 2, GDPR ✅✅
Culture Amp: SOC 2, GDPR ✅✅
Us: SOC 2, GDPR ✅✅
Gap: Need ISO 27001 for global enterprise

INVESTMENT NEEDED:
- ISO 27001 certification: $50K-100K + 9-12 months
- HIPAA compliance: $30K-60K + 6 months
- Ongoing compliance: $200K/year (team + audits)

BOARD DELIVERABLE:
"Compliance Competitive Analysis & Investment Recommendation"
```

**Q2: M&A Target Analysis (HR Tech Module Strategy)**

```
HR TECH M&A IS DIFFERENT:

SALES TECH M&A:
- Acquire competitors for market share
- Acquire complementary tech (e.g., Gong buying Forecast)

HR TECH M&A:
- Acquire modules to become platform
- Example: UKG acquired Ultimate + Kronos
- Example: iCIMS acquired TextRecruit, Jobvite

ACQUISITION THESIS:
We're strong in: Employee Engagement
Missing modules: Performance Management, Learning, Recruiting

TARGET IDENTIFICATION:
□ Performance Management startups (Series A-B)
  - Small Improvements
  - Reflektive (acquired by Lumin)
  - 7Geese (acquired by Paycor)

□ Learning platforms (Series A-B)
  - EdApp
  - TalentLMS
  - [Smaller players]

DUE DILIGENCE (HR Tech Specific):
□ Customer overlap: Would acquisition cause churn?
□ Data portability: Can we migrate customer data?
□ Compliance transfer: Do their certifications transfer?
□ HR community perception: Would acquisition be well-received?

VALUATION BENCHMARKS:
- HR Tech M&A multiples: 8-15× ARR (higher than Sales Tech)
- Why: Sticky (hard to switch), compliance moats, relationship-driven
```

**Q3: Analyst Relations & Industry Positioning**

```
HR TECH ANALYSTS (Different from Sales Tech):

PRIMARY ANALYSTS:
□ Gartner (HCM Magic Quadrant)
□ Forrester (Employee Experience Wave)
□ Nucleus Research (ROI-focused)
□ Bersin/Josh Bersin (HR thought leader, not traditional analyst)

ANALYST RELATIONS STRATEGY:
- Quarterly briefings (share roadmap, customer wins)
- Annual Gartner MQ participation (if eligible)
- Sponsor research: "State of Employee Engagement 2026"
- Speaking: HR Tech Conference, Josh Bersin events

CERTIFICATION REQUIREMENTS (HR Tech):
- SHRM Preferred Provider (HR credibility)
- Brandon Hall Excellence Awards (industry recognition)
- Great Place to Work Certified (practice what you preach)

WHY THIS MATTERS IN HR TECH:
HR buyers trust:
1. Peer recommendations (other CHROs)
2. Analyst reports (Gartner, Forrester)
3. Industry associations (SHRM)
4. Awards/recognition

Sales Tech buyers trust:
1. Product trials (test it yourself)
2. Peer reviews (G2)
3. ROI data (does it work?)
```

**Q4: IPO Readiness / Market Positioning**

```
PUBLIC HR TECH COMPARABLES:

PUBLIC COMPANIES:
- Workday (HCM platform, $60B+ market cap)
- UKG (private equity, not pure public comp)
- Paycom, Paylocity (payroll + HR)
- ADP (payroll giant, legacy)

RECENT IPOs:
- [Research recent HR Tech IPOs]

BENCHMARKING METRICS:
□ ARR growth (us vs public comps)
□ Net revenue retention (target: >110%)
□ Gross margin (target: >75% for SaaS)
□ Operating margin (path to profitability)
□ Customer retention (critical in HR Tech)

HR TECH SPECIFIC METRICS:
□ Employees under management (how many employees use your platform)
□ Customer company size (SMB vs Enterprise mix)
□ Module adoption (single vs multi-module customers)
□ CSAT/NPS (relationship-driven, loyalty matters)

INVESTOR NARRATIVE:
"Employee Engagement Platform for Mid-Market
 Trusted by 800 companies, 250,000 employees
 Net retention 118%, Rule of 40 compliant
 Path to profitability in 18 months"
```

### **HR Tech Series C+ Tool Stack**

```
ANNUAL BUDGET: $120K-180K

MUST-HAVE:
□ Gartner ($40K-60K/year)
  → REQUIRED for HR Tech (buyers check Gartner)
  
□ Compliance tools ($30K-50K/year)
  → Vanta (SOC 2 automation)
  → Drata (compliance monitoring)
  → OneTrust (privacy management)

□ Klue or Crayon ($20K-30K/year)
  → Competitive monitoring
  
□ Custom Research ($30K-50K/year)
  → Commission "State of HR Tech" reports
  → SHRM partnership research

INDUSTRY-SPECIFIC:
□ SHRM Membership + Conference ($5K-10K/year)
  → HR community intelligence, networking

□ Josh Bersin Academy ($15K/year)
  → HR thought leadership, industry insights

TOTAL: $140K-200K/year
```

---

# 📊 SECTION C: FINTECH COMPETITIVE INTELLIGENCE

**When To Use This Section:**
- Your product: Payments, expense management, corporate cards, payroll, neo-banking
- Your competitors: Razorpay, Paytm, PhonePe (India), Stripe, Brex, Ramp (US)
- Your buyers: CFOs, Finance leaders, Controllers
- Your go-to-market: Sales-led (finance is risk-averse)
- **CRITICAL**: Highly regulated industry, compliance-first

---

## **C1: Fintech @ Series A (Conservative, Compliance-First)**

### **Your Reality Check:**

```
COMPANY PROFILE:
- Size: $2M-8M ARR, 20-100 employees
- Stage: Series A
- You: Founder (often ex-finance/banking background)
- Budget: $0-500/month (compliance eats budget)
- Regulatory: RBI licensed or applying for license (India)
```

### **FINTECH IS FUNDAMENTALLY DIFFERENT**

**Critical Differences from Sales Tech / HR Tech:**

```
SALES TECH:
✅ Can be aggressive
✅ Fast experimentation
✅ Attack competitors
✅ Share metrics openly
Risk: Low (worst case: lose customers)

HR TECH:
⚠️ Must be professional
⚠️ Cannot attack competitors
⚠️ Relationship-driven
Risk: Medium (people data sensitive)

FINTECH:
🔴 MUST be conservative
🔴 NEVER attack competitors (could trigger regulatory review)
🔴 CANNOT share metrics without legal approval
🔴 CANNOT make unverified claims (financial advertising rules)
Risk: EXTREME (regulatory fines, license revocation, criminal liability)
```

### **Fintech Regulatory Landscape (India)**

**Before ANY Competitive Research, Understand:**

```
INDIA FINTECH REGULATIONS:

RBI (Reserve Bank of India):
□ Payment Aggregator License (if processing payments)
□ NBFC License (if lending)
□ Prepaid Payment Instrument (PPI) License (wallets)
□ Account Aggregator License (financial data)

Compliance Requirements:
□ KYC (Know Your Customer) - mandatory
□ AML (Anti-Money Laundering) - mandatory
□ Data Localization (store data in India)
□ RBI reporting (monthly/quarterly)

CONSEQUENCES OF NON-COMPLIANCE:
- License suspension or revocation
- ₹1 crore+ fines
- Criminal charges (directors liable)
- Cannot process transactions (business shutdown)

THIS CHANGES COMPETITIVE RESEARCH:
- Cannot share user transaction data
- Cannot make unverified ROI claims
- Cannot criticize competitors publicly
- Legal review MANDATORY for all competitive claims
```

### **Series A Fintech Research: Ultra-Conservative**

**Week 1: Competitive Landscape (Regulatory Lens)**

```
DAY 1-2: License & Compliance Mapping

FOR EACH COMPETITOR:
□ What licenses do they have? (check RBI website)
□ Are they compliant? (any RBI actions against them?)
□ How long did licensing take? (timeline for us)
□ What compliance do they highlight? (trust signals)

INDIA FINTECH COMPETITORS:

EXPENSE MANAGEMENT:
- Happay (CRED acquired, ₹180M exit)
- Zoho Expense (Zoho suite)
- Fyle (Series B, expense automation)

CORPORATE CARDS:
- EnKash (RBI-licensed)
- Volopay (Singapore-based, India operations)
- Pazcare (expense + benefits)

PAYMENT PROCESSING:
- Razorpay (unicorn, payment gateway)
- Cashfree (payment aggregator)
- PayU (Naspers-owned)

COMPLIANCE COMPETITIVE INTEL:
Company | RBI License | SOC 2 | ISO 27001 | PCI DSS | Data Localization
Razorpay | ✅ PA | ✅ | ✅ | ✅ | ✅
Happay | ✅ | ✅ | ✅ | ✅ | ✅
[Us] | ⏳ Applying | ❌ | ❌ | ⏳ | ✅

GAP: Need SOC 2, ISO 27001 before enterprise sales
Timeline: 12-18 months for full compliance stack

DAY 3-4: Conservative Pricing Research

FINTECH PRICING CHALLENGES:
- Often bundled (hard to compare)
- Enterprise pricing hidden
- Regulatory fees not disclosed
- Transaction-based + subscription hybrid

RESEARCH SOURCES (Fintech-Safe):
□ Public websites (pricing pages if available)
□ G2 reviews mentioning price (user-reported, safe to cite)
□ Press releases (funding announcements mention ACV)
□ Your own customer interviews (first-party data, compliant)

WHAT YOU CANNOT DO:
❌ Scrape competitor pricing from private dashboards
❌ Pose as customer to get pricing (fraud)
❌ Use competitor's confidential data

PRICING BENCHMARKS (India Expense Management):
- Happay: ₹150-300/employee/month (from reviews)
- Zoho: ₹100-200/employee/month
- Fyle: ₹200-400/employee/month

YOUR POSITIONING:
"Compliant expense management for Indian SMBs
 ₹150-250/employee/month"

NOT: "50% cheaper than Happay" (unless verified and legal-approved)

DAY 5: Positioning (Risk-Averse, Compliance-First)

FINTECH POSITIONING PRINCIPLES:

✅ DO EMPHASIZE:
- "RBI-compliant" (if licensed)
- "Bank-grade security"
- "SOC 2 certified" (if have it)
- "Trusted by [X] companies"
- "Backed by [reputable investors]"

❌ NEVER SAY:
- "Better than [Competitor]"
- "Competitor X has security issues"
- "Fastest-growing fintech" (unless verified by 3rd party)
- "Save [X]%" (unless calculated, disclosed methodology)

EXAMPLE POSITIONING:
"RBI-Compliant Expense Management for Indian SMBs
 Bank-grade security, SOC 2 certified, trusted by 500+ companies"

CONSERVATIVE BATTLE CARD:

┌─────────────────────────────────────────────┐
│ VS. HAPPAY (CRED-Acquired Incumbent)        │
├─────────────────────────────────────────────┤
│ WHEN THEY COME UP:                          │
│ • Enterprise deals (their strength)         │
│ • CRED ecosystem (card + expense bundled)   │
│                                             │
│ RESPECTFUL POSITIONING:                     │
│ ✅ "Happay is excellent for enterprise      │
│     We focus on SMB (50-500 employees)"     │
│ ✅ "Both of us are RBI-compliant            │
│     We offer more flexible pricing for SMB" │
│ ✅ "Great product with strong backing       │
│     We provide hands-on support for growing │
│     finance teams"                          │
│                                             │
│ NEVER SAY (Legal Risk):                     │
│ ❌ "Happay is too expensive"                 │
│ ❌ "Happay has compliance issues"            │
│ ❌ "We're more secure than Happay"           │
│ ❌ "Customers switch from Happay to us"      │
│    (unless you have written testimonials)   │
│                                             │
│ WHY EXTREME CAUTION:                        │
│ - Fintech community is tiny in India       │
│ - CRED is well-connected (Kunal Shah)      │
│ - Negative positioning could trigger legal  │
│ - RBI scrutiny if public mudslinging       │
│ - Potential partnership/acquisition target  │
└─────────────────────────────────────────────┘
```

### **Fintech Series A: Compliance-First Tool Stack**

```
MONTHLY BUDGET: $0-300 (Compliance Budget is Separate)

RESEARCH TOOLS:
□ Google Search (free)
□ LinkedIn (free)
□ RBI website (free, license verification)
□ G2 Fintech categories (free tier)

COMPLIANCE TOOLS (Separate Budget):
□ Vanta or Drata ($3K-5K/month) - SOC 2 automation
□ Legal counsel ($5K-10K/month retainer) - Regulatory
□ Compliance officer (hire, $50K-80K/year)

NOTE: Fintech compliance costs >> research costs
Early-stage fintech spends more on compliance than marketing
```

---

## **C2: Fintech @ Series B (Strategic Compliance + Expansion)**

### **Your Reality Check:**

```
COMPANY PROFILE:
- Size: $15M-40M ARR, 200-500 employees
- Stage: Series B, expanding product lines or geography
- You: Product Marketing Manager or Strategy Lead
- Budget: $3K-8K/month for research
- Compliance: Fully licensed, SOC 2, considering ISO 27001
```

### **Series B Fintech Research Questions:**

```
TYPICAL SERIES B QUESTIONS:

SALES TECH @ SERIES B:
"Should we move upmarket?"
"Should we expand to US?"

HR TECH @ SERIES B:
"Should we add performance module?"
"Can we serve enterprise?"

FINTECH @ SERIES B:
"Should we apply for lending license?" (NBFC)
"Can we expand to UAE/Singapore?" (different regulators)
"Should we launch corporate cards?" (new product = new compliance)
"Can we partner with banks?" (co-branding, regulatory implications)
```

### **Week 1-2: Regulatory Expansion Analysis**

```
RESEARCH FOCUS: New Product Line = New Regulations

SCENARIO: We do expense management, want to add corporate cards

COMPLIANCE RESEARCH:
□ What additional licenses needed? (RBI: PPI license)
□ What do competitors have? (Check EnKash, Volopay licenses)
□ Timeline to get license? (12-18 months for PPI)
□ Compliance costs? (₹50L-1Cr for license + ongoing)
□ Risk? (if license denied, wasted investment)

COMPETITOR LICENSE MAPPING:

Company | Expense Mgmt | Corporate Cards | Lending | Payroll
Happay | ✅ | ✅ (via CRED) | ❌ | ❌
EnKash | ✅ | ✅ RBI PPI | ❌ | ❌
Volopay | ✅ | ✅ Singapore | ❌ | ❌
[Us] | ✅ | ⏳ Want | ❌ | ❌

STRATEGIC ANALYSIS:
Option 1: Build in-house (12-18 months, ₹1-2Cr investment)
Option 2: Partner with licensed issuer (faster, lower risk)
Option 3: Acquire competitor with license (expensive, fast)

RECOMMENDATION: Partner while applying for license (hybrid approach)
```

### **Geographic Expansion: India → UAE/Singapore**

```
RESEARCH QUESTION: Should we expand beyond India?

REGULATORY COMPARISON:

INDIA (RBI):
- License types: PA, PPI, NBFC, AA
- Timeline: 12-24 months per license
- Difficulty: High (stringent requirements)
- Data: Must be localized in India
- Language: English + local languages

UAE (DFSA, ADGM):
- License: Payment Services License
- Timeline: 6-12 months
- Difficulty: Medium (easier than India)
- Data: Can be in UAE or secure cloud
- Language: English + Arabic

SINGAPORE (MAS):
- License: Payment Services License
- Timeline: 6-9 months
- Difficulty: Medium-Low (clear process)
- Data: Can be anywhere (cloud-friendly)
- Language: English

COMPETITOR EXPANSION PATTERNS:

Razorpay:
- India (2014) → Malaysia (2019) → Not very successful outside India

Cashfree:
- India-focused, minimal international

Volopay:
- Singapore-first → India expansion
- Dual regulatory compliance

MARKET SIZING (UAE Corporate Spend):

Bottom-up:
- SMBs in UAE: ~50,000 companies
- Corporate card TAM: $200-300M
vs India: $1.5-2B (5-7× larger)

RECOMMENDATION:
India market still underpenetrated
Focus on India until $50M ARR, then expand
Exception: If UAE investor insists or strategic partnership
```

---

## **C3: Fintech @ Series C+ (Regulatory Affairs + Strategic Intelligence)**

### **Your Reality Check:**

```
COMPANY PROFILE:
- Size: $60M+ ARR, 600+ employees
- Stage: Series C/D, IPO-track
- Team: Regulatory Affairs (5+ FTE), Strategy (3+ FTE)
- Budget: $150K-300K/year (heavy compliance)
- Stakeholders: Board, RBI, Investors, Legal
```

### **Series C+ Fintech: Regulatory-First Intelligence**

```
QUARTERLY CADENCE:

Q1: Regulatory Landscape Monitoring
- RBI policy changes (monthly review)
- Competitor license applications (public RBI data)
- Global fintech regulations (learnings from US, EU, Singapore)
- Compliance incidents (any RBI actions against competitors?)

Q2: M&A / Partnership Analysis
- Acquisition targets (licensed competitors)
- Bank partnerships (co-branding opportunities)
- Strategic investors (financial institutions)

Q3: IPO Readiness / Public Market Comparables
- Public fintech benchmarking (Paytm, PolicyBazaar)
- Compliance audit (pre-IPO regulatory review)
- Investor narrative (growth + compliance story)

Q4: Strategic Planning / Board Reporting
- Market position vs competitors
- Regulatory moat analysis
- 5-year strategic roadmap
```

### **Fintech M&A: License Arbitrage**

```
FINTECH M&A STRATEGY:

ACQUISITION THESIS:
"Buy licenses, not just customers"

EXAMPLE:
- Target: Small expense management company
- Value: Not their $2M ARR
- Value: Their RBI Payment Aggregator license (saved us 18 months)

TARGET CRITERIA:
□ RBI-licensed (PA, PPI, NBFC, or AA)
□ Compliant (no regulatory actions)
□ Reasonable valuation (5-10× ARR)
□ Customer base transferable
□ Technology integrable

DUE DILIGENCE (Fintech-Specific):
□ License transfer feasibility (RBI approval required)
□ Compliance history (any RBI warnings?)
□ Data security audit (SOC 2, ISO 27001)
□ Customer data migration (regulatory compliant?)
□ Integration complexity (core banking system compatibility)

RECENT INDIA FINTECH M&A:
- CRED acquired Happay ($180M) - strategic fit
- Pine Labs acquiring Qfix - licensing play
- BillDesk acquired by PayU (not completed - regulatory)
```

### **Fintech Series C+ Tool Stack**

```
ANNUAL BUDGET: $180K-300K

REGULATORY INTELLIGENCE:
□ Legal counsel retainer ($150K-250K/year)
  → Regulatory monitoring, compliance advice
  
□ Compliance platform ($40K-60K/year)
  → Vanta, Drata, OneTrust
  
□ Industry associations ($10K-20K/year)
  → IAMAI (Internet and Mobile Association of India)
  → NPCI participation

COMPETITIVE INTELLIGENCE:
□ Crunchbase Pro ($29/mo × 12 = $348/year)
□ LinkedIn Sales Navigator ($99/mo × 12 = $1,188/year)
□ Custom research ($30K-50K/year)
  → Commission "State of Indian Fintech" reports

TOTAL: $230K-340K/year
(Note: Fintech invests more in compliance than competitive intel)
```

---

# 📊 SECTION D: OPERATIONS TECH COMPETITIVE INTELLIGENCE

**When To Use This Section:**
- Your product: Retail execution, logistics, field force automation, route optimization
- Your competitors: FieldAssist, Bizom, Ivy Mobility (India), Repsly (US)
- Your buyers: Sales leaders, Operations leaders at CPG/FMCG companies
- Your go-to-market: Enterprise sales (long cycles, pilots)
- **B2B2C Complexity**: You serve businesses who serve consumers

---

## **D1: Operations Tech @ Series A (India Retail Focus)**

### **Your Reality Check:**

```
COMPANY PROFILE:
- Size: $1M-5M ARR, 15-60 employees
- Stage: Series A
- You: Founder (ex-CPG/FMCG or SaaS)
- Market: India retail/distribution (Kirana stores, distributors)
- Budget: $0-300/month
```

### **Operations Tech is DIFFERENT from Sales/HR/Fintech:**

```
SALES TECH:
- Buyer: Sales leader at B2B SaaS company
- User: SDRs, AEs at SaaS company
- Use case: Internal sales productivity

HR TECH:
- Buyer: CHRO at any company
- User: HR team + all employees
- Use case: Internal employee management

FINTECH:
- Buyer: CFO at any company
- User: Finance team + employees
- Use case: Internal financial operations

OPERATIONS TECH (Retail Execution):
- Buyer: Sales/Ops leader at CPG/FMCG company
- User: Field sales reps visiting retail stores
- Use case: Manage distributor → retailer → consumer flow
- COMPLEXITY: B2B2B2C (You → CPG → Distributor → Retailer → Consumer)
```

### **India Retail Landscape (Critical Context):**

```
MARKET STRUCTURE:

Modern Trade (Organized Retail):
- Big Bazaar, Reliance Retail, DMart, Walmart-owned stores
- ~10% of market
- Sophisticated (already use some tech)

General Trade (Traditional Retail):
- Kirana stores (12M+ stores in India)
- ~90% of market  
- Unsophisticated (paper-based, WhatsApp)

Distribution Network:
- CPG companies (HUL, ITC, Nestle, Dabur)
  ↓
- Distributors (C&F agents, stockists)
  ↓  
- Retailers (kirana stores)
  ↓
- Consumers

YOUR PRODUCT SERVES:
CPG field teams visiting distributors and retailers
Goal: Ensure product availability, pricing, promotions, merchandising
```

### **Series A Operations Tech Research: 5-Day Sprint**

**DAY 1-2: Competitive Landscape (India-Specific)**

```
INDIA OPERATIONS TECH COMPETITORS:

RETAIL EXECUTION:
- FieldAssist (market leader, Series B)
- Bizom (Accel-backed, strong in South India)
- Ivy Mobility (Tiger Global-backed)
- Mobile Force (niche player)

LOGISTICS/DISTRIBUTION:
- Locus (route optimization)
- LogiNext (delivery management)
- FarEye (logistics visibility)

ADJACENT (Distributors):
- Khatabook, OkCredit (distributor accounting)
- Udaan (B2B marketplace for retailers)

COMPETITIVE MAPPING:

Company | Focus | Geography | Stage | Customers
FieldAssist | Retail execution | Pan-India | Series B | HUL, ITC, Dabur
Bizom | Retail execution | South India | Series B | Nestle, Coca-Cola
Ivy | Retail execution | Pan-India | Series B | Britannia, Godrej
[Us] | [Your focus] | [Region] | Series A | [Your customers]

DAY 3: Customer Type Analysis (Critical for Operations Tech)

OPERATIONS TECH BUYERS (Complex):

TIER 1: MNC CPG (Unilever, P&G, Nestle)
- Deal size: ₹50L-2Cr annually
- Sales cycle: 9-18 months (pilots + procurement)
- Decision: Centralized (global/India HQ)
- Tech sophistication: High (RFP process, integrations)
- Reference customers: Required (won't be first)

TIER 2: Large Indian CPG (Dabur, Emami, Parle)
- Deal size: ₹20L-80L annually  
- Sales cycle: 6-12 months (pilots)
- Decision: India leadership
- Tech sophistication: Medium
- Price sensitivity: Higher than MNC

TIER 3: Mid-Market CPG (Regional brands)
- Deal size: ₹5L-20L annually
- Sales cycle: 3-6 months
- Decision: Founder/promoter
- Tech sophistication: Low
- Price sensitivity: Very high

YOUR POSITIONING (Series A):
Focus on Tier 2-3 (Indian CPG, regional brands)
Tier 1 requires references you don't have yet
Build case studies, then move upmarket to Tier 1

DAY 4-5: Feature Analysis (Ops Tech Specific)

RETAIL EXECUTION CORE FEATURES:

MUST-HAVE (Table Stakes):
□ Offline-first (field reps in no-network areas)
□ Attendance/GPS tracking (proof of visit)
□ Store audit (planogram compliance, stock check)
□ Order capture (retailers order via rep's app)
□ Image recognition (AI to verify shelf placement)
□ Beat planning (route optimization)
□ Multi-language (Hindi, regional languages)

DIFFERENTIATORS:
□ Distributor app (not just field team app)
□ Retailer app (direct ordering)
□ Analytics dashboard (for CPG management)
□ WhatsApp integration (retailers use WhatsApp)
□ UPI payments (collect payments in field)

COMPETITOR FEATURE COMPARISON:

Feature | FieldAssist | Bizom | Ivy | [Us]
Offline app | ✅ | ✅ | ✅ | ✅
Image AI | ✅ | ✅ | ⚠️ | ✅
Distributor app | ✅ | ⚠️ | ❌ | ✅ (our edge!)
WhatsApp | ⚠️ | ❌ | ❌ | ✅ (our edge!)
Multi-language | ✅ | ✅ | ✅ | ✅

POSITIONING:
"FieldAssist for mid-market CPG
 With distributor app + WhatsApp integration
 At 50% of the price"
```

### **Operations Tech Positioning (India Context):**

```
POSITIONING CONSIDERATIONS:

GEOGRAPHY MATTERS:
- North India: Different retail patterns than South
- South India: More organized, English-comfortable
- East India: Traditional retail dominant
- West India: Mix of modern + traditional

LANGUAGE MATTERS:
- Field reps: Hindi + regional language required
- Retailers: Regional language + broken Hindi/English
- Management: English dashboards

PRICE MATTERS:
- MNC CPG: Will pay global prices (₹50L-2Cr)
- Indian CPG: Price-sensitive (₹10L-30L)
- ROI-driven: "If we increase distribution by 5%, savings = ₹X"

MOBILE-FIRST REALITY:
- Field reps have smartphones (Xiaomi, Samsung)
- 4G coverage patchy (need offline-first)
- WhatsApp is primary communication tool
```

---

## **D2: Operations Tech @ Series B (Pan-India Expansion)**

### **Your Reality Check:**

```
COMPANY PROFILE:
- Size: $5M-15M ARR, 80-300 employees
- Stage: Series B
- You: VP Product Marketing or Strategy
- Customers: 20-40 CPG companies (mostly Tier 2-3)
- Geography: Strong in 1-2 regions, expanding pan-India
- Goal: Win Tier 1 customers (HUL, ITC, Nestle)
```

### **Series B Operations Tech: Moving Upmarket**

**RESEARCH QUESTION: How to win Tier 1 CPG customers?**

```
COMPETITIVE ANALYSIS: What does Tier 1 need?

FIELDASSIST WINS TIER 1 BECAUSE:
□ Track record (5+ years, 100+ customers)
□ References (other Tier 1 customers)
□ Scale (handles 50,000+ field reps)
□ Integrations (SAP, Oracle, Salesforce)
□ Security (SOC 2, ISO 27001, data centers in India)
□ Support (dedicated account team, 24×7)
□ Customization (enterprise workflows)

OUR GAPS:
❌ No Tier 1 references (chicken-egg problem)
❌ Not battle-tested at scale (max 5,000 reps)
❌ Limited integrations (no SAP connector yet)
❌ No SOC 2 (need 12 months)
❌ Small support team (can't dedicate account team)

PATH TO TIER 1:

STEP 1: Win Regional Tier 1 (6-12 months)
- Target: Large regional brand (e.g., MTR Foods, Haldiram)
- Size: 2,000-5,000 field reps (test our scale)
- Benefit: Build scale story, get enterprise reference

STEP 2: Get SOC 2 + ISO 27001 (12 months parallel)
- Investment: ₹40L-60L
- Benefit: Meet enterprise security requirements

STEP 3: Build SAP Connector (6 months)
- Why: Tier 1 CPG uses SAP for distribution
- Investment: 2 engineers × 6 months
- Benefit: Integration with Tier 1 systems

STEP 4: Pilot with Tier 1 (12-18 months)
- Approach: Regional pilot first (one state)
- If successful: Pan-India rollout
- Timeline: Total 24-36 months from Series B to Tier 1 win
```

---

## **D3: Operations Tech @ Series C+ (Category Leadership)**

### **Your Reality Check:**

```
COMPANY PROFILE:
- Size: $20M+ ARR, 300+ employees
- Stage: Series C/D
- Team: Strategy (3 FTE), Product Marketing (5 FTE)
- Customers: 60-100 CPG companies including Tier 1 logos
- Goal: Category leadership, potential IPO/acquisition
```

### **Strategic Intelligence: India Retail Tech**

```
QUARTERLY RESEARCH:

Q1: Retail Tech M&A Landscape
- Potential acquirers: Salesforce, Oracle, SAP, Accel portfolio consolidation
- Acquisition targets: Adjacent tech (distributor management, route optimization)

Q2: Retail Digitization Trends
- Kirana digitization pace (Reliance JioMart impact)
- Quick commerce impact on distribution (Swiggy Instamart, Blinkit)
- D2C brands (bypassing traditional distribution)

Q3: Competitive Consolidation
- Watch: FieldAssist, Bizom, Ivy potential mergers
- Opportunity: Acquire smaller regional players

Q4: IPO Readiness
- Public comps: Limited (Indian SaaS IPOs rare)
- Path: Private equity or acquisition more likely than IPO
```

---

# 🔄 CROSS-CUTTING: UNIVERSAL FRAMEWORKS

## **Master Decision Tree: Finding Your Research Path**

```
START: What industry vertical?

├─ SALES TECH
│  ├─ Series A ($1M-10M ARR)
│  │  ├─ India market → Section A1 (3-day sprint, free tools)
│  │  └─ US market → Section A1 (adapt competitor set)
│  ├─ Series B ($10M-50M ARR)
│  │  ├─ Moving upmarket? → Section A2 (upmarket research)
│  │  ├─ Geographic expansion? → Section A2 (expansion analysis)
│  │  └─ Competitive positioning? → Section A2 (win/loss)
│  └─ Series C+ ($50M+ ARR)
│     ├─ M&A targets? → Section A3 (M&A analysis)
│     ├─ IPO prep? → Section A3 (public comps)
│     └─ Board reporting? → Section A3 (quarterly intelligence)
│
├─ HR TECH
│  ├─ Series A → Section B1 (conservative positioning, compliance-first)
│  ├─ Series B → Section B2 (module expansion, upmarket)
│  └─ Series C+ → Section B3 (compliance benchmark, analyst relations)
│
├─ FINTECH
│  ├─ Series A → Section C1 (regulatory landscape, ultra-conservative)
│  ├─ Series B → Section C2 (new products = new licenses, geographic expansion)
│  └─ Series C+ → Section C3 (M&A for licenses, IPO readiness)
│
└─ OPERATIONS TECH
   ├─ Series A → Section D1 (India retail focus, distributor dynamics)
   ├─ Series B → Section D2 (Tier 1 enterprise, pan-India)
   └─ Series C+ → Section D3 (category leadership, M&A)
```

---

## **Geography-Specific Research Playbooks**

### **India Market Research**

**Unique Characteristics:**

```
PRICE SENSITIVITY:
- US SaaS price × 0.3-0.5 = India acceptable price
- Example: Gong $20K/year (US) vs Wingman $8K/year (India)
- Reason: Lower ARPUs, PPP differences, budget constraints

DECISION MAKING:
- Founder-led at SMB (faster decisions, 1-3 months)
- Cost-conscious at all stages
- References matter MORE (tight-knit community)

COMPETITION:
- Local players (Darwinbox, FieldAssist, Razorpay)
- Global players entering India (Gong, Lattice, Stripe)
- Price advantage = key differentiator for local players

DATA SOURCES (India-Specific):
□ Inc42 (Indian startup news)
□ Economic Times Tech (industry coverage)
□ SaaSBoomi community (B2B SaaS founders)
□ Yourstory (startup ecosystem)
□ TracxN (Indian company database)
□ VCCEdge (VC funding data)

MARKET SIZING (India):
- LinkedIn Sales Navigator (India filter)
- Crunchbase (India + B2B SaaS)
- Government data: MCA filings (ROC)
- Industry reports: NASSCOM, RedSeer

LANGUAGE CONSIDERATIONS:
- Sales/marketing: English
- Product: English + Hindi (minimum)
- Support: Hindi + regional languages (Tamil, Telugu, Bengali)
```

### **US Market Research**

**Unique Characteristics:**

```
PRICE TOLERANCE:
- 2-3× higher than India
- Willing to pay for premium if ROI clear
- Example: Gong $20K-50K annual, accepted

DECISION MAKING:
- Slower, committee-driven (3-9 months)
- ROI-driven (need calculators, case studies)
- Due diligence intensive (security, references)

COMPETITION:
- Crowded (100+ competitors in each category)
- Well-funded (VCs: Sequoia, a16z, etc.)
- Category leaders dominant (Gong, Lattice, Stripe)

DATA SOURCES (US-Specific):
□ Crunchbase (US venture funding)
□ G2 (US buyers dominate reviews)
□ TechCrunch (US tech news)
□ SaaStr (B2B SaaS community)
□ Product Hunt (US launches)

MARKET SIZING (US):
- LinkedIn Sales Navigator (US filters)
- Census data (company counts)
- Industry associations (SIA for HR Tech, etc.)
- Analyst reports (Gartner, Forrester)

COMPLIANCE:
- SOC 2 Type II (required for enterprise)
- GDPR if serving EU customers
- State-specific: CCPA (California), SHIELD Act (NY)
```

---

## **Worked Examples: Multi-Dimensional Scenarios**

### **Example 1: Sales Tech Founder, Series A, India → US Expansion**

```
SCENARIO:
- Company: AI sales coaching, $3M ARR, 35 employees
- Stage: Series A (just raised $5M)
- Current: 50 customers in India (SMB B2B SaaS)
- Question: "Should we expand to US now or wait?"

RESEARCH PLAN:

WEEK 1: US Market Landscape
□ Identify US competitors (Gong, Chorus, Revenue.io)
□ Price benchmarking (3-4× higher than India)
□ Customer interviews (5 US sales leaders)
□ Question: "Would you buy from India-based company?"

WEEK 2: Go/No-Go Analysis

PROS (Go to US):
✅ 7× larger market (15K SMB SaaS vs 2K in India)
✅ Higher ACVs ($10K-20K vs $3K-5K in India)
✅ Less competitive at SMB (Gong focuses on enterprise)
✅ Investors want US traction

CONS (Wait):
❌ Need US team (sales, support = $300K-500K/year)
❌ Brand unknown (India success doesn't transfer)
❌ Time zone challenge (India team supporting US customers)
❌ Payment processing (Stripe US vs India)
❌ India market still underpenetrated (2K companies, only 50 customers)

CALCULATION:
US Expansion Cost Year 1: $500K (team + marketing)
India Deepening Cost Year 1: $200K (same team)

US Upside: 10 customers × $15K = $150K ARR
India Upside: 30 customers × $4K = $120K ARR

ROI: Similar, but India has less execution risk

RECOMMENDATION: Focus India until $10M ARR
Reason:
- Still early in India (50/2000 = 2.5% penetration)
- US requires significant investment
- India market understands our pain points better
- Build case studies in India first, then leverage for US

EXCEPTION: If US strategic investor leads Series B, then expand
```

### **Example 2: HR Tech PMM, Series B, Module Expansion Decision**

```
SCENARIO:
- Company: Employee engagement platform, $18M ARR
- Stage: Series B (400 customers, mid-market focus)
- Current: Just engagement surveys + pulse
- Question: "Add performance management or recruiting module?"

RESEARCH PLAN (2 Weeks):

COMPETITIVE ANALYSIS:

Performance Management:
□ Competitors: Lattice, 15Five, BetterUp
□ Market: Crowded but growing
□ Customer need: 67% of customers ask for it (from surveys)
□ Build vs Buy: 12 months to build, or acquire for $10M-20M
□ Cannibalization: Low (complements engagement)

Recruiting:
□ Competitors: Lever, Greenhouse, Ashby
□ Market: Very crowded, strong incumbents
□ Customer need: 31% ask for it
□ Build vs Buy: 18 months to build, complex
□ Cannibalization: Medium (different buyer - TA vs HR)

WIN/LOSS ANALYSIS:
Interviewed 20 customers:
- Lost 8 deals to Lattice (reason: "Wanted engagement + performance")
- Lost 2 deals to Greenhouse (reason: "Recruiting was priority")

CUSTOMER SURVEYS:
"If we added one module, which would you want?"
- Performance management: 68%
- Recruiting: 23%
- Learning & development: 9%

DECISION: Build Performance Management
Reason:
- Higher customer demand (68% vs 23%)
- Reduces churn to Lattice
- Easier to build (12 vs 18 months)
- Natural adjacency (same buyer = CHRO)
- Recruiting too competitive (Lever, Greenhouse mature)

IMPLEMENTATION:
- Timeline: 12 months to launch
- Investment: $800K-1.2M (4 engineers × 12 months)
- Go-to-market: Existing customers first (upsell)
- Pricing: +$2/employee/month for performance add-on
```

### **Example 3: Fintech CMO, Series C, M&A Target Identification**

```
SCENARIO:
- Company: Corporate expense management, $45M ARR
- Stage: Series C (preparing for Series D/IPO)
- Current: Expense management only, want to expand
- Board directive: "Acquire complementary fintech to become platform"

RESEARCH PLAN (4 Weeks):

WEEK 1: Define Acquisition Thesis
Options:
1. Corporate cards (compete with EnKash, Volopay)
2. Payroll (compete with Razorpay Payroll, Zoho)
3. Procurement (compete with Procol, Kissflow)

STRATEGIC FIT ANALYSIS:

Corporate Cards:
□ Customer overlap: High (95% of customers want cards)
□ Revenue synergy: High (attach rate 70-80%)
□ Regulatory: Need RBI PPI license (or acquire licensed)
□ Competition: Medium (EnKash, Volopay)

Payroll:
□ Customer overlap: Medium (60% have <200 employees)
□ Revenue synergy: Medium (attach rate 40-50%)
□ Regulatory: Complex (state labor laws, compliance)
□ Competition: High (Razorpay, Zoho, many others)

Procurement:
□ Customer overlap: Low (30% need procurement)
□ Revenue synergy: Low (attach rate 20-30%)
□ Regulatory: Minimal
□ Competition: Low (early market)

DECISION: Acquire Corporate Cards Player
Reason: Highest customer overlap + revenue synergy

WEEK 2-3: Target Identification

TARGET CRITERIA:
□ RBI PPI licensed (saves us 18 months)
□ $5M-15M ARR (affordable at $40M-100M valuation)
□ 1,000-5,000 cards issued (proof of concept)
□ Complementary customer base (not too much overlap)
□ Strong technology (can integrate in 6 months)

TARGET SHORTLIST:
1. Company A: $8M ARR, RBI licensed, 3,000 cards
2. Company B: $12M ARR, not licensed (partner model)
3. Company C: $6M ARR, RBI licensed, 2,000 cards

WEEK 4: Due Diligence (Company A)

LICENSE VERIFICATION:
□ RBI PPI license: Valid until 2027 ✅
□ Compliance record: Clean (no RBI actions) ✅
□ License transferable: Yes (with RBI approval, 3-6 months) ✅

CUSTOMER ANALYSIS:
□ Total customers: 180
□ Overlap with us: 15 customers (8%)
□ Customer retention: 89% (good)
□ Average cards per customer: 17 cards

TECHNOLOGY:
□ Core platform: Modern (Node.js, AWS)
□ Integration complexity: Medium (6-9 months)
□ Technical debt: Manageable

VALUATION:
□ ARR: $8M
□ Growth: 120% YoY
□ Burn: $800K/month
□ Asking price: 8-10× ARR = $64M-80M
□ Our offer: $60M (7.5× ARR)

RECOMMENDATION: Acquire Company A for $60M
Synergy case:
- Year 1: Upsell cards to our 1,200 customers
- Attach rate assumption: 40%
- New ARR: 480 customers × $15K avg = $7.2M
- Acquisition pays for itself in 8-10 years (vs building = 18 months delay)
```

---

## **Common Research Mistakes & How to Avoid Them**

### **Mistake 1: "Industry-Agnostic Research" (One-Size-Fits-All)**

```
WRONG APPROACH:
"I'll use the same battle card template for Sales Tech, HR Tech, and Fintech"

WHY IT FAILS:
- Sales Tech: Can be aggressive ("We're 10× cheaper than Gong")
- HR Tech: Must be professional ("We're built for mid-market")
- Fintech: Must be conservative ("Both of us are RBI-compliant...")

CORRECT APPROACH:
Use industry-specific positioning frameworks:
→ Sales Tech → Sections A1-A3
→ HR Tech → Sections B1-B3
→ Fintech → Sections C1-C3
→ Ops Tech → Sections D1-D3
```

### **Mistake 2: "Stage-Agnostic Budgets" (Wrong Tools for Stage)**

```
WRONG APPROACH:
"Series A company buying Gartner subscription ($35K/year)"

WHY IT FAILS:
- Series A budget: $0-500/month total marketing tools
- Gartner: $35K/year = 70% of annual tool budget
- ROI: Gartner useful for enterprise sales (Series C+), not early-stage

SERIES A TOOLS: Free + LinkedIn Sales Nav ($99/mo)
SERIES B TOOLS: Add Crunchbase Pro, SimilarWeb ($250-350/mo)
SERIES C+ TOOLS: Now justify Gartner, Klue, ZoomInfo

CORRECT APPROACH:
Match tool spend to stage → See budget tables in each section
```

### **Mistake 3: "Geography-Agnostic Competitors" (Wrong Comp Set)**

```
WRONG APPROACH:
India sales tech startup positioning against Gong/Outreach only

WHY IT FAILS:
- Gong: $500M+ valuation, US-focused, enterprise
- Real competition in India: Wingman, local startups, price-sensitive
- Customers ask: "Why not Wingman?" not "Why not Gong?"

CORRECT APPROACH:
PRIMARY COMP SET (Direct competition):
- India-based competitors at similar stage
- Example: Wingman for sales tech, Darwinbox for HR Tech

SECONDARY COMP SET (Aspiration):
- Global players (Gong, Lattice) for positioning
- "We're Gong-quality at Indian pricing"
```

### **Mistake 4: "Ignoring Regulatory Differences" (Fintech/HR Tech)**

```
WRONG APPROACH:
Copy US Fintech research playbook for India

WHY IT FAILS:
US Fintech:
- Regulation: State-by-state, relatively open
- Innovation: Encouraged (regulatory sandboxes)

India Fintech:
- Regulation: RBI central control, strict
- Innovation: Controlled (must have license first)
- Compliance: Data localization mandatory

CORRECT APPROACH:
Research regulatory landscape FIRST, then competitors
→ See Section C1 (Fintech regulatory overview)
```

### **Mistake 5: "Vanity Metrics in Market Sizing" (Top-Down Only)**

```
WRONG APPROACH:
"Global sales tech market is $10B, India is 2%, so India = $200M"

WHY IT FAILS:
- Top-down often overestimates
- Doesn't account for price differences (India pays 30-50% of US prices)
- Doesn't validate with bottom-up

CORRECT APPROACH:
ALWAYS triangulate:
1. Bottom-up: Count companies in ICP × estimated deal size
2. Top-down: Global market × geography % × category %
3. Validation: Interview industry experts, "Does $X feel right?"

If bottom-up = $50M and top-down = $200M:
→ Use conservative middle ground ($75M-100M)
→ Document assumptions clearly
```

---

## **Tool Comparison Matrix**

### **By Company Stage & Budget**

| Tool | Series A | Series B | Series C+ | Best For | Industry |
|------|----------|----------|-----------|----------|----------|
| **Google Search** | ✅ FREE | ✅ Use | ✅ Use | All | All |
| **LinkedIn (Free)** | ✅ FREE | ✅ Use | ✅ Use | All | All |
| **G2/Capterra** | ✅ FREE | ✅ Use | ✅ Use | Review mining | All |
| **Crunchbase Free** | ✅ FREE | ⚠️ Limit | ⚠️ Limit | Funding data | All |
| | | | | | |
| **LinkedIn Sales Nav** | 💰 $99 | ✅ YES | ✅ YES | ICP sizing, org charts | All |
| **Crunchbase Pro** | 💰 $29 | ✅ YES | ✅ YES | Competitor funding | All |
| **SimilarWeb** | ❌ Skip | ✅ $125 | ✅ YES | Traffic analysis | Sales/Martech |
| **Ahrefs** | ❌ Skip | ⚠️ $99 | ✅ YES | SEO competitive | Sales/Martech |
| **G2 Track** | ❌ Skip | ⚠️ $150 | ✅ YES | Review monitoring | HR Tech |
| | | | | | |
| **Gartner** | ❌ No | ❌ Maybe | ✅ $35K+ | Analyst access, MQ | HR Tech, Enterprise |
| **Klue/Crayon** | ❌ No | ❌ Maybe | ✅ $18K+ | CI platform | Series C+ All |
| **ZoomInfo** | ❌ No | ❌ Maybe | ✅ $20K+ | Contact data | Series C+ All |
| | | | | | |
| **Vanta/Drata** | ⚠️ Fintech | ✅ Fintech | ✅ All | SOC 2 compliance | Fintech, HR Tech, Ops |
| **Legal Counsel** | ✅ Fintech | ✅ Fintech | ✅ All | Regulatory | Fintech mandatory |

**Key:**
- ✅ = Recommended at this stage
- 💰 = Consider if budget allows
- ⚠️ = Conditional (see section for details)
- ❌ = Skip (not worth it at this stage)

---

## **Prompt Templates for Each Scenario**

### **Template 1: Series A Sales Tech Competitive Positioning**

```
Using the Competitive Intelligence skill, Section A1:

I'm a Series A Sales Tech founder in [India/US].

My product: [One-line description]
My ICP: [Company size, industry]
My competitors: [List 3-5 known competitors]
My question: [Positioning / Battle cards / Market sizing / All of the above]

Provide:
1. 3-day research sprint plan (using FREE tools only)
2. Sales Tech specific competitor tiers (Enterprise/Growth/Emerging)
3. Positioning framework (vs Gong/Outreach if US, vs Wingman/local if India)
4. Battle card template (aggressive but not offensive)
5. Market sizing (bottom-up + top-down validation)

India-specific if applicable:
- Local competitor focus
- Rupee pricing benchmarks
- India B2B SaaS community sources
```

### **Template 2: Series B HR Tech Module Expansion Research**

```
Using the Competitive Intelligence skill, Section B2:

I'm Series B HR Tech PMM.

Current product: [What we have today]
Considering adding: [Performance / Recruiting / Learning / Payroll]
Competitors: [List main competitors]
Goal: [Build vs Buy / Timing / Prioritization]

Provide:
1. 2-week research plan (with paid tools budget $300-500/mo)
2. Module expansion analysis (which competitors added what, when)
3. Win/loss framework (why we lose to Lattice/competitors)
4. Build vs Buy analysis (12-month timeline, cost estimate)
5. Customer demand validation (survey questions to ask)

Remember:
- HR Tech = professional tone (never attack competitors)
- Compliance considerations (GDPR, labor laws)
- Committee buying dynamics (HR + Finance + Legal)
```

### **Template 3: Series A Fintech Regulatory Competitive Analysis**

```
Using the Competitive Intelligence skill, Section C1:

I'm Series A Fintech founder in India.

My product: [Expense mgmt / Corporate cards / Payroll / Other]
My question: [Which licenses needed? / Competitor compliance? / Positioning?]
Market: [India / Planning US expansion / Both]

Provide:
1. Regulatory landscape overview (RBI licenses needed)
2. Competitor license mapping (who has what)
3. Compliance timeline (how long to get licensed)
4. Conservative positioning framework (fintech-appropriate)
5. Research plan with legal review checkpoints

CRITICAL:
- Ultra-conservative (regulatory risk is extreme)
- Legal review mandatory disclaimer
- No competitor attacks (could trigger RBI scrutiny)
- Data privacy compliance (cannot share user data)
```

### **Template 4: Series B Operations Tech Upmarket Research**

```
Using the Competitive Intelligence skill, Section D2:

I'm Series B Operations Tech (Retail Execution) in India.

Current customers: [Tier 2-3 CPG brands]
Goal: Win Tier 1 customers (HUL, ITC, Nestle, Dabur)
Question: What do I need to compete at Tier 1?

Provide:
1. Tier 1 requirements analysis (features, scale, integrations)
2. Competitor comparison (FieldAssist, Bizom, Ivy capabilities)
3. Gap analysis (what we're missing for enterprise)
4. Roadmap priorities (24-month path to Tier 1 readiness)
5. Go-to-market strategy (regional brand → Tier 1 pilot)

India retail context:
- MNC CPG vs Indian CPG buying patterns
- Distributor dynamics (B2B2B complexity)
- Offline-first requirements (patchy 4G)
- Multi-language support (Hindi + regional)
```

---

## **Troubleshooting Guide: Research Challenges**

### **Issue 1: "Can't find competitor pricing information"**

```
DIAGNOSIS:
□ Checked competitor websites? (pricing page)
□ Checked G2 reviews? (users mention price)
□ Searched "[competitor] pricing" on Google?
□ Asked in communities (Reddit, Slack groups)?

SOLUTIONS:

SHORT-TERM (This Week):
□ Use G2 review search: filter by "pricing" mentions
□ Example: "Gong pricing" in reviews → users say "$1,500-4,000/seat"
□ Check Reddit: r/sales, r/saas for user-reported pricing
□ LinkedIn polls: "What do you pay for [category]?"

MEDIUM-TERM (This Month):
□ Interview customers: "Which competitors did you evaluate? What was pricing?"
□ Interview lost deals: "Why did you choose [Competitor]? Was price a factor?"
□ Sales Nav: Find people who work at competitor, connect, ask (subtly)

LONG-TERM (Next Quarter):
□ Commission research: Hire firm to do competitive pricing study
□ Partner pricing: If you partner with competitor, you'll learn pricing
□ Board connections: Investors often know competitor pricing

WORKAROUNDS:
If still can't find pricing:
□ Estimate based on: Category averages (G2 pricing filter)
□ Back-calculate: If competitor raised $X, has Y employees, burns $Z, estimate ACV
□ Disclaimer: "Estimated pricing based on industry benchmarks and user reports"
```

### **Issue 2: "Competitor in different geography (India vs US)"**

```
DIAGNOSIS:
□ India company expanding to US?
□ US company entering India?
□ Need to compare both markets?

SOLUTIONS:

SCENARIO A: India Company → US Expansion

Step 1: Identify US Equivalents
- Don't compete with Gong directly (you're unknown in US)
- Find: Mid-tier US players (similar stage to you)
- Example: India sales tech → Compare to Revenue.io (Series B) not Gong (unicorn)

Step 2: Price Expectations
- India: $3K-5K annual for sales tech
- US: $10K-20K annual (2-4× higher)
- Adjust your pricing up for US market

Step 3: Positioning
- Don't say: "We're Indian alternative to Gong"
- Do say: "Global sales tech, trusted by [India customers], expanding to US"

SCENARIO B: US Company → India Entry

Step 1: Identify Local Competition
- Don't ignore local players (they have price advantage)
- Find: India startups in your space
- Example: Gong entering India → compete with Wingman (local, cheaper)

Step 2: Price Adaptation
- US: $20K/year for Gong
- India: Must price at $6K-10K (0.3-0.5× of US price)
- Or: Risk being "too expensive for India market"

Step 3: Localization
- Language: Hindi + English minimum
- Support: India time zones (IST)
- Payments: Rupee pricing, Indian payment methods
```

### **Issue 3: "No public information on competitor (stealth mode)"**

```
DIAGNOSIS:
□ Competitor is pre-launch or stealth?
□ No website, no reviews, minimal info?
□ Only rumors or whispers in market?

SOLUTIONS:

SIGNALS TO TRACK:

LinkedIn Signals:
□ Company page: How many employees? Growing?
□ Job postings: What roles? (Hiring SDRs = going to market soon)
□ Employee profiles: What are they building? (LinkedIn posts)
□ Founder posts: Any hints about product?

Crunchbase:
□ Funding: How much raised? When?
□ Investors: Who backed them? (signals their focus)
□ Founders: Their background (hints at product direction)

GitHub:
□ Public repos: Any open-source components?
□ Employee commits: What tech stack?

Y Combinator / Accelerators:
□ YC company directory: Their one-liner description
□ Demo day pitches: Sometimes recorded/transcribed

NETWORK INTELLIGENCE:
□ Shared investors: Ask your investors about competitor
□ Shared customers: Ask "Have you heard of [Competitor]?"
□ Industry events: Attend where they might present
□ Sales team: Lost a deal to them? Interview the customer

CONSERVATIVE APPROACH:
If minimal info:
□ Don't speculate in battle cards
□ Focus on: "Emerging competitor, watching closely"
□ Monitor: Set Google Alerts, track their LinkedIn
□ Update: Quarterly reviews of stealth competitors
```

### **Issue 4: "Conflicting data from multiple sources"**

```
DIAGNOSIS:
□ G2 says competitor is $5K, Reddit says $10K?
□ Crunchbase says $20M ARR, press release says $15M?
□ Analyst report says X, our research says Y?

SOLUTIONS:

EVALUATE SOURCE CREDIBILITY:

TIER 1 (Highest Credibility):
□ Official company announcements (press releases)
□ Regulatory filings (RBI, SEC if public)
□ Analyst reports (Gartner, Forrester - but expensive)

TIER 2 (Medium Credibility):
□ Industry publications (TechCrunch, ET Tech)
□ Customer testimonials (G2 verified reviews)
□ Investor announcements (funding rounds)

TIER 3 (Lower Credibility):
□ Anonymous reviews (unverified)
□ Reddit/community posts (rumors)
□ Third-party estimates (e.g., Sensor Tower DAU estimates)

RECONCILIATION APPROACH:

Example: Competitor pricing conflict
- G2 review: "We pay $5K/year" (1 data point)
- Reddit: "Quoted at $10K" (another data point)
- Website: No pricing (not helpful)

Resolution:
1. More data: Read 20+ G2 reviews, find pricing mentions
2. Find range: "$5K-10K annually depending on seats, features"
3. Present as range: "Estimated $5K-10K based on user reports"
4. Confidence level: "Medium confidence (based on user reports, not official)"

DISCLOSURE IN REPORTS:
"Competitor pricing: $5K-10K estimated annual
Source: G2 user reviews (n=12), Reddit discussions (n=3)
Confidence: Medium (no official pricing available)
Last updated: [Date]"
```

### **Issue 5: "Board wants faster research (can't spend 2 weeks)"**

```
DIAGNOSIS:
□ Urgent board meeting (3 days notice)?
□ Quick competitive snapshot needed?
□ Can't do 2-week comprehensive research?

SOLUTIONS:

48-HOUR RAPID COMPETITIVE BRIEF:

DAY 1 (4 hours):
09:00-10:00 | Competitive List
□ Google: "[category] competitors"
□ G2 category page: Top 20 players
□ Output: List of 15-20 competitors

10:00-11:30 | Tier Categorization
□ Tier 1: Enterprise leaders (Gong, Workday, Stripe)
□ Tier 2: Growth stage (Your real competition)
□ Tier 3: Emerging (Watch list)
□ Output: Tiered competitor matrix

11:30-13:00 | Quick Positioning Map
□ 2×2 matrix (pick 2 dimensions relevant to you)
□ Plot top 10 competitors
□ Identify white space
□ Output: Positioning slide

DAY 2 (4 hours):
09:00-11:00 | Battle Cards (Top 3 Only)
□ Focus: Top 3 competitors only
□ Quick research: Website, G2 (read 10 reviews each)
□ Template: Strengths, Weaknesses, When we win
□ Output: 1-page battle cards (3 total)

11:00-13:00 | Executive Summary
□ 1-page: Competitive landscape
□ 3-5 bullets: Key insights
□ 2-3 recommendations: Strategic implications
□ Output: Executive slide

BOARD PRESENTATION (10 slides, 15 minutes):
1. Competitive landscape overview
2. Tiered competitor matrix
3. 2×2 positioning map
4. Top 3 competitor battle cards (1 slide each)
5. Market trends
6. Strategic recommendations
7. Q&A backup slides

DISCLAIMER TO BOARD:
"This is a rapid competitive snapshot (48 hours research)
For comprehensive analysis, recommend 2-week deep dive
Key areas needing more research: [Pricing, Market sizing, etc.]"
```

---

## **Related Skills**

**Complement This Skill With:**

- **Content Writing & Thought Leadership** - Turn competitive insights into thought leadership content
- **Personal Branding & Authority** - Position yourself as market expert
- **Newsletter Creation** - Share market intelligence with prospects
- **Social Media Management** - Amplify competitive insights

---

## **Quick Reference Cards**

### **When To Use Which Section:**

```
SALES TECH (conversation intelligence, sales engagement):
→ Sections A1, A2, A3

HR TECH (HRIS, engagement, performance, recruiting):
→ Sections B1, B2, B3

FINTECH (payments, expense, cards, payroll):
→ Sections C1, C2, C3

OPERATIONS TECH (retail execution, logistics, field force):
→ Sections D1, D2, D3
```

### **Research Timeline by Stage:**

```
SERIES A:
- Quick research: 2-3 days
- Comprehensive: 5 days
- Tools: Free only
- Output: Battle cards + positioning

SERIES B:
- Quick research: 1 week
- Comprehensive: 2 weeks
- Tools: $250-600/month
- Output: Strategic positioning + win/loss

SERIES C+:
- Ongoing: Quarterly cycles
- Deep dive: 4 weeks per quarter
- Tools: $75K-300K/year
- Output: Board-level intelligence + M&A
```

---

**END OF SKILL**
