# Competitive Intelligence & Market Research

**B2B SaaS competitive intelligence with 24 ready-to-use scenarios across Sales Tech, HR Tech, Fintech, and Ops Tech verticals.**

Created by [Shashwat Ghosh](https://linkedin.com/in/shashwatghosh-ai-b2b-gtm-fractionalcmo) - Founder of Helix GTM Consulting

---

## 📋 Table of Contents

- [What This Skill Does](#what-this-skill-does)
- [What This Skill Cannot Do](#what-this-skill-cannot-do)
- [Industry Coverage](#industry-coverage)
- [Key Features](#key-features)
- [Use Cases](#use-cases)
- [Installation](#installation)
- [Examples](#examples)
- [Author](#author)

---

## ✅ What This Skill Does

This skill provides comprehensive competitive intelligence frameworks for B2B SaaS companies:

### Core Capabilities:

1. **Competitive Analysis Frameworks**
   - Feature-by-feature competitive comparison matrices
   - Pricing intelligence and positioning analysis
   - Market positioning and differentiation strategies
   - Competitive battle cards for sales teams
   - SWOT analysis for key competitors

2. **Market Research Methodologies**
   - Industry trend analysis and market sizing
   - Customer interview frameworks
   - Win/loss analysis structures
   - Market segmentation strategies
   - Buyer persona development

3. **Intelligence Gathering Workflows**
   - Competitor website monitoring checklists
   - Product update tracking systems
   - Social media monitoring strategies
   - Review site analysis frameworks
   - G2/Capterra competitive positioning

4. **Sales Enablement**
   - Competitive objection handling scripts
   - Feature comparison talking points
   - ROI comparison calculators
   - Competitive displacement strategies
   - Alternative evaluation guides

5. **Strategic Planning Support**
   - Market entry analysis
   - Product roadmap competitive gaps
   - Pricing strategy recommendations
   - Partnership opportunity identification
   - M&A target evaluation

### Industry-Specific Intelligence:

- **Sales Tech**: CRM, Sales Engagement, Revenue Intelligence, Sales Enablement
- **HR Tech**: HRIS, ATS, Performance Management, Learning Management
- **Fintech**: Payments, Banking, Lending, Wealth Management
- **Ops Tech**: Project Management, Workflow Automation, DevOps, IT Management

### Supported Scenarios (24 Total):

Each vertical includes 6 specific scenarios covering:
1. Market research and sizing
2. Competitive feature analysis
3. Pricing intelligence
4. Customer sentiment analysis
5. Product launch preparation
6. Strategic positioning

---

## ❌ What This Skill Cannot Do

### Limitations to Understand:

1. **No Real-Time Data Access**
   - Cannot fetch live competitor pricing
   - Cannot monitor competitor websites in real-time
   - Cannot access proprietary databases or paid research
   - Cannot scrape competitor websites automatically

2. **No Industry-Specific Expertise Beyond Templates**
   - Does not replace domain expertise in specialized verticals
   - Cannot provide legal/regulatory compliance advice
   - Cannot validate technical feasibility of features
   - Cannot assess patent or IP implications

3. **No Automated Intelligence Gathering**
   - Cannot set up monitoring systems automatically
   - Cannot send alerts for competitor changes
   - Cannot integrate with CI platforms directly
   - Cannot access private competitor information

4. **No Financial Analysis**
   - Cannot perform detailed financial modeling
   - Cannot access private company financials
   - Cannot predict competitor revenue/funding
   - Cannot assess acquisition valuations

5. **No Custom Research**
   - Cannot conduct primary research (surveys, interviews)
   - Cannot access proprietary market research databases
   - Cannot contact competitors directly
   - Cannot validate market data independently

6. **Limited to B2B SaaS Context**
   - Frameworks optimized for B2B software companies
   - May not suit B2C, hardware, or services businesses
   - Focused on software products, not professional services

---

## 🏢 Industry Coverage

### Fully Supported Verticals:

1. **Sales Tech (6 scenarios)**
   - CRM platforms
   - Sales engagement tools
   - Revenue intelligence
   - Sales enablement platforms
   - CPQ (Configure, Price, Quote)
   - Account-based marketing

2. **HR Tech (6 scenarios)**
   - HRIS/HCM platforms
   - Applicant tracking systems
   - Performance management
   - Learning management systems
   - Recruitment marketing
   - Employee engagement

3. **Fintech (6 scenarios)**
   - Payment processing
   - Digital banking
   - Lending platforms
   - Wealth management
   - Expense management
   - Financial planning

4. **Ops Tech (6 scenarios)**
   - Project management
   - Workflow automation
   - DevOps platforms
   - IT service management
   - Infrastructure monitoring
   - Collaboration tools

### Partial Support (Adaptable):

- Marketing Tech (adapt Sales Tech scenarios)
- Customer Success Tech (adapt HR Tech scenarios)
- Analytics/BI (adapt Ops Tech scenarios)
- Security/Compliance (adapt Ops Tech scenarios)

---

## 🎯 Key Features

### 1. Ready-to-Use Templates
- Copy-paste competitive analysis frameworks
- Pre-structured battle card templates
- Standard pricing comparison matrices
- Feature gap analysis spreadsheets

### 2. Workflow Guides
- Step-by-step intelligence gathering processes
- Competitor monitoring checklists
- Analysis documentation standards
- Stakeholder communication templates

### 3. Strategic Frameworks
- Porter's Five Forces adapted for SaaS
- Blue Ocean Strategy canvas
- Jobs-to-be-Done analysis
- Value proposition comparison

### 4. Sales Enablement Assets
- Competitive objection scripts
- "Why Us vs. Them" one-pagers
- ROI comparison calculators
- Proof point libraries

### 5. Research Methodologies
- Win/loss interview guides
- Customer reference check questions
- Analyst briefing structures
- Partner feedback frameworks

---

## 💼 Use Cases

### For Product Marketing:
- Build competitive positioning for product launches
- Create messaging that differentiates from competitors
- Develop competitive battle cards for sales
- Research market gaps for product roadmap

### For Sales Teams:
- Handle competitive objections confidently
- Position against specific competitors
- Understand competitor strengths/weaknesses
- Win competitive displacement deals

### For Product Management:
- Identify feature gaps vs. competitors
- Validate product roadmap priorities
- Assess market positioning opportunities
- Evaluate partnership possibilities

### For Executive Leadership:
- Make strategic market entry decisions
- Evaluate M&A targets
- Assess competitive threats
- Guide pricing strategy

### For Investors/Analysts:
- Evaluate competitive landscape
- Assess market positioning
- Understand differentiation
- Validate market opportunity

---

## 📦 Installation

### Method 1: Using Clawd CLI

```bash
clawdhub install shashwatgtm/competitive-intelligence-market-research
```

### Method 2: Using Claude.ai

1. Download the `SKILL.md` file from this repository
2. Go to Claude.ai → Settings → Skills
3. Click "Upload Skill" and select the file
4. The skill will be available in all your conversations

### Method 3: Using Claude Desktop

1. Download the `SKILL.md` file
2. Open Claude Desktop → Settings → Skills
3. Add the skill file
4. Enable for use in conversations

---

## 📚 Examples

### Example 1: Competitive Feature Analysis

**Prompt:**
```
I'm launching a new CRM feature called "Revenue Intelligence Dashboard" 
that predicts deal outcomes. Which competitors should I analyze and 
what features should I compare?
```

**The skill will provide:**
- List of 5-8 key competitors with similar features
- Feature comparison matrix template
- Analysis framework for predictive capabilities
- Differentiation positioning suggestions
- Battle card structure for sales enablement

---

### Example 2: Market Research for Fundraising

**Prompt:**
```
I'm preparing a Series B deck for our HR Tech platform. I need market 
sizing, competitive landscape, and our positioning vs. top 3 competitors.
```

**The skill will provide:**
- Market sizing methodology and data sources
- TAM/SAM/SOM calculation framework
- Competitive landscape mapping
- Positioning matrix template
- Differentiation talking points for investors

---

### Example 3: Win/Loss Analysis

**Prompt:**
```
We lost a deal to Competitor X. Help me structure a win/loss analysis 
interview with the prospect to understand what happened.
```

**The skill will provide:**
- Win/loss interview question framework
- Objection categorization system
- Analysis documentation template
- Action items generation process
- Sales feedback loop structure

---

### Example 4: New Market Entry

**Prompt:**
```
We're considering entering the Learning Management System market. 
What competitive intelligence do I need to gather first?
```

**The skill will provide:**
- Market entry research checklist
- Competitor identification methodology
- Barrier to entry analysis framework
- Positioning opportunity assessment
- Go-to-market strategy considerations

---

## 🔧 Integration & Workflow

### Works Best With:
- Product launches and positioning projects
- Sales enablement initiatives
- Strategic planning sessions
- Fundraising preparation
- M&A due diligence

### Typical Workflow:
1. **Identify scenario** (e.g., "competitive feature analysis")
2. **Provide context** (your product, competitors, market)
3. **Receive framework** (structured analysis template)
4. **Execute research** (gather data using provided methodology)
5. **Document findings** (fill in analysis framework)
6. **Create deliverables** (battle cards, one-pagers, presentations)

---

## 📊 What You'll Get

### Analysis Templates:
- Competitive feature matrices (Excel/Google Sheets compatible)
- SWOT analysis frameworks
- Positioning maps and perceptual maps
- Pricing comparison tables

### Sales Assets:
- Competitive battle cards
- Objection handling scripts
- "Why Us" one-pagers
- Proof point libraries

### Research Guides:
- Win/loss interview scripts
- Customer reference questions
- Analyst briefing outlines
- Partner feedback frameworks

### Strategic Documents:
- Market entry assessments
- Product gap analyses
- Positioning statements
- Differentiation playbooks

---

## 🚀 Best Practices

### To Get Maximum Value:

1. **Be Specific**: Provide your exact product category and top 3-5 competitors
2. **Include Context**: Share your market position (leader/challenger/niche)
3. **Define Goals**: State whether you need sales enablement, strategy, or research
4. **Iterate**: Start with one scenario, then expand to related analyses
5. **Combine Scenarios**: Use multiple frameworks for comprehensive intelligence

### Common Patterns:

- **Product Launch**: Use scenarios 2 (feature analysis) + 3 (pricing) + 5 (launch prep)
- **Sales Enablement**: Use scenarios 2 (features) + 4 (sentiment) + objection handling
- **Strategic Planning**: Use scenarios 1 (market research) + 6 (positioning) + gap analysis
- **Fundraising Prep**: Use scenarios 1 (market) + 4 (validation) + competitive landscape

---

## 👨‍💼 Author

**Shashwat Ghosh**  
Founder, Helix GTM Consulting | Fractional CMO for B2B SaaS

### Background:
- Former CMO at FieldAssist (until Sept 2024)
- Former VP Global Performance Marketing at Locus
- 15+ years in B2B SaaS marketing and GTM strategy
- Creator of EPIC GTM Framework (Ecosystem, PLG, Inbound/Outbound, Community)

### Connect:
- 🔗 LinkedIn: [linkedin.com/in/shashwatghosh-ai-b2b-gtm-fractionalcmo](https://linkedin.com/in/shashwatghosh-ai-b2b-gtm-fractionalcmo)
- 🐦 X/Twitter: [@Shashwat_Ghosh](https://x.com/Shashwat_Ghosh)
- 📧 Substack: [shashwatghosh.substack.com](https://shashwatghosh.substack.com)
- 💻 GitHub: [@shashwatgtm](https://github.com/shashwatgtm)

### Other Skills:
- [Content Writing & Thought Leadership](https://github.com/shashwatgtm/content-writing-thought-leadership)
- [Social Media Management](https://github.com/shashwatgtm/social-media-management)
- [Newsletter Creation & Curation](https://github.com/shashwatgtm/newsletter-creation-curation)
- [Personal Branding & Authority](https://github.com/shashwatgtm/personal-branding-authority)

---

## 📄 License

MIT License - Free to use, modify, and distribute with attribution.

---

## 🙏 Contributing

Found an issue or have suggestions? Feel free to:
- Open an issue on GitHub
- Submit a pull request
- Contact me directly via LinkedIn

---

## ⭐ Support

If this skill helps your competitive intelligence efforts, please:
- ⭐ Star this repository
- 📢 Share with your network
- 💬 Provide feedback for improvements

---

**Last Updated**: January 2026  
**Version**: 1.0  
**Status**: Production Ready ✅
