---
name: competitive-analysis
description: Perform a deep competitive analysis for a solopreneur business. Use when mapping competitors in detail, finding exploitable gaps, understanding competitor strategy, benchmarking your own offering, or deciding how to position against the field. Goes deeper than the broad landscape mapping in market-research — this is focused dissection of specific competitors. Trigger on "analyze my competitors", "competitive analysis", "who are my competitors", "competitor deep-dive", "how do I beat the competition", "competitive landscape", "benchmark against competitors".
---

# Competitive Analysis

## Overview
Shallow competitive research (checking a few websites) is not enough. This playbook gives you a systematic way to dissect competitors across strategy, product, pricing, marketing, operations, and reviews — then synthesise findings into exploitable gaps and a positioning wedge.

---

## Step 1: Identify and Tier Your Competitors

Not all competitors are equal. Categorize them before diving in.

**Direct competitors:** Solve the exact same problem for the exact same customer. These are your primary benchmarks.

**Indirect competitors:** Solve a related problem or serve the same customer with a different solution. These matter because your customer is choosing between ALL of them (including doing nothing).

**Aspirational competitors:** Not in your niche yet, but could be. Larger or more established players who might expand into your space. Monitor these — they reveal what "winning at scale" looks like.

**Identify 3-5 direct, 2-3 indirect, and 1-2 aspirational.** You don't need to deep-dive all of them — focus your deepest analysis on your top 3 direct competitors.

---

## Step 2: Intelligence Gathering Framework

For each competitor you're deep-diving, collect data across these six layers:

### Layer 1: Strategy & Positioning
- What is their stated mission or tagline?
- Who do they say they're for? (Check homepage, about page, marketing copy)
- What problem do they claim to solve?
- What is their core differentiator? (The one thing they lean hardest on)
- Who do they NOT serve? (The gaps in their positioning = your opportunity)

### Layer 2: Product & Features
- What does their product actually do? (Use their product page, feature list, docs)
- What is their product's complexity level? (Simple tool vs. full platform)
- What are their key technical strengths?
- What's missing from their product that users would want? (See Layer 5 — Reviews)
- What's their integration ecosystem like?

### Layer 3: Pricing & Business Model
- What pricing tiers do they offer?
- What's included at each tier?
- Do they offer a free tier or free trial? What's the conversion funnel?
- What's their pricing psychology? (Per-user, per-usage, flat-rate, freemium?)
- Where are the pricing gaps? (Too expensive for small users? No mid-tier option?)

### Layer 4: Marketing & Distribution
- How do they acquire customers? (Check: SEO — use Ahrefs/Ubersuggest free; Paid ads — use Google Ads Transparency Center or Facebook Ad Library; Content — check their blog, YouTube, social)
- What channels are they strongest on?
- What channels are they ignoring? (Your opening)
- What is their content strategy? (Blog topics reveal what they think customers care about)
- Do they have a referral or partner program?

### Layer 5: Customer Reviews (Critical Layer)
This is where you find gold. Read 20+ reviews per competitor across:
- G2, Capterra, Trustpilot
- App Store / Google Play (if applicable)
- Reddit threads mentioning the product
- Twitter/X mentions

**Categorize every complaint you find:**
- Feature gaps (things users want but don't have)
- UX/experience frustrations (things that are clunky or confusing)
- Pricing complaints (things users think are overpriced or unfair)
- Support complaints (things the company handles poorly)
- Onboarding complaints (things that are hard to get started with)

**Also note what users praise most** — these are the table stakes you must match.

### Layer 6: Company Health & Trajectory
- When was the company founded? How old is it?
- Is it funded? How much? By whom? (Crunchbase)
- Headcount trend on LinkedIn — growing, stable, or shrinking?
- Recent news, blog posts, or product announcements — what direction are they moving?
- Are they expanding into new markets or doubling down?

---

## Step 3: Build a Comparison Matrix

After gathering data, create a side-by-side matrix. Columns = competitors (+ your planned offering). Rows = the dimensions that matter most to your target customer.

Pick 8-12 rows that are decision-relevant. Examples:
- Price (monthly, annual)
- Ease of setup (1-5 scale based on reviews)
- Key feature A
- Key feature B
- Integration with [popular tool]
- Free tier available?
- Customer support quality
- Speed / performance
- Customization depth

**Fill in each cell with what you know.** Leave gaps where you genuinely don't know — gaps in your knowledge are research tasks, not guesses.

---

## Step 4: Synthesize Into Exploitable Gaps

From your matrix and review analysis, identify your top 3 exploitable gaps. A gap is exploitable when ALL of these are true:

1. **Multiple competitors share the weakness** — it's not just one player being sloppy; it's a structural blind spot in the market.
2. **Customers actually complain about it** — you have review evidence that real people care.
3. **You can solve it** — given your skills, budget, and timeline as a solopreneur.
4. **It's not table stakes** — if everyone does it, you can't win by doing it too. The gap must be something competitors skip or do poorly.

**For each exploitable gap, write:**
- What the gap is
- Evidence (specific complaints or data)
- How you would solve it
- Why competitors likely aren't solving it (too niche for them? Requires a different business model? Conflicts with their strategy?)

---

## Step 5: Define Your Competitive Wedge

Your "wedge" is the single, sharp angle you enter the market on. It's not "we're better at everything." It's "we are the only option that does [specific thing] for [specific person]."

**Wedge formula:**
```
"The only [product category] that [does specific thing] for [specific customer type]."
```

Examples:
- "The only project management tool built specifically for solo consultants managing client work."
- "The only email marketing platform with AI-generated subject line A/B testing built into the free tier."

**Test your wedge:**
- Would a target customer immediately understand why this is different?
- Is this wedge defensible for at least 6-12 months before a competitor copies it?
- Can you build and deliver on this wedge solo?

---

## Step 6: Ongoing Competitive Monitoring

Competition doesn't stop once you launch. Set up a lightweight monitoring routine:

- **Weekly (5 min):** Check Google Alerts for top 2-3 competitor names. Scan for new features, pricing changes, funding news.
- **Monthly (30 min):** Re-read 5-10 new reviews on G2/Capterra for your competitors. Are new complaints emerging?
- **Quarterly (2 hours):** Re-run the comparison matrix. Have gaps closed? Have new gaps opened? Has a new competitor appeared?

---

## Pitfalls
- Copying a competitor's strategy instead of finding gaps. Copying loses on price and polish against incumbents.
- Obsessing over one well-funded competitor and ignoring the small players who actually serve your niche.
- Reading only positive reviews. Negative reviews are 10x more valuable for finding gaps.
- Forgetting that "doing nothing" is always a competitor. Some customers will stick with their manual workaround rather than switch.
