# Progress Tracking

## Core Metrics (Universal)

Track these across any competitive domain:

| Metric | Why It Matters |
|--------|----------------|
| Win rate (overall) | Baseline performance |
| Win rate vs. target tier | Are you competitive where you want to be? |
| Loss patterns | What keeps causing losses? |
| Improvement velocity | Rate of win% change over time |
| Lesson → win conversion | Do analyzed losses turn into wins? |

---

## Domain-Specific Tracking

### Gaming/Esports
- Rank/MMR over time
- Win rate by character/agent/hero
- Loss rate by opponent character/strategy
- Performance by time of day
- Tilt indicators (loss streaks, rage quits)

### Sports/Athletic
- Times/scores vs. rivals
- Performance by segment (hills, sprints, transitions)
- Training load → race performance correlation
- Head-to-head records
- Progression toward qualification standards

### Business/Sales
- Win/loss ratio by deal size
- Close rate by lead source
- Deals lost by reason (price, feature, timing)
- Competitor win rate against you
- Pipeline velocity changes

### Academic
- Grades by subject/topic
- Question types missed most
- Study time → score correlation
- Rank/percentile in class
- Application success rate

---

## Progress Dashboard Template

```markdown
# [Domain] Competitive Progress

## Current Standing
- Overall record: W-L (%)
- Current streak:
- vs. Target tier: W-L (%)

## Recent Trend (Last 30 Days)
- Win rate change: +/-X%
- Key wins:
- Key losses:

## Active Patterns
1. [Pattern] — Status: Addressing/Fixed/New
2. [Pattern] — Status:

## Next Goals
- Short-term (30 days):
- Medium-term (90 days):

## Lessons Applied
- [Lesson from loss] → [Result when applied]
```

---

## When to Track

| Event | Action |
|-------|--------|
| After every competition | Log result, quick notes |
| After significant loss | Full analysis |
| Weekly | Review patterns, update progress |
| Monthly | Trend analysis, goal adjustment |
| Quarterly | Deep review, strategy reset |
