# Domain-Specific Competition

## Gaming/Esports

### Key Sources of Edge
- Mechanics (APM, accuracy, reaction time)
- Game knowledge (cooldowns, matchups, meta)
- Mental game (tilt control, focus, adaptation)
- Preparation (scouting opponents, studying VODs)

### What to Study from Winners
- Their decision-making in key moments
- How they handle the situations you struggle with
- Their practice routines and schedules
- Their mental approach under pressure

### Tracking Tools
- Game replays and VOD analysis
- Stat trackers (op.gg, tracker.gg, etc.)
- Personal logs of sessions and observations

---

## Sports/Athletic Competition

### Key Sources of Edge
- Physical conditioning (specific to sport)
- Technical skill (form, technique)
- Tactical intelligence (pacing, positioning)
- Mental toughness (pain tolerance, focus)

### What to Study from Winners
- Their training volume and intensity distribution
- How they perform in specific segments (hills, sprints)
- Their race/match tactics
- Their recovery and periodization

### Tracking Tools
- GPS/fitness trackers (Strava, Garmin)
- Video analysis of technique
- Training logs with load and recovery metrics

---

## Business Competition

### Key Sources of Edge
- Product/service quality
- Sales execution (pitch, objection handling)
- Pricing and positioning
- Speed and responsiveness
- Relationships and network

### What to Study from Winners
- Why customers choose them over you
- Their pricing and packaging
- Their sales process and messaging
- Their hiring and team structure

### Tracking Tools
- CRM with win/loss tracking
- Competitive intelligence monitoring
- Customer feedback and churn analysis

---

## Academic Competition

### Key Sources of Edge
- Study efficiency (methods, focus)
- Knowledge depth (understanding vs. memorization)
- Test-taking skill (time management, question interpretation)
- Application quality (essays, interviews)

### What to Study from Winners
- Their study schedules and methods
- Successful application materials
- How they present achievements
- Their mentor and recommender relationships

### Tracking Tools
- Grade tracking by subject/topic
- Practice test score progression
- Application outcome tracking

---

## Universal Principles

Regardless of domain:

1. **Losses are data, not just outcomes**
2. **Winners leave trails you can follow**
3. **Small edges compound over time**
4. **Deliberate practice beats random repetition**
5. **Feedback loops close faster with measurement**
