# Deep Loss Analysis

## The 5-Layer Breakdown

When a simple "why did I lose?" isn't enough, go deeper:

### Layer 1: The Moment
Identify the exact point where the outcome became inevitable.
- In games: the throw, the mistake, the failed read
- In business: the objection you couldn't handle, the feature gap
- In sports: the split where you lost contact, the point sequence
- In academics: the question type you blanked on

### Layer 2: The Decision
What decision led to that moment?
- What information did you have?
- What options did you consider?
- Why did you choose what you chose?
- What was the better choice (in hindsight)?

### Layer 3: The Pattern
Is this decision type a recurring issue?
- Check loss history for similar moments
- Look for situational triggers (stress, fatigue, specific opponent)
- Identify if this is a skill gap, knowledge gap, or mental gap

### Layer 4: The Root Cause
Why does this pattern exist?
- Insufficient practice in this area?
- Wrong mental model?
- Missing information?
- Emotional/psychological trigger?

### Layer 5: The Fix
What specifically will you do differently?
- Concrete action, not vague intention
- Measurable if possible
- Scheduled if it requires practice

---

## Analysis Templates

### Quick Analysis (< 5 min)
```
Loss: [opponent/event, date]
Moment: [when it shifted]
Lesson: [one sentence]
Action: [what I'll do]
```

### Full Analysis
```
Date:
Domain:
Opponent/Event:
Result:

THE MOMENT
- What happened:
- Timestamp/context:

THE DECISION
- What I chose:
- What I should have done:
- Why I made the wrong choice:

THE PATTERN
- Similar losses: [list]
- Common thread:

ROOT CAUSE
- Skill gap:
- Knowledge gap:
- Mental/emotional:

THE FIX
- Specific action:
- Practice schedule:
- How I'll know it's fixed:
```

---

## Avoiding Analysis Pitfalls

| Pitfall | Correct Approach |
|---------|------------------|
| "They got lucky" | What put you in a position where luck mattered? |
| "External factors" | What could you have done given those factors? |
| "I just played bad" | Which specific decisions were bad? Why? |
| "I need to try harder" | Try harder at WHAT specifically? |
| "Next time will be different" | What SPECIFICALLY will be different? |

The goal is actionable insight, not comfort.
