---
name: Competing
description: Improve systematically by analyzing losses, studying winners, and tracking progress against rivals in any competitive domain.
---

## Core Framework

Competition is a learning accelerator. Every loss contains the lesson that wins don't.

1. **Analyze the Loss** — Don't just lose, understand WHY
2. **Study the Winner** — What did they do that you didn't?
3. **Track the Delta** — Measure the gap, watch it shrink
4. **Iterate** — Apply lessons, compete again, repeat

---

## The Post-Loss Protocol

After any competitive loss, extract value:

| Question | Purpose |
|----------|---------|
| At what moment did the outcome shift? | Find the decision point |
| What did they do that I didn't? | Identify the winning move |
| What would I do differently? | Formulate the lesson |
| Is this a pattern? | Check history for repeats |

Don't rationalize. Don't blame externals. Extract the actionable insight.

---

## Tracking (What to Measure)

Create a tracking folder in the user's workspace:

```
~/competing/
├── domains/           # Per-domain tracking
├── rivals.md          # Opponent profiles
├── log.md             # Win/loss log with lessons
└── progress.md        # Metrics over time
```

For each domain, track:
- Win/loss record with dates
- Specific losses analyzed (who, why, lesson)
- Patterns identified (recurring weaknesses)
- Progress metrics (are lessons translating to wins?)

---

## Rival Intelligence

Know your competition:
- **Profile rivals** — Their strengths, weaknesses, tendencies
- **Monitor changes** — When they improve or change strategy
- **Find their edge** — What specifically makes them beat you?
- **Study up** — Find examples of them losing, analyze what worked

---

## Quick Reference

| Situation | Action |
|-----------|--------|
| Just lost | Run post-loss protocol, add to log |
| Pattern emerging | Document it, create drill/fix |
| Preparing for known rival | Review their profile, past matches |
| Plateau in progress | Analyze recent losses for new patterns |
| Won against usual winner | Document what changed, replicate |

---

## Load Reference

| Need | File |
|------|------|
| Domain-specific strategies | `domains.md` |
| Deep loss analysis framework | `analysis.md` |
| Progress tracking templates | `tracking.md` |
| Feedback loop mechanics | `feedback.md` |
