# Comparison Traps

Common mistakes that invalidate comparisons.

## Research Traps

- **Anchoring**: First item researched gets more depth. Consciously balance effort.
- **Availability bias**: Easy-to-find info weighted too heavily. Seek harder-to-find data too.
- **Confirmation research**: Seeking data to support initial impression. Research both fairly.
- **Unequal effort**: 10 min on A, 2 min on B = invalid results. Track time per item.

## Scoring Traps

- **False precision**: 7.2 vs 7.3 is noise, not signal. Use whole numbers.
- **Recency bias**: Latest data isn't always best data. Consider trends.
- **Halo effect**: One strong criterion inflates others. Score independently.

## Presentation Traps

- **Burying caveats**: Confidence issues hidden at the end. Lead with uncertainty.
- **Missing weights**: Showing scores without weights misleads. Always show the math.
- **Ignoring context**: Same comparison, different user = different weights.

## Recovery

When you catch yourself in a trap:
1. Acknowledge it explicitly
2. Re-research the affected dimension
3. Rescore with balanced data
4. Note the correction in output
