# Default Comparison Criteria by Domain

Use as starting point. User preferences override.

## Products / Physical Goods

| Criterion | Default Weight | Notes |
|-----------|----------------|-------|
| Price | 25% | Include total cost of ownership |
| Quality/Durability | 25% | Reviews, materials, warranty |
| Features | 20% | Must-haves vs nice-to-haves |
| Availability | 15% | In stock, shipping time |
| Support/Warranty | 15% | Return policy, customer service |

## Software / Tools

| Criterion | Default Weight | Notes |
|-----------|----------------|-------|
| Functionality | 30% | Does it solve the core problem? |
| Ease of use | 25% | Learning curve, UX |
| Price/Value | 20% | Including hidden costs, scaling |
| Integration | 15% | Works with existing stack? |
| Support/Docs | 10% | Community, documentation quality |

## Services / Subscriptions

| Criterion | Default Weight | Notes |
|-----------|----------------|-------|
| Value delivered | 30% | ROI, outcomes |
| Cost | 25% | Monthly, annual, hidden fees |
| Reliability | 20% | Uptime, consistency |
| Flexibility | 15% | Cancel anytime, tier changes |
| Support | 10% | Response time, quality |

## Decisions / Paths

| Criterion | Default Weight | Notes |
|-----------|----------------|-------|
| Outcome potential | 30% | Best case scenario |
| Risk | 25% | Worst case, probability |
| Reversibility | 20% | Can you undo it? |
| Opportunity cost | 15% | What you give up |
| Effort required | 10% | Time, energy, resources |

## Locations / Places

| Criterion | Default Weight | Notes |
|-----------|----------------|-------|
| Purpose fit | 30% | Does it serve the goal? |
| Accessibility | 25% | Distance, transport, parking |
| Cost | 20% | Entry, associated expenses |
| Atmosphere | 15% | Vibe, noise, crowd |
| Availability | 10% | Hours, reservations, wait |

## People / Providers

| Criterion | Default Weight | Notes |
|-----------|----------------|-------|
| Competence | 35% | Track record, skills |
| Reliability | 25% | Availability, follow-through |
| Cost | 20% | Rates, value ratio |
| Communication | 15% | Responsiveness, clarity |
| Fit | 5% | Personal compatibility |

## Investments / Financial

| Criterion | Default Weight | Notes |
|-----------|----------------|-------|
| Expected return | 25% | Realistic projections |
| Risk level | 25% | Volatility, downside |
| Liquidity | 20% | Can you exit when needed? |
| Time horizon fit | 15% | Matches your timeline? |
| Complexity | 15% | Management overhead |

## Content / Media

| Criterion | Default Weight | Notes |
|-----------|----------------|-------|
| Relevance | 35% | Matches current need/interest |
| Quality | 30% | Production value, depth |
| Length/Time | 20% | Fits available time? |
| Source credibility | 15% | Trustworthy creator? |

---

## Adjusting Weights

These are starting points. Adjust based on:

1. **Explicit user statement**: "Price doesn't matter" → reduce weight
2. **Context signals**: Urgent need → increase availability weight
3. **Past behavior**: User always asks about X → increase X weight
4. **Category specifics**: Luxury purchase → quality > price

**Document adjustments** in preferences.md for future comparisons.
