# Common Functions → Skills Mapping

## Customer-Facing

| Function | Likely Skills | Notes |
|----------|---------------|-------|
| Customer support | Email handling, FAQ, escalation | Start with L1, keep humans on L2+ |
| Sales outreach | Email sequences, CRM updates | Agent qualifies, human closes |
| Account management | Check-ins, renewal tracking | Agent monitors, human relationships |

## Operations

| Function | Likely Skills | Notes |
|----------|---------------|-------|
| Scheduling | Calendar, resource allocation | Fully delegatable |
| Inventory | Stock tracking, reorder alerts | Set thresholds, agent executes |
| Vendor management | PO processing, communication | Templates + oversight |
| Fulfillment | Order processing, shipping | High automation potential |

## Finance

| Function | Likely Skills | Notes |
|----------|---------------|-------|
| Invoice processing | Data extraction, matching | Review exceptions only |
| Expense tracking | Categorization, reporting | Agent categorizes, human approves over threshold |
| Payroll prep | Time aggregation, calculation | Agent preps, human verifies |
| Reporting | Dashboard updates, summaries | Fully delegatable |

## People

| Function | Likely Skills | Notes |
|----------|---------------|-------|
| Resume screening | Initial filter, scheduling | Agent screens, human interviews |
| Onboarding | Docs, access setup, training scheduling | Checklist automation |
| Time tracking | Aggregation, anomaly flagging | Agent flags, manager reviews |

## Marketing

| Function | Likely Skills | Notes |
|----------|---------------|-------|
| Content calendar | Scheduling, publishing | Agent executes plan |
| Social monitoring | Mentions, sentiment | Agent reports, human responds |
| Analytics | Report generation, trend detection | Fully delegatable |
| Email campaigns | Segmentation, scheduling | Agent executes, human creates |

## Legal/Compliance

| Function | Likely Skills | Notes |
|----------|---------------|-------|
| Contract review | Clause flagging, comparison | Agent highlights, lawyer reviews |
| Compliance monitoring | Checklist tracking, alerts | Agent monitors, human decides |
| NDA processing | Template matching, redlining | Standard = agent, custom = lawyer |

## Custom Skill Triggers

Create a custom skill when:
- No existing skill covers the function
- Business logic is proprietary
- Integration is company-specific
- Domain expertise is unique

Template for custom skill definition:
```
Function: [what it does]
Inputs: [what triggers it]
Outputs: [what it produces]
Boundaries: [what it should NOT do]
Human checkpoints: [when to escalate]
```
