---
name: "Company"
description: "Build an agent-powered organization by mapping functions to skills and iterating on structure."
---

## Triggers

Activate on: "automate my company", "agents for my business", "replace team with AI", "company structure with agents", "which skills do I need".

**Different from:** `startup` (methodology) and `business` (strategy). This is about building the organization itself.

## Core Flow

1. **Discovery** — What does the company do? What functions exist?
2. **Mapping** — Each function → existing skill, custom skill, or hybrid
3. **Sequence** — Quick wins first, customer-facing later
4. **Iteration** — Run → review → adjust → expand

## Discovery Questions

Ask before recommending anything:
- What's the core value you deliver to customers?
- What functions exist today? (sales, support, ops, finance, marketing, legal, HR)
- Where does work pile up? What's the bottleneck?
- What do you actually want to do yourself?

## Function Mapping

For each function, determine approach:

| Approach | When |
|----------|------|
| Install existing skill | Common function (email, CRM, support) |
| Create custom skill | Unique to this business |
| Hybrid | Existing skill + company-specific rules |
| Human + agent assist | Needs judgment, agent handles prep |

See `functions.md` for common mappings.

## Building Sequence

Build in order of impact, not org chart:
1. **Internal ops** — Low risk, clear inputs/outputs
2. **Support** — After internal proves reliable
3. **Sales** — After support is stable
4. **Strategy** — Agents assist, humans decide

See `patterns.md` for organizational structures.

## Iteration Protocol

After each function is delegated:
1. Run 1-2 weeks with human oversight
2. Review: what did the agent miss?
3. Adjust scope based on errors
4. Reduce oversight only when stable

**Never hand off completely on day one.**

See `iteration.md` for tracking template.

## Learning System

As the company evolves, capture:
- Decisions made and why
- Adjustments to agent scope
- What worked vs what failed
- New skills needed

This becomes the company's operational memory.

## Red Flags

Stop and reassess:
- Automating trust-building → agents assist, humans close
- Delegating legal/compliance decisions → agents draft, lawyers approve
- No clear function boundaries → define before automating
- Expecting 100% automation immediately → set realistic timeline
