- # Company Research V2 Skill

  基于多源搜索的公司调研工具，生成“对标天眼查/企查查信息颗粒度”的结构化报告。
  不依赖易失效的站点爬虫脚本：通过 kimi_search + kimi_fetch 对公开网页/公告/新闻/监管披露进行实时检索与深挖，
  并对信息做：实体消歧 → 交叉验证 → 结构化汇总 → 风险标注。

  ---

  ## ✅ When to Use

  当用户需要以下任一任务时使用：
  - 查公司 / 公司调研 / 公司背景 / 尽调框架
  - 工商信息（成立、注册资本、法定代表人、股东、变更等）
  - 股权结构 / 穿透股权 / 最终受益人（公开来源可推断则给出）
  - 对外投资 / 分支机构 / 子公司结构
  - 融资历史 / 投资方 / 估值（以公告、媒体、工商变更等为证）
  - 司法风险 / 被执行 / 失信 / 开庭公告 / 裁判文书
  - 经营风险（行政处罚、经营异常、严重违法、税务/环保/安全等公开披露）
  - 知识产权（商标、专利、著作权）
  - 招投标 / 政府采购 / 重大合同（公开平台）
  - 用工与舆情（招聘画像、媒体报道、负面舆情）
  - 竞品与行业地位分析

  ---

  ## 🧰 Tools Required

  - kimi_search（多源搜索：新闻/公告/监管/百科/招聘/招投标/司法公开等）
  - kimi_fetch（抓取关键页面全文，用于核验细节与提取字段）
  - (optional) web_search / web_fetch 作为兜底（当 kimi 结果不足或需要补充国际信息）

  ---

  ## 🎯 Output Standard

  1) 以“天眼查/企查查常见模块”为纲，输出结构化报告  
  2) 每条关键结论尽量做到“至少两处来源交叉验证”  
  3) 对所有关键信息标注：
  - **来源 URL/标题**
  - **抓取日期**
  - **一致性（多源一致/单源）**
  - **可信度等级（A/B/C）**
  4) 明确声明：公开搜索 ≠ 付费数据库全量数据；无法获取的字段要标注“未检索到/疑似需付费/需内部渠道”。

  ---

  ## 🧭 Workflow

  ### Step 0 — 实体识别与消歧（必须做）
  目标：确认用户要查的是哪一家主体，避免同名公司混淆。

  **动作：**
  - 用 kimi_search 同时检索：
    - 公司全称 + 简称 + 品牌名
    - 可能的主体：XX有限公司、XX科技、XX网络、XX运输
    - “统一社会信用代码/注册号/法定代表人/总部城市”关键词

  **输出：**
  - 给出“候选主体列表”（最多 5 个），并选定“主分析对象（Primary Entity）”
  - 标注选择依据（如：官网备案、工商条目、媒体一致提及）

  > 若无法唯一消歧：报告仍可输出，但需加显著提示：主体存在歧义，结论仅对候选集合成立。

  ---

  ### Step 1 — 搜索阶段（覆盖维度）
  用 kimi_search 分模块检索，建议每模块至少 3～5 条结果：

  #### 1) 工商与主体信息
  - 公司全称/简称/曾用名
  - 统一社会信用代码（如公开可见）
  - 成立日期、注册资本、实缴资本（公开可见则给）
  - 法定代表人、主要人员（董监高公开信息）
  - 登记状态（存续/注销/吊销等）
  - 登记机关、核准日期
  - 注册地址/办公地址（公开披露）
  - 经营范围（以工商/公告为准）

  #### 2) 股权结构与控制权（对标天眼查/企查查）
  - 股东列表、持股比例（公开披露）
  - 出资方式/认缴实缴变化（工商变更/公告）
  - 控股股东、实际控制人（可推断则给“推断链路”）
  - 穿透路径（仅基于公开来源可复核的链路）

  #### 3) 对外投资/分支机构/子公司
  - 对外投资公司清单（公开来源）
  - 分公司/办事处（如公开）
  - 重要关联公司（同法人/同地址/同品牌）

  #### 4) 工商变更与重大事项时间线
  - 法人/股东/注册资本/地址/经营范围变更
  - 名称变更（曾用名）
  - 股权出质、动产抵押（如公开平台可检索）

  #### 5) 融资与资本运作
  - 融资轮次、时间、金额、投资方（以公告/权威媒体/工商变更交叉验证）
  - 并购/重组/股权转让
  - 若上市公司相关：公告、年报、投资者关系材料

  #### 6) 司法风险（对标“司法风险”模块）
  - 裁判文书（案由、角色：原告/被告、判决要点）
  - 开庭公告
  - 被执行人/限制高消费
  - 失信被执行人（如公开）
  - 重点：筛出“与主营业务强相关/金额较大/频次异常”的案件

  #### 7) 经营风险（对标“经营风险/经营异常/行政处罚”）
  - 行政处罚（市场监管、交通、税务、环保、网信等公开披露）
  - 经营异常名录/严重违法（如公开可查）
  - 抽查检查结果（如公开）
  - 安全生产/环保/数据合规相关处罚（若有）

  #### 8) 知识产权与资质（对标“知识产权/资质证照”）
  - 商标（核心品牌、类别）
  - 专利（发明/实用新型/外观）
  - 软件著作权
  - 行业资质（如：运输许可、增值电信许可、支付/小贷牌照等——按行业扩展）

  #### 9) 招投标/政府采购/重大合作
  - 招投标中标公告
  - 政府采购合同
  - 重要合作伙伴披露（公告/新闻/官网）

  #### 10) 招聘与组织画像（对标“招聘信息/人员规模”）
  - 招聘平台岗位类型、技术栈、城市分布
  - 薪酬区间（如公开）
  - 组织能力推断：研发/运营/销售/风控/合规等侧重

  #### 11) 舆情与新闻（对标“新闻动态”）
  - 近 3/6/12 个月关键新闻
  - 负面舆情：投诉、监管点名、重大事故、数据泄露等
  - 对每条新闻标注：来源级别（官方/权威媒体/自媒体）与可信度

  #### 12) 竞争格局与行业位置
  - 竞品清单（直接竞品/替代品/上下游）
  - 市场份额（若无权威数据则不硬编）
  - 差异化要点：定价、渠道、合规资质、技术壁垒

  ---

  ### Step 2 — 深度获取（kmi_fetch 抓关键页）
  对以下“高价值证据页”必须 fetch：
  - 官网/官方公告/监管通告
  - 上市公司年报/公告（如相关）
  - 判决书/执行信息详情页（能打开则抓）
  - 工商变更明细页面（若公开网页可见）
  - 招投标中标公告正文

  抓取目标：把关键字段“抠出来”，而不是只引用 snippet。

  ---

  ### Step 3 — 整理输出（结构化报告 + 证据链）
  报告必须分两层：
  1) **结论层（给业务/投委/老板看）**
  2) **证据层（给尽调/法务/分析师复核）**

  ---

  ## 输出格式（只需要输出下方内容即可）

  ```markdown
  ## 🔍 {公司名称} 公司调研报告
  
 - 报告生成时间：{YYYY-MM-DD}
 - 主体口径：{Primary Entity 公司全称 + 地区 + 统一社会信用代码(若公开)}
 - 数据来源：公开网页多源检索（非付费数据库直连），关键结论已尽量交叉验证
  
  ---
  
  ### 0️⃣ 调查主体
  - 候选主体：
    - A: xxx（依据：...）
    - B: xxx（依据：...）
  - 本报告选定主主体（Primary）：xxx
  - 仍存疑点：xxx（如有）
  
  ---
  
  ### 1️⃣ 基本信息

  | 项目 | 内容 | 可信度 | 证据 |
  |------|------|--------|------|
  | 公司全称 | xxx | A | [来源1] |
  | 曾用名 | xxx | B | [来源2] |
  | 成立时间 | xxx | A | [来源] |
  | 注册资本 | xxx | B | [来源] |
  | 实缴资本 | xxx/未披露 | C | [来源] |
  | 法定代表人 | xxx | A | [来源] |
  | 登记状态 | 存续/注销... | A | [来源] |
  | 统一社会信用代码 | xxx/未披露 | B/C | [来源] |
  | 注册地址 | xxx | B | [来源] |
  | 总部/办公地（推断） | xxx | C | [来源] |
  | 行业/业务标签 | xxx | B | [来源] |
  | 经营范围要点 | xxx | B | [来源] |
  
  ---
  
  ### 2️⃣ 股权结构与控制权
  #### 2.1 股东结构（可见范围内）
  | 股东 | 持股比例 | 变更记录 | 可信度 | 证据 |
  |------|----------|----------|--------|------|
  | xxx | xx% | xxxx | B | [来源] |
  
  #### 2.2 控股/实控与穿透（仅基于可复核公开链路）
  - 控股股东：xxx（依据：...）
  - 实际控制人：xxx（依据：...）
  - 穿透路径（如适用）：A → B → C
  
  > 注：若未检索到可靠穿透链路，明确标注“公开信息不足，无法确认最终受益人”。
  
  ---
  
  ### 3️⃣ 对外投资 / 子公司 / 分支机构
  - 关键子公司（Top N）：
    - xxx（角色/业务：...，地区：...）
  - 对外投资摘要：
    - 投资标的、比例、时间（若公开）
  - 关联主体提示：
    - 同法人/同地址/同品牌等线索（需谨慎）
  
  ---
  
  ### 4️⃣ 工商变更与里程碑时间线
  | 时间 | 事项 | 影响解读 | 可信度 | 证据 |
  |------|------|----------|--------|------|
  | YYYY-MM | 法人变更 | ... | B | [来源] |
  
  ---
  
  ### 5️⃣ 融资与资本运作
  | 时间 | 轮次/事件 | 金额 | 投资方/交易对手 | 可信度 | 证据 |
  |------|-----------|------|----------------|--------|------|
  | YYYY-MM | A轮 | xx | xxx | B | [来源] |
  
  - 融资可信度规则：
    - A：官方公告/监管披露/上市公司公告
    - B：权威财经媒体多源一致
    - C：单一媒体或自媒体（仅作线索）
  
  ---
  
  ### 6️⃣ 司法风险（诉讼/执行/失信）
  #### 6.1 风险概览
  - 裁判文书：x 起（可见范围）
  - 被执行：x 条（可见范围）
  - 失信：x 条（可见范围）
  - 开庭公告：x 条（可见范围）
  
  #### 6.2 重点案件（金额大/频次高/与主营强相关）
  | 案号/时间 | 案由 | 角色 | 结果/进展 | 金额 | 风险解读 | 证据 |
  |----------|------|------|-----------|------|----------|------|
  | xxx | xxx | 被告 | xxx | xx | xxx | [来源] |
  
  ---
  
  ### 7️⃣ 经营风险（行政处罚/异常/合规）
  | 类型 | 事件 | 时间 | 主管机关/平台 | 风险等级 | 证据 |
  |------|------|------|---------------|----------|------|
  | 行政处罚 | xxx | YYYY-MM | xxx | 中/高 | [来源] |
  
  - 经营异常/严重违法：{有/无/未检索到}
  
  ---
  
  ### 8️⃣ 知识产权与资质
  - 商标：核心品牌/类别/状态（若公开）
  - 专利：数量/类型/重点专利（若公开）
  - 软件著作权：代表性条目（若公开）
  - 行业资质：与业务强相关证照（若公开）
  
  ---
  
  ### 9️⃣ 招投标 / 政府采购 / 重大合作
  | 时间 | 项目 | 甲方/采购方 | 金额 | 可信度 | 证据 |
  |------|------|-------------|------|--------|------|
  | YYYY | xxx | xxx | xx | B | [来源] |
  
  ---
  
  ### 🔟 招聘与组织画像（辅助判断业务重心）
  - 招聘城市分布：...
  - 岗位结构：研发/产品/运营/销售/合规/风控占比线索
  - 技术栈线索：...
  
  ---
  
  ### 1️⃣1️⃣ 最新动态（近 3/6/12 个月）
  | 日期 | 事件 | 影响判断 | 可信度 | 证据 |
  |------|------|----------|--------|------|
  | YYYY-MM-DD | xxx | xxx | B | [来源] |
  
  ---
  
  ### 1️⃣2️⃣ 行业地位 / 竞争格局
  - 行业定位：...
  - 直接竞品：A/B/C
  - 替代品/上下游：...
  - 差异化与壁垒：...
  
  ---
  
  ## ⚠️ 风险提示（Important）
  - 本报告基于公开检索信息，不等同于天眼查/企查查付费数据库全量字段。
  - 股权穿透、实缴、历史变更、司法全量等可能存在“公开不可见/需付费/需线下渠道”的缺口。
  - 对单源信息（尤其自媒体/论坛）只作线索，不作事实结论。
  - 若主体存在同名/多品牌/多主体运营，需进一步确认统一社会信用代码口径。
  
  ---
  
  ## ✅ 总结（Executive Summary）
  - 一句话概括：...
  - 核心结论 3-5 条：
    1) ...
    2) ...
    3) ...
  - 主要风险 3-5 条：
    1) ...
    2) ...
    3) ...



## **🔎 Search Playbook（推荐检索 Query 模板）**

> 每个模块都用“公司名/主主体全称 + 关键词”的组合检索，优先选择权威源。

- 工商基础：{公司} 统一社会信用代码 注册资本 法定代表人 成立时间
- 股东股权：{公司} 股东 持股 比例 工商变更 出资
- 子公司投资：{公司} 对外投资 子公司 分公司 关联公司
- 变更记录：{公司} 变更 法人变更 注册资本变更 地址变更 曾用名
- 融资：{公司} 融资 A轮 投资方 金额 估值
- 司法：{公司} 裁判文书 案号 被执行人 限制高消费 失信
- 行政处罚/异常：{公司} 行政处罚 经营异常 严重违法 监管通报
- IP：{公司} 商标 专利 软件著作权
- 招投标：{公司} 中标 公告 政府采购 合同
- 招聘：{公司} 招聘 岗位 薪资 技术栈
- 舆情：{公司} 投诉 负面 事故 维权 监管


## **🧪 Evidence & Confidence Rules（必遵守）**


- 可信度 A：政府/法院/监管/交易所公告、上市公司年报公告、公司官网正式公告
- 可信度 B：权威媒体/行业协会报告，且多源一致
- 可信度 C：单一媒体、自媒体、论坛，仅做线索
- 

交叉验证优先级：

A(官方) > B(权威媒体多源) > C(线索)

## **🧩 Notes**

- 不做站点爬虫，不绕过登录/付费墙，不试图获取非公开数据。
- 若用户明确要求“对标天眼查字段”，可以输出“字段缺口清单”，并解释为何缺口存在（公开不可得/需付费/需内网/需线下）。
- 对于品牌型公司（多主体运营），必须把“品牌—主体映射关系”作为第一优先级结论。
- 无需给出调查步骤，只需要给出最后报告即可。
