# Memory System Guide

How to remember someone well enough to be a real companion.

## Folder Structure

```
~/companion/
├── memory.md       # Always loaded first
├── topics.md       # What they like discussing
├── routines.md     # Their daily life
└── history.md      # Past conversations
```

## memory.md (HOT — Always Loaded)

Keep under 100 lines. Core information about them.

```markdown
# Companion Memory

## Who They Are
- Name: 
- Age/generation: 
- Living situation: (alone, with family, care facility)
- Location: 

## Current Situation
- Health: (general notes, not medical advice territory)
- Daily life: (retired, working, caregiving)
- Mood lately: (how they've seemed recently)

## Key People
- Family: (names, relationships, how often they see them)
- Caregivers: (if relevant)
- Friends: (who they mention)
- Pets: (names, types)

## What They Enjoy
- Topics: (gardening, old movies, grandchildren)
- Routines: (morning tea, evening news)
- Memories: (stories they like to tell)

## What to Avoid
- Sensitive topics: (loss they don't want to discuss)
- Frustrations: (things that upset them)

## How They Reach Out
- Typical times: (morning, evening, random)
- Platform/method: 
- Communication style: (brief, chatty, formal)

## Recent
- Last conversation: (date, brief note)
- Open threads: (things to follow up on)

---
*Last updated: YYYY-MM-DD*
```

## topics.md

What they enjoy talking about, in more detail.

```markdown
# Conversation Topics

## Favorites
- Gardening: roses especially, has tips
- Classic films: loves Hitchcock
- Grandchildren: Emma (7) and Jack (5)

## Their Stories
- How they met their spouse: love telling this
- Career: was a teacher for 30 years
- Travel: trip to Italy in 1985

## Current Interests
- Show they're watching: 
- Book they're reading: 
- News they follow: 

## Light Topics (Always Safe)
- Weather
- Seasonal things
- Food and cooking

## Topics to Navigate Carefully
- [topic]: [why]
```

## routines.md

Understanding their daily life.

```markdown
# Their Routines

## Daily
- Morning: tea, news
- Afternoon: garden, nap
- Evening: TV, early bed

## Weekly
- Sunday: calls with daughter
- Wednesday: grocery delivery

## Regular Events
- Doctor appointments
- Family visits
- Church/community

## When They Reach Out
- Usually: [time of day]
- More often when: [feeling lonely, can't sleep, bored]

## Energy Patterns
- Best time of day: 
- Low energy: 
```

## history.md

Archive of past conversations. Move old entries here.

```markdown
# Conversation History

## 2026-02

### Feb 15
- Talked about upcoming doctor visit, nervous
- Mentioned Emma's school play next week
- Seemed in good spirits

### Feb 12
- Quieter than usual
- Husband's birthday would have been today
- Just listened, didn't push

## 2026-01
[Older entries...]
```

## How I Learn

**From what they share:** Names, places, stories — I note them.

**From patterns:** If they always reach out after dinner, I know their rhythm.

**From corrections:** If I get something wrong, I update.

**From what they don't say:** Avoiding a topic tells me something too.

## Memory Rules

1. **memory.md always loads** — keep it lean
2. **Topic files on demand** — load when relevant
3. **Update after significant conversations** — don't let knowledge go stale
4. **Respect privacy** — store what's useful, not everything
5. **Archive old data** — history.md prevents clutter
