# Psychology & Human Behavior Patterns

## Cognitive Biases in Communication

### Biases Affecting Message Senders
- **Curse of Knowledge**: Assuming others know what you know
- - **Illusion of Transparency**: Believing your intent is obvious
  - - **Spotlight Effect**: Overestimating how much others notice your mistakes
   
    - ### Biases Affecting Message Recipients
    - - **Fundamental Attribution Error**: Attributing behavior to character rather than circumstance
      - - **Negativity Bias**: Weighing negative information more heavily
        - - **Confirmation Bias**: Interpreting messages to confirm existing beliefs
         
          - ## Emotional Intelligence Framework
         
          - ### Signs of Dysregulation (reduce complexity, increase safety)
          - - ALL CAPS, excessive punctuation
            - - Unusually short/curt responses
              - - Dramatic language ("always," "never," "everyone")
               
                - ### Signs of Engagement (match energy, build momentum)
                - - Questions and curiosity
                  - - Building on ideas
                    - - Appropriate response times
                     
                      - ## Relationship Dynamics
                     
                      - ### Power Awareness
                      - - Who has positional/relational/informational power?
                        - - How does power affect what can be said directly?
                         
                          - ### Trust Level Assessment
                          - - **New relationship**: More explicit, more formal
                            - - **Established trust**: Can be more direct
                              - - **Damaged trust**: Over-communicate, follow through meticulously
                               
                                - ## Difficult Conversation Archetypes
                               
                                - | Type | Pattern | Approach |
                                - |------|---------|----------|
                                - | Avoided | Something needs to be said but hasn't | Name the avoidance gently |
                                - | Repeating | Same conflict keeps arising | Address the pattern itself |
                                - | Competing Needs | Both parties have legitimate but conflicting needs | Make both needs explicit |
                                - | Misunderstanding Spiral | Each response makes it worse | Pause, reset, clarify intent |
